/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.util.comm;

import com.thebeastshop.pegasus.util.comm.ExcelUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxtUtil {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtil.class);
    public static final String DEFAULT_ENCODING = "utf-8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> read(InputStream is, String encoding) {
        ArrayList<String> stringList = new ArrayList<String>();
        if (NullUtil.isNull(is)) {
            return stringList;
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(is, encoding));
            String lineTxt = null;
            while (NullUtil.isNotNull(lineTxt = bufferedReader.readLine())) {
                if ("".equals(lineTxt.trim())) continue;
                stringList.add(lineTxt);
            }
        }
        catch (Exception e) {
            try {
                log.warn("TxtUtil readTxtFile \u8bfb\u53d6\u6587\u4ef6\u5185\u5bb9\u51fa\u9519", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedReader);
                IOUtils.closeQuietly((InputStream)is);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)bufferedReader);
            IOUtils.closeQuietly((InputStream)is);
        }
        IOUtils.closeQuietly((Reader)bufferedReader);
        IOUtils.closeQuietly((InputStream)is);
        return stringList;
    }

    public static List<String> read(InputStream is) {
        return TxtUtil.read(is, DEFAULT_ENCODING);
    }

    public static List<String> read(String filePath, String encoding) {
        FileInputStream fis = null;
        try {
            File file = new File(filePath);
            if (file.isFile() && file.exists() && file.canRead()) {
                fis = new FileInputStream(file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return TxtUtil.read(fis, encoding);
    }

    public static List<String> read(String filePath) {
        return TxtUtil.read(filePath, DEFAULT_ENCODING);
    }
}

