/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.util.comm;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;

public class ImgCompressUtil {
    private static final Logger logger = Logger.getLogger(ImgCompressUtil.class.getName());

    public static void main(String[] args) {
        String url = "/upload/c671c57023e6eb83a1fa492babf0779e.jpg";
        int w = 700;
        int h = 500;
        String newName = url;
        String newDir = "/var/imgcompress/";
        String filePath = newDir + newName + "_" + w + "_" + h + url.substring(url.indexOf("."));
        ImgCompressUtil.ImgCompress(url, filePath, w, h);
    }

    public static String ImgCompress(String url, String filePath, int w, int h) {
        float JPEGcompression = 0.7f;
        url = "/var" + url;
        String name = url.substring(url.lastIndexOf("/") + 1);
        logger.info("url\uff1a===========" + url);
        logger.info("name\uff1a=========" + name);
        return ImgCompressUtil.ImgCompress(filePath, url, name, w, h, JPEGcompression);
    }

    public static String ImgCompress(String filePath, String url, String name, int w, int h, float JPEGcompression) {
        File file = new File(url);
        if (!file.exists() || !file.canRead()) {
            filePath = "/var/upload/404.jpg";
        } else {
            try {
                BufferedImage bufferedImage = ImageIO.read(file);
                int new_w = w;
                int new_h = h;
                BufferedImage image_to_save = new BufferedImage(new_w, new_h, bufferedImage.getType());
                image_to_save.getGraphics().drawImage(bufferedImage.getScaledInstance(new_w, new_h, 4), 0, 0, null);
                FileOutputStream fos = new FileOutputStream(filePath);
                int dpi = 300;
                ImgCompressUtil.saveAsJPEG(dpi, image_to_save, JPEGcompression, fos);
                fos.close();
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, null, ex);
                filePath = "/var/upload/404.jpg";
            }
        }
        return filePath;
    }

    public static void saveAsJPEG(Integer dpi, BufferedImage image_to_save, float JPEGcompression, FileOutputStream fos) throws IOException {
        ImageWriter imageWriter = ImageIO.getImageWritersBySuffix("jpg").next();
        ImageOutputStream ios = ImageIO.createImageOutputStream(fos);
        imageWriter.setOutput(ios);
        IIOMetadata imageMetaData = imageWriter.getDefaultImageMetadata(new ImageTypeSpecifier(image_to_save), null);
        if (JPEGcompression >= 0.0f && JPEGcompression <= 1.0f) {
            ImageWriteParam jpegParams = imageWriter.getDefaultWriteParam();
            jpegParams.setCompressionMode(2);
            jpegParams.setCompressionQuality(JPEGcompression);
        }
        imageWriter.write(imageMetaData, new IIOImage(image_to_save, null, null), null);
        ios.close();
        imageWriter.dispose();
    }
}

