/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.util.comm;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormatUtil {
    private static final Logger log = LoggerFactory.getLogger(FormatUtil.class);

    public static String uppercaseCurrenty(BigDecimal val) {
        try {
            return FormatUtil.stringToUpperAmount(val.toString());
        }
        catch (NumberFormatException e) {
            log.info("\u975e\u6cd5\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\uff01");
            return "\u975e\u6cd5\u6570\u636e\uff0c\u8bf7\u68c0\u67e5";
        }
    }

    public static String uppercaseCurrenty(float val) {
        return FormatUtil.stringToUpperAmount(val + "");
    }

    private static String stringToUpperAmount(String s) {
        try {
            float f = Float.valueOf(s).floatValue();
            if (f < 0.0f) {
                log.info("\u975e\u6cd5\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\uff01");
                return "\u975e\u6cd5\u6570\u636e\uff0c\u8bf7\u68c0\u67e5";
            }
            return FormatUtil.cleanZero(FormatUtil.splitNum(FormatUtil.roundString(s)));
        }
        catch (NumberFormatException e) {
            log.info("\u975e\u6cd5\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\uff01");
            return "\u975e\u6cd5\u6570\u636e\uff0c\u8bf7\u68c0\u67e5";
        }
    }

    private static String splitNum(String s) {
        if ("".equals(s)) {
            return "";
        }
        int index = s.indexOf(".");
        String intOnly = s.substring(0, index);
        String part1 = FormatUtil.numFormat(1, intOnly);
        String smallOnly = s.substring(index + 1);
        String part2 = FormatUtil.numFormat(2, smallOnly);
        String newS = part1 + part2;
        return newS;
    }

    private static String roundString(String s) {
        int index;
        if ("".equals(s)) {
            return "";
        }
        double d = Double.parseDouble(s);
        s = new DecimalFormat("##0.000").format(d = (d * 100.0 + 0.5) / 100.0);
        String intOnly = s.substring(0, index = s.indexOf("."));
        if (intOnly.length() > 13) {
            log.warn("\u8f93\u5165\u6570\u636e\u8fc7\u5927\uff01\uff08\u6574\u6570\u90e8\u5206\u6700\u591a13\u4f4d\uff01\uff09");
            return "";
        }
        String smallOnly = s.substring(index + 1);
        if (smallOnly.length() > 2) {
            String roundSmall = smallOnly.substring(0, 2);
            s = intOnly + "." + roundSmall;
        }
        return s;
    }

    private static String numFormat(int flag, String s) {
        int sLength = s.length();
        String[] bigLetter = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
        String[] unit = new String[]{"\u5143", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf", "\u4ebf", "\u62fe", "\u4f70", "\u4edf", "\u4e07"};
        String[] small = new String[]{"\u5206", "\u89d2"};
        String newS = "";
        for (int i = 0; i < sLength; ++i) {
            if (flag == 1) {
                newS = newS + bigLetter[s.charAt(i) - 48] + unit[sLength - i - 1];
                continue;
            }
            if (flag != 2) continue;
            newS = newS + bigLetter[s.charAt(i) - 48] + small[sLength - i - 1];
        }
        return newS;
    }

    private static String cleanZero(String s) {
        int i;
        if ("".equals(s)) {
            return "";
        }
        while (s.charAt(0) == '\u96f6') {
            if ((s = s.substring(2)).length() != 0) continue;
            return "\u96f6";
        }
        String[] regex1 = new String[]{"\u96f6\u4edf", "\u96f6\u4f70", "\u96f6\u62fe"};
        String[] regex2 = new String[]{"\u96f6\u4ebf", "\u96f6\u4e07", "\u96f6\u5143"};
        String[] regex3 = new String[]{"\u4ebf", "\u4e07", "\u5143"};
        String[] regex4 = new String[]{"\u96f6\u89d2", "\u96f6\u5206"};
        for (i = 0; i < 3; ++i) {
            s = s.replaceAll(regex1[i], "\u96f6");
        }
        for (i = 0; i < 3; ++i) {
            s = s.replaceAll("\u96f6\u96f6\u96f6", "\u96f6");
            s = s.replaceAll("\u96f6\u96f6", "\u96f6");
            s = s.replaceAll(regex2[i], regex3[i]);
        }
        for (i = 0; i < 2; ++i) {
            s = s.replaceAll(regex4[i], "");
        }
        s = s.replaceAll("\u4ebf\u4e07", "\u4ebf");
        return s;
    }
}

