/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.util.comm;

import com.github.junrar.Archive;
import com.github.junrar.rarfile.FileHeader;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final int BUFFER = 1024;
    private static final Logger log = LoggerFactory.getLogger(FileUtil.class);
    private static final String[] IMAGE_NAMES = new String[]{"bmp", "dib", "gif", "jfif", "jpe", "jpeg", "jpg", "png", "tif", "tiff", "ico"};

    public static Boolean exists(String filePath) {
        File file;
        Boolean result = false;
        if (EmptyUtil.isNotEmpty(filePath) && (file = new File(filePath)).exists() && file.canRead()) {
            result = true;
        }
        return result;
    }

    public static byte[] getByteFileData(String filePath) throws IOException {
        if (FileUtil.exists(filePath).booleanValue()) {
            File file = new File(filePath);
            return FileUtils.readFileToByteArray((File)file);
        }
        throw new IOException("file is not exist");
    }

    public static Boolean InputStreamTOFile(InputStream in, String filePath) throws IOException {
        if (EmptyUtil.isNotEmpty(in) && EmptyUtil.isNotEmpty(filePath)) {
            File file = new File(filePath);
            byte[] b = IOUtils.toByteArray((InputStream)in);
            FileUtils.writeByteArrayToFile((File)file, (byte[])b);
            IOUtils.closeQuietly((InputStream)in);
            return true;
        }
        return false;
    }

    public static String getExtName(String fileName) {
        if (EmptyUtil.isEmpty(fileName)) {
            return "";
        }
        if (!fileName.contains(".")) {
            return "";
        }
        return fileName.substring(fileName.lastIndexOf(".") + 1);
    }

    public static boolean isImage(String extName) {
        boolean result = false;
        if (EmptyUtil.isNotEmpty(extName) && ArrayUtils.contains((Object[])IMAGE_NAMES, (Object)extName.toLowerCase())) {
            result = true;
        }
        return result;
    }

    public static boolean isPdf(String extName) {
        boolean result = false;
        if (EmptyUtil.isNotEmpty(extName) && extName.toLowerCase().equals(FILES.PDF.value)) {
            result = true;
        }
        return result;
    }

    public static boolean isCompressed(String extName) {
        boolean result = false;
        if (EmptyUtil.isNotEmpty(extName) && (extName.toLowerCase().equals(FILES.ZIP.value) || extName.toLowerCase().equals(FILES.RAR.value))) {
            result = true;
        }
        return result;
    }

    public static boolean isRAR(String extName) {
        boolean result = false;
        if (EmptyUtil.isNotEmpty(extName) && extName.toLowerCase().equals(FILES.RAR.value)) {
            result = true;
        }
        return result;
    }

    public static boolean isZIP(String extName) {
        boolean result = false;
        if (EmptyUtil.isNotEmpty(extName) && extName.toLowerCase().equals(FILES.ZIP.value)) {
            result = true;
        }
        return result;
    }

    public static Boolean resize(int width, int height, String filePath) throws IOException {
        width = Math.max(width, 1);
        height = Math.max(height, 1);
        BufferedImage targetImage = ImageIO.read(new File(filePath));
        BufferedImage image = new BufferedImage(width, height, 1);
        image.getGraphics().drawImage(targetImage, 0, 0, width, height, Color.WHITE, null);
        String formatName = filePath.substring(filePath.lastIndexOf(".") + 1);
        return ImageIO.write((RenderedImage)image, formatName, new File(filePath));
    }

    public static void resize(int width, int height, String filePath, boolean fillWhite) {
        try {
            double ratio = 0.0;
            File file = new File(filePath);
            BufferedImage tempBufferedImage = ImageIO.read(file);
            Image targetImage = tempBufferedImage.getScaledInstance(width, height, 4);
            if (tempBufferedImage.getHeight() > height || tempBufferedImage.getWidth() > width) {
                ratio = tempBufferedImage.getHeight() > tempBufferedImage.getWidth() ? new Integer(height).doubleValue() / (double)tempBufferedImage.getHeight() : new Integer(width).doubleValue() / (double)tempBufferedImage.getWidth();
                AffineTransformOp op = new AffineTransformOp(AffineTransform.getScaleInstance(ratio, ratio), null);
                targetImage = op.filter(tempBufferedImage, null);
            }
            if (fillWhite) {
                BufferedImage image = new BufferedImage(width, height, 1);
                Graphics2D graphics2D = image.createGraphics();
                graphics2D.setColor(Color.white);
                graphics2D.fillRect(0, 0, width, height);
                if (width == targetImage.getWidth(null)) {
                    graphics2D.drawImage(targetImage, 0, (height - targetImage.getHeight(null)) / 2, targetImage.getWidth(null), targetImage.getHeight(null), Color.white, null);
                } else {
                    graphics2D.drawImage(targetImage, (width - targetImage.getWidth(null)) / 2, 0, targetImage.getWidth(null), targetImage.getHeight(null), Color.white, null);
                }
                graphics2D.dispose();
                targetImage = image;
            }
            ImageIO.write((RenderedImage)((BufferedImage)targetImage), "jpg", file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static List<File> unCompressedFile(File originFile, String parentPath) {
        if (!originFile.exists()) {
            return null;
        }
        if (FileUtil.isZIP(FileUtil.getExtName(originFile.getName()))) {
            return FileUtil.unZipFile(originFile, parentPath);
        }
        if (FileUtil.isRAR(FileUtil.getExtName(originFile.getName()))) {
            return FileUtil.unRarFile(originFile, parentPath);
        }
        return null;
    }

    private void compressDirectory(File dir, ZipOutputStream out, String basedir) {
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            this.compressByType(files[i], out, basedir + dir.getName() + "/");
        }
    }

    private void compressFile(File file, ZipOutputStream out, String basedir) {
        if (!file.exists()) {
            return;
        }
        try {
            int count;
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            ZipEntry entry = new ZipEntry(basedir + file.getName());
            out.putNextEntry(entry);
            byte[] data = new byte[1024];
            while ((count = bis.read(data, 0, 1024)) != -1) {
                out.write(data, 0, count);
            }
            bis.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void compressByType(File file, ZipOutputStream out, String basedir) {
        if (file.isDirectory()) {
            this.compressDirectory(file, out, basedir);
        } else {
            this.compressFile(file, out, basedir);
        }
    }

    public static boolean compressZip(String srcPathName, File zipFile) {
        File srcdir = new File(srcPathName);
        try {
            if (!srcdir.exists()) {
                throw new RuntimeException(srcPathName + "\u4e0d\u5b58\u5728\uff01");
            }
            Project prj = new Project();
            Zip zip = new Zip();
            zip.setProject(prj);
            zip.setDestFile(zipFile);
            FileSet fileSet = new FileSet();
            fileSet.setProject(prj);
            fileSet.setDir(srcdir);
            zip.addFileset(fileSet);
            zip.execute();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void deleteCurrFile(String file) {
        FileUtil.deleteFile(new File(file));
    }

    public static void deleteFile(File file) {
        if (file.exists()) {
            if (file.isFile()) {
                file.delete();
            } else if (file.isDirectory()) {
                File[] files = file.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    FileUtil.deleteFile(files[i]);
                }
                file.delete();
            }
        }
    }

    public static void downloadPic(String picUrl, String parentPath, String fileName) {
        File rootFile = new File(parentPath);
        if (!rootFile.exists()) {
            rootFile.mkdirs();
        }
        FileUtil.downloadPic(picUrl, parentPath + fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadPic(String picUrl, String destPath) {
        FileOutputStream outStream = null;
        try {
            URL url = new URL(picUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5000);
            InputStream inStream = conn.getInputStream();
            byte[] data = FileUtil.readInputStream(inStream);
            File imageFile = new File(destPath);
            outStream = new FileOutputStream(imageFile);
            outStream.write(data);
            outStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static byte[] readInputStream(InputStream inStream) throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = 0;
        while ((len = inStream.read(buffer)) != -1) {
            outStream.write(buffer, 0, len);
        }
        inStream.close();
        return outStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized List<File> unRarFile(File originfile, String parentPath) {
        ArrayList<File> files;
        block22: {
            if (!originfile.exists()) {
                return null;
            }
            files = new ArrayList<File>();
            Archive archive = null;
            try {
                archive = new Archive(originfile);
                if (archive != null) {
                    FileHeader fh = archive.nextFileHeader();
                    while (fh != null) {
                        if (fh.isDirectory()) {
                            fh = archive.nextFileHeader();
                            continue;
                        }
                        String fileName = fh.getFileNameW();
                        if (EmptyUtil.isEmpty(fileName)) {
                            fileName = fh.getFileNameString();
                        }
                        if (fileName.contains("__MACOSX")) continue;
                        File unRarFile = new File(parentPath, fileName);
                        if (!new File(unRarFile.getParent()).exists()) {
                            new File(unRarFile.getParent()).mkdirs();
                        }
                        try {
                            FileOutputStream os = new FileOutputStream(unRarFile);
                            archive.extractFile(fh, (OutputStream)os);
                            os.close();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        files.add(unRarFile);
                        fh = archive.nextFileHeader();
                    }
                    break block22;
                }
                List<File> fh = null;
                return fh;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (archive != null) {
                    try {
                        archive.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ergodicZipFile(File originfile, String encoding, List<File> files, String parentPath) {
        ZipFile zipFile = null;
        FilterOutputStream bout = null;
        try {
            log.info("encodeing>>" + encoding);
            zipFile = encoding != null ? new ZipFile(originfile, encoding) : new ZipFile(originfile);
            Enumeration e = zipFile.getEntries();
            while (e.hasMoreElements()) {
                int len;
                ZipEntry entry = (ZipEntry)e.nextElement();
                if (entry.isDirectory() || entry.getName().toUpperCase().contains("__MACOSX")) continue;
                File unZipFile = new File(parentPath, entry.getName());
                if (!new File(unZipFile.getParent()).exists()) {
                    new File(unZipFile.getParent()).mkdirs();
                }
                bout = new BufferedOutputStream(new FileOutputStream(unZipFile));
                byte[] buf1 = new byte[1024];
                InputStream in = zipFile.getInputStream(entry);
                while ((len = in.read(buf1)) > 0) {
                    ((BufferedOutputStream)bout).write(buf1, 0, len);
                }
                bout.close();
                files.add(unZipFile);
            }
        }
        catch (Exception e1) {
            files.clear();
            FileUtil.ergodicZipFile(originfile, "GBK", files, parentPath);
        }
        finally {
            if (bout != null) {
                try {
                    bout.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static synchronized List<File> unZipFile(File originfile, String parentPath) {
        String encodeing = System.getProperty("sun.jnu.encoding");
        System.setProperty("sun.zip.encoding", encodeing);
        if (!originfile.exists()) {
            return null;
        }
        ArrayList<File> files = new ArrayList<File>();
        FileUtil.ergodicZipFile(originfile, null, files, parentPath);
        return files;
    }

    public static boolean deleteFile(String sPath) {
        boolean flag = false;
        File file = new File(sPath);
        if (file.isFile() && file.exists()) {
            file.delete();
            flag = true;
        }
        return flag;
    }

    public static boolean deleteDirectory(String sPath) {
        File dirFile;
        if (!sPath.endsWith(File.separator)) {
            sPath = sPath + File.separator;
        }
        if (!(dirFile = new File(sPath)).exists() || !dirFile.isDirectory()) {
            return false;
        }
        boolean flag = true;
        File[] files = dirFile.listFiles();
        for (int i = 0; i < files.length && !(files[i].isFile() ? !(flag = FileUtil.deleteFile(files[i].getAbsolutePath())) : !(flag = FileUtil.deleteDirectory(files[i].getAbsolutePath()))); ++i) {
        }
        if (!flag) {
            return false;
        }
        return dirFile.delete();
    }

    public static void main(String[] args) {
        boolean needDel;
        String parentPath = System.getProperty("java.io.tmpdir") + System.currentTimeMillis() + File.separator;
        List<File> files = FileUtil.unCompressedFile(new File("C:\\\u6d4b\u8bd5.zip"), parentPath);
        if (files != null && (needDel = true)) {
            System.out.println(parentPath);
            boolean ok = FileUtil.deleteDirectory(parentPath);
            System.out.println(ok);
        }
    }

    private static enum FILES {
        PDF("pdf"),
        HTML("html"),
        EXCEL("excel"),
        DOC("doc"),
        ZIP("zip"),
        RAR("rar");

        private String value;

        private FILES(String value) {
            this.value = value;
        }
    }
}

