/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.util.comm;

import com.thebeastshop.pegasus.util.comm.FileDownLoadBuilder;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.RichTextString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class ExcelExportBuilder {
    private static final Logger log = LoggerFactory.getLogger(ExcelExportBuilder.class);
    private static final int MAX_SHEET_RECORD_NUM = 50000;
    private String fileName = "demo";
    private List data = new ArrayList();
    private List<String> titleList = new ArrayList<String>();
    private List<String> propertyNameList = new ArrayList<String>();
    private List<String> uniqFieldNameList = new ArrayList<String>();

    public ExcelExportBuilder fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public ExcelExportBuilder data(List data) {
        this.data = data;
        return this;
    }

    public ExcelExportBuilder title(String ... titleName) {
        if (ArrayUtils.isNotEmpty((Object[])titleName)) {
            for (String name : titleName) {
                this.titleList.add(name);
            }
        }
        return this;
    }

    public ExcelExportBuilder property(String ... propertyName) {
        if (ArrayUtils.isNotEmpty((Object[])propertyName)) {
            for (String name : propertyName) {
                this.propertyNameList.add(name);
            }
        }
        return this;
    }

    public ExcelExportBuilder uniqFieldName(String fieldName) {
        this.uniqFieldNameList.add(fieldName);
        return this;
    }

    public ResponseEntity<byte[]> builder() {
        byte[] bytes = this.getExcelBytes();
        return new FileDownLoadBuilder().name(this.fileName + ".xls").file(bytes).builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getExcelBytes() {
        int dataListSize = this.data.size();
        HSSFWorkbook workBook = new HSSFWorkbook();
        for (int i = 0; i <= dataListSize / 50000; ++i) {
            int fromIndex = i * 50000;
            int toIndex = fromIndex + 50000;
            if (toIndex > dataListSize) {
                toIndex = dataListSize;
            }
            List subList = this.data.subList(fromIndex, toIndex);
            HSSFSheet sheet = workBook.createSheet();
            if (CollectionUtils.isNotEmpty(this.titleList)) {
                HSSFRow titleRow = sheet.createRow(0);
                HSSFCell[] firstColCell = new HSSFCell[this.titleList.size()];
                for (int j = 0; j < this.titleList.size(); ++j) {
                    firstColCell[j] = titleRow.createCell(j);
                    firstColCell[j].setCellValue((RichTextString)new HSSFRichTextString(this.titleList.get(j)));
                }
            }
            for (int j = 0; j < subList.size(); ++j) {
                HSSFRow row = sheet.createRow(j + 1);
                Object record = subList.get(j);
                for (int index = 0; index < this.propertyNameList.size(); ++index) {
                    HSSFCell cell = row.createCell(index);
                    Object value = ExcelExportBuilder.getPropertyValue(record, this.propertyNameList.get(index));
                    cell.setCellValue(Objects.toString(value, ""));
                }
            }
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            workBook.write((OutputStream)out);
        }
        catch (IOException e) {
            log.error(null, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)workBook);
        }
        return out.toByteArray();
    }

    private static Object getPropertyValue(Object bean, String propertyName) {
        Object value = new Object();
        try {
            if (bean instanceof Map) {
                Map map = (Map)bean;
                value = MapUtils.getObject((Map)map, (Object)propertyName, (Object)"");
            } else {
                value = PropertyUtils.getSimpleProperty((Object)bean, (String)propertyName);
            }
        }
        catch (Exception e) {
            log.warn(null, (Throwable)e);
            return "";
        }
        return value;
    }
}

