/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.util.comm;

import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static final Logger log = LoggerFactory.getLogger(DateUtil.class);
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    public static final String DEFAULTDATEFORMAT = "yyyyMMdd";
    public static final String YEAR_FORMAT = "yyyy";
    public static final String YEAR_MONTH_BAR_FORMAT = "yyyy-MM";
    public static final String YEAR_MONTH_FORMAT = "yyyy\u5e74MM\u6708";
    public static final String DEFAULT_CN_DATE_FORMAT = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String DEFAULT_TIME_FORMAT = "HH:mm:ss";
    public static final String DATE_STR_FORMAT_SSS = "HH:mm:ss:SSS";
    public static final String DEFAULT_DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DEFAULT_STR_FORMAT = "yyyyMMddHHmmss";
    public static final String DATE_STR_FORMAT = "yyyyMMddHHmmssSSS";
    public static final String DATE_FORMAT = "dd";
    public static final String MOUNTH_FORMAT = "MM";
    public static final Integer WORK_DAY = 0;
    public static final Integer WEEK_DAY = 1;
    public static final Integer HOLIDAY = 2;

    private static final SimpleDateFormat getFormat(String pattern, Locale locale) {
        return new SimpleDateFormat(pattern, locale);
    }

    public static String format(Date date, String pattern) {
        return DateUtil.format(date, pattern, Locale.getDefault());
    }

    public static String format(Date date, String pattern, Locale locale) {
        if (date == null) {
            return "";
        }
        if (StringUtils.isNotBlank((String)pattern)) {
            String format = DateUtil.getFormat(pattern, locale).format(date);
            return format;
        }
        throw new IllegalArgumentException("param pattern can not be null");
    }

    public static Date parse(String dateString, String pattern) {
        return DateUtil.parse(dateString, pattern, Locale.getDefault());
    }

    public static Date parse(String dateString, String pattern, Locale locale) {
        if (StringUtils.isNotBlank((String)dateString)) {
            ParsePosition parsePosition = new ParsePosition(0);
            Date date = DateUtil.getFormat(pattern, locale).parse(dateString, parsePosition);
            Object[] objects = new Object[]{dateString, pattern};
            log.debug("dateString:[{}], pattern:[{}], parsePosition:[{}]", objects);
            return date;
        }
        throw new IllegalArgumentException("param dateString can not be null");
    }

    public static Date add(Date date, int field, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(field, amount);
        return calendar.getTime();
    }

    public static Date addDay(Date date, int amount) {
        return DateUtil.add(date, 6, amount);
    }

    public static Date addBeforeMonthBeginDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        String strY = null;
        int x = calendar.get(1);
        int y = calendar.get(2);
        strY = y >= 10 ? String.valueOf(y) : "0" + y;
        String beginDay = x + "-" + strY + "-01";
        return DateUtil.parse(beginDay, DEFAULT_DATE_FORMAT);
    }

    public static Date addBeforeMonthEndDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        String strY = null;
        String strZ = null;
        boolean leap = false;
        int x = calendar.get(1);
        int y = calendar.get(2);
        if (y == 1 || y == 3 || y == 5 || y == 7 || y == 8 || y == 10 || y == 12) {
            strZ = "31";
        }
        if (y == 4 || y == 6 || y == 9 || y == 11) {
            strZ = "30";
        }
        if (y == 2) {
            leap = DateUtil.leapYear(x);
            strZ = leap ? "29" : "28";
        }
        strY = y >= 10 ? String.valueOf(y) : "0" + y;
        String endDay = x + "-" + strY + "-" + strZ;
        return DateUtil.parse(endDay, DEFAULT_DATE_FORMAT);
    }

    public static boolean leapYear(int year) {
        boolean leap = year % 4 == 0 ? (year % 100 == 0 ? year % 400 == 0 : true) : false;
        return leap;
    }

    public static Date addYears(Date date, int num) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(1, num);
        return cal.getTime();
    }

    public static Date addMinutes(Date date, int amount) {
        return DateUtil.add(date, 12, amount);
    }

    public static Date dayStart(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date yesterdayStart(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date dayEnd(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date dayEndSecond(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date yesterdayEnd(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static String weekDayInChinese() {
        return DateUtil.weekDayInChinese(new Date());
    }

    public static String weekDayInChinese(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int week = calendar.get(7);
        switch (week) {
            case 1: {
                return "\u65e5";
            }
            case 2: {
                return "\u4e00";
            }
            case 3: {
                return "\u4e8c";
            }
            case 4: {
                return "\u4e09";
            }
            case 5: {
                return "\u56db";
            }
            case 6: {
                return "\u4e94";
            }
            case 7: {
                return "\u516d";
            }
        }
        return "";
    }

    public static Date getNow() {
        return new Date();
    }

    public static String getNowFormat(String foramt) {
        return DateUtil.format(DateUtil.getNow(), foramt);
    }

    public static Date getCurrDateByDateStr(String dateStr) {
        Date date = null;
        try {
            date = new SimpleDateFormat(DEFAULT_DATE_FORMAT).parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static int getCurrYear() {
        return Calendar.getInstance().get(1);
    }

    public static int getCurrMonth() {
        return Calendar.getInstance().get(2) + 1;
    }

    public static Date getPreMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        return calendar.getTime();
    }

    public static Date getYesterday() {
        return DateUtil.getPreDay(-1);
    }

    public static Date getPreDay(int preDay) {
        Calendar calendar = Calendar.getInstance();
        return DateUtil.addDay(calendar.getTime(), preDay);
    }

    public static Date getCurrMonthDate() {
        Calendar calendar = Calendar.getInstance();
        return calendar.getTime();
    }

    public static Date getNextMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, 1);
        return calendar.getTime();
    }

    public static Date getNextMonthByDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        return calendar.getTime();
    }

    public static Date getFirstDateFromCurrMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, 0);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static Date getFirstDateFromCustomMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 0);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static Date getLastDateFromCurrMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, 1);
        calendar.set(5, 0);
        return calendar.getTime();
    }

    public static Date getLastDateFromCustomMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 0);
        return calendar.getTime();
    }

    public static int getCurrentMonthLastDay() {
        Calendar a = Calendar.getInstance();
        a.set(5, 1);
        a.roll(5, -1);
        int maxDate = a.get(5);
        return maxDate;
    }

    public static int getMonthLastDay(Date date) {
        Calendar a = Calendar.getInstance();
        a.setTime(date);
        a.set(5, 1);
        a.roll(5, -1);
        int maxDate = a.get(5);
        return maxDate;
    }

    private static Date getLastOrNextWeek(int week, int weekNum) {
        GregorianCalendar currentDate = new GregorianCalendar();
        currentDate.setFirstDayOfWeek(2);
        currentDate.set(7, week);
        currentDate.add(3, weekNum);
        Date nextWeek = currentDate.getTime();
        return nextWeek;
    }

    public static Date getLastWeek(int weekNum, int nextNum) {
        return DateUtil.getLastOrNextWeek(weekNum, -nextNum);
    }

    public static Date getCurrWeek(int weekNum) {
        return DateUtil.getLastOrNextWeek(weekNum, 0);
    }

    public static Date getNextWeek(int weekNum, int nextNum) {
        return DateUtil.getLastOrNextWeek(weekNum, nextNum);
    }

    private static Date getLastFriday() {
        return DateUtil.getLastWeek(6, 1);
    }

    public static Date getLastFridayStart() {
        Date fridayStart = DateUtil.getLastFriday();
        return DateUtil.dayStart(fridayStart);
    }

    public static Date getLastFridayEnd() {
        Date fridayEnd = DateUtil.getLastFriday();
        return DateUtil.dayEnd(fridayEnd);
    }

    private static Date getNextFriday() {
        return DateUtil.getNextWeek(6, 1);
    }

    public static Date getNextFridayStart() {
        Date fridayStart = DateUtil.getNextFriday();
        return DateUtil.dayStart(fridayStart);
    }

    public static Date getNextFridayEnd() {
        Date nextFridayEnd = DateUtil.getNextFriday();
        return DateUtil.dayEnd(nextFridayEnd);
    }

    public static Date getCurrFriday() {
        return DateUtil.getCurrWeek(6);
    }

    public static Date getCurrFridayStart() {
        Date date = DateUtil.getCurrFriday();
        return DateUtil.dayStart(date);
    }

    public static Date getCurrFridayEnd() {
        Date date = DateUtil.getCurrFriday();
        return DateUtil.dayEnd(date);
    }

    public static int daysBetween(Date smdate, Date bdate) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(DEFAULT_DATE_FORMAT);
        smdate = sdf.parse(sdf.format(smdate));
        bdate = sdf.parse(sdf.format(bdate));
        Calendar cal = Calendar.getInstance();
        cal.setTime(smdate);
        long time1 = cal.getTimeInMillis();
        cal.setTime(bdate);
        long time2 = cal.getTimeInMillis();
        long betweenDays = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(betweenDays));
    }

    public static boolean isInTime(String strDateBegin, String strDateEnd) {
        int strDateBeginH = Integer.parseInt(strDateBegin.substring(0, 2));
        int strDateBeginM = Integer.parseInt(strDateBegin.substring(3, 5));
        int strDateBeginS = Integer.parseInt(strDateBegin.substring(6, 8));
        int strDateEndH = Integer.parseInt(strDateEnd.substring(0, 2));
        int strDateEndM = Integer.parseInt(strDateEnd.substring(3, 5));
        int strDateEndS = Integer.parseInt(strDateEnd.substring(6, 8));
        Calendar calendarStart = Calendar.getInstance();
        calendarStart.setTime(Calendar.getInstance().getTime());
        calendarStart.set(11, strDateBeginH);
        calendarStart.set(12, strDateBeginM);
        calendarStart.set(13, strDateBeginS);
        Calendar calendarEnd = Calendar.getInstance();
        calendarEnd.setTime(Calendar.getInstance().getTime());
        calendarEnd.set(11, strDateEndH);
        calendarEnd.set(12, strDateEndM);
        calendarEnd.set(13, strDateEndS);
        return Calendar.getInstance().getTimeInMillis() >= calendarStart.getTimeInMillis() && Calendar.getInstance().getTimeInMillis() < calendarEnd.getTimeInMillis();
    }

    public static boolean termOfValidity(Date startDate, Date endDate) {
        if (null == startDate || null == endDate) {
            return false;
        }
        Calendar instance = Calendar.getInstance();
        Long nowTime = instance.getTime().getTime();
        return nowTime > startDate.getTime() && nowTime < endDate.getTime();
    }

    public static Boolean isInTime(Date startDate, Date endDate, Date date) {
        long startTimes = 0L;
        long endTime = 0L;
        long sourceTime = new Date().getTime();
        if (null != startDate) {
            startTimes = startDate.getTime();
        }
        if (null != endDate) {
            endTime = endDate.getTime();
        }
        if (null != date) {
            sourceTime = date.getTime();
        }
        if (startTimes <= sourceTime && endTime >= sourceTime) {
            return true;
        }
        return false;
    }

    public static Date getSpecifiedDayBefore(String specifiedDay) {
        Calendar c = Calendar.getInstance();
        Date date = null;
        try {
            date = new SimpleDateFormat(DEFAULT_DATETIME_FORMAT).parse(specifiedDay);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        c.setTime(date);
        int day = c.get(5);
        c.set(5, day - 1);
        String dayBefore = new SimpleDateFormat(DEFAULT_DATETIME_FORMAT).format(c.getTime());
        Date beforeDay = DateUtil.parse(dayBefore, DEFAULT_DATETIME_FORMAT);
        return beforeDay;
    }

    public static int differentDaysByMillisecond(Date date1, Date date2) {
        int days = (int)((date2.getTime() - date1.getTime()) / 86400000L);
        return days;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject fetchHoliday(String currDate) {
        BufferedReader reader = null;
        String result = null;
        JSONObject jsonObjectResult = null;
        StringBuffer sbf = new StringBuffer();
        String httpUrl = "http://api.goseek.cn/Tools/holiday?date=" + currDate;
        try {
            URL url = new URL(httpUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.connect();
            InputStream is = connection.getInputStream();
            reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String strRead = null;
            while ((strRead = reader.readLine()) != null) {
                sbf.append(strRead);
                sbf.append("\r\n");
            }
            result = sbf.toString();
            jsonObjectResult = JSONObject.parseObject((String)result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return jsonObjectResult;
    }

    public static boolean checkHoliday(String currDate) {
        JSONObject jsonObject = DateUtil.fetchHoliday(currDate);
        String date = jsonObject.getString("data");
        return DateUtil.checkHolidayByType(date);
    }

    public static boolean checkHolidayByType(String dateType) {
        return EmptyUtil.isNotEmpty(dateType) && (dateType.equals("1") || dateType.equals("2"));
    }

    public static int fetchStatutoryHolidayType(String currDate) {
        JSONObject jsonObject = DateUtil.fetchHoliday(currDate);
        String date = jsonObject.getString("data");
        if (EmptyUtil.isNotEmpty(date)) {
            try {
                return Integer.parseInt(date);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public static List<String> fetchDayOfYear(Date date) {
        ArrayList<String> daysOfYearList = new ArrayList<String>();
        int days = DateUtil.getDayOfYearByYear(date);
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        for (int i = 1; i <= days; ++i) {
            c.set(6, i);
            daysOfYearList.add(DateUtil.format(c.getTime(), DEFAULTDATEFORMAT));
        }
        return daysOfYearList;
    }

    public static int getDayOfYear() {
        Calendar c = Calendar.getInstance();
        return c.getActualMaximum(6);
    }

    public static int getDayOfYearByYear(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.getActualMaximum(6);
    }

    public static int countCurDateToHolidayDays(Date minDate, Date currDate, Map<String, Boolean> dayHolidayMap) {
        int holidayDays = 0;
        Date addDate = null;
        Boolean isHoliday = false;
        try {
            int intervalDays = DateUtil.daysBetween(minDate, currDate);
            if (intervalDays >= 0) {
                for (int i = 0; i <= intervalDays; ++i) {
                    addDate = DateUtil.addDay(currDate, -i);
                    isHoliday = dayHolidayMap.get(DateUtil.format(addDate, DEFAULTDATEFORMAT));
                    if (isHoliday == null) {
                        isHoliday = DateUtil.checkHolidayByDate(addDate);
                        dayHolidayMap.put(DateUtil.format(addDate, DEFAULTDATEFORMAT), isHoliday);
                    }
                    if (!isHoliday.booleanValue()) continue;
                    ++holidayDays;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return holidayDays;
    }

    private static boolean checkHolidayByDate(Date date) {
        return DateUtil.checkHoliday(DateUtil.format(date, DEFAULTDATEFORMAT));
    }

    public static Integer fetchHolidayNum(String currDate) {
        JSONObject jsonObject = DateUtil.fetchHoliday(currDate);
        String date = jsonObject.getString("data");
        if (EmptyUtil.isNotEmpty(date)) {
            return Integer.parseInt(date);
        }
        return 0;
    }

    public static void main(String[] args) {
        try {
            System.out.println(DateUtil.getDayOfYearByYear(new Date()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int getDaysByYearMonth(int year, int month) {
        Calendar a = Calendar.getInstance();
        a.set(1, year);
        a.set(2, month - 1);
        a.set(5, 1);
        a.roll(5, -1);
        int maxDate = a.get(5);
        return maxDate;
    }
}

