/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.util.comm;

import com.thebeastshop.pegasus.util.exception.UtilException;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeGenerator {
    private final Logger log = LoggerFactory.getLogger(CodeGenerator.class);
    private static CodeGenerator instance;
    private Map<String, Template> __cachedTemplateMap = new ConcurrentHashMap<String, Template>();

    private CodeGenerator() {
        ResourceBundle config = ResourceBundle.getBundle("pegasus-util/code");
        Configuration cfg = new Configuration();
        Enumeration<String> codeTempNames = config.getKeys();
        while (codeTempNames.hasMoreElements()) {
            String codeTemplateName = codeTempNames.nextElement();
            try {
                Template tpl = new Template(codeTemplateName, config.getString(codeTemplateName), cfg);
                this.__cachedTemplateMap.put(codeTemplateName, tpl);
            }
            catch (Exception e) {
                this.log.warn("", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CodeGenerator getInstance() {
        if (instance != null) {
            return instance;
        }
        Class<CodeGenerator> clazz = CodeGenerator.class;
        synchronized (CodeGenerator.class) {
            if (instance == null) {
                instance = new CodeGenerator();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String generate(String codeTemplateName, Map<String, Object> params) {
        String result;
        Template tpl = this.__cachedTemplateMap.get(codeTemplateName);
        if (tpl == null) {
            throw new UtilException("can't find template for name : " + codeTemplateName);
        }
        StringWriter sw = new StringWriter();
        try {
            tpl.process(params, (Writer)sw);
            result = sw.toString().toUpperCase();
        }
        catch (Exception e) {
            this.log.warn("", (Throwable)e);
            throw new UtilException("CodeGenerator.generate failed : " + codeTemplateName + " : " + params);
        }
        return result;
    }
}

