/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.util.comm;

import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;

public class BeanUtil {
    public static <T> T buildFrom(Object src, Class<T> clz) {
        return BeanUtil.buildFrom(src, clz, null);
    }

    public static <T> T buildFrom(Object src, Class<T> clz, String[] ignoreProperties) {
        if (src == null) {
            return null;
        }
        T obj = null;
        try {
            obj = clz.newInstance();
            BeanUtils.copyProperties((Object)src, obj, (String[])ignoreProperties);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return obj;
    }

    public static <T> List<T> buildListFrom(Collection src, Class<T> clz) {
        return BeanUtil.buildListFrom(src, clz, null);
    }

    public static <T> List<T> buildListFrom(Collection src, Class<T> clz, String[] ignoreProperties) {
        if (CollectionUtils.isEmpty((Collection)src)) {
            return Collections.emptyList();
        }
        ArrayList<T> objs = new ArrayList<T>(src.size());
        try {
            for (Object o : src) {
                T obj = clz.newInstance();
                BeanUtils.copyProperties(o, obj, (String[])ignoreProperties);
                objs.add(obj);
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return objs;
    }

    public static <T> Map<String, T> copyMap(Map<String, Object> src, Class<T> clz) throws IllegalAccessException, InstantiationException {
        if (EmptyUtil.isEmpty(src)) {
            return null;
        }
        HashMap<String, T> resultMap = new HashMap<String, T>();
        for (Map.Entry<String, Object> entry : src.entrySet()) {
            T obj = clz.newInstance();
            BeanUtils.copyProperties(src, obj);
            resultMap.put(entry.getKey(), obj);
        }
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T deepCopy(Object src, Class<T> clz) {
        if (src == null) {
            return null;
        }
        Object targetObj = null;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(src);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(outputStream.toByteArray());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            targetObj = objectInputStream.readObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return (T)targetObj;
    }
}

