/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.util;

import com.taobao.api.ApiException;
import com.taobao.api.response.ItemQuantityUpdateResponse;
import com.taobao.api.response.ItemSkuGetResponse;
import com.thebeastshop.pegasus.util.SpringUtil;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.cond.CommDictionaryCond;
import com.thebeastshop.pegasus.util.cond.CommHolidayCond;
import com.thebeastshop.pegasus.util.model.CommCity;
import com.thebeastshop.pegasus.util.model.CommCountry;
import com.thebeastshop.pegasus.util.model.CommCurrency;
import com.thebeastshop.pegasus.util.model.CommDictionary;
import com.thebeastshop.pegasus.util.model.CommDistrict;
import com.thebeastshop.pegasus.util.model.CommEntityOpRcd;
import com.thebeastshop.pegasus.util.model.CommFileRef;
import com.thebeastshop.pegasus.util.model.CommFileRefExample;
import com.thebeastshop.pegasus.util.model.CommGlobalConfig;
import com.thebeastshop.pegasus.util.model.CommHoliday;
import com.thebeastshop.pegasus.util.model.CommOperationRcd;
import com.thebeastshop.pegasus.util.model.CommProvince;
import com.thebeastshop.pegasus.util.model.CommSendMail;
import com.thebeastshop.pegasus.util.model.CommTaxRate;
import com.thebeastshop.pegasus.util.model.CommTypeValue;
import com.thebeastshop.pegasus.util.model.ThirdpartyOrdersShipLog;
import com.thebeastshop.pegasus.util.model.ThirdpartyOrdersShipLogKey;
import com.thebeastshop.pegasus.util.service.CommAddressService;
import com.thebeastshop.pegasus.util.service.CommDictionaryService;
import com.thebeastshop.pegasus.util.service.CommEntityOperationRcdService;
import com.thebeastshop.pegasus.util.service.CommFileRefService;
import com.thebeastshop.pegasus.util.service.CommFileService;
import com.thebeastshop.pegasus.util.service.CommGlobalConfigService;
import com.thebeastshop.pegasus.util.service.CommHolidayService;
import com.thebeastshop.pegasus.util.service.CommJdService;
import com.thebeastshop.pegasus.util.service.CommOperationRcdService;
import com.thebeastshop.pegasus.util.service.CommSendMailService;
import com.thebeastshop.pegasus.util.service.CommThirdPartyService;
import com.thebeastshop.pegasus.util.service.CommTmallService;
import com.thebeastshop.pegasus.util.service.CommTypeValueService;
import com.thebeastshop.pegasus.util.service.CommaVipService;
import com.thebeastshop.pegasus.util.vo.FileRequestVO;
import com.thebeastshop.pegasus.util.vo.FileResponseVO;
import com.thebeastshop.pegasus.util.vo.JdStockSyncResult;
import com.thebeastshop.pegasus.util.vo.Region;
import com.thebeastshop.tmall.dto.NextoneLogisticsWarehouseUpdateResponseDTO;
import com.thebeastshop.tmall.dto.TmallTbRefundDTO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.HttpException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import vipapis.delivery.PrintTemplateResponse;
import vipapis.delivery.Ship;
import vipapis.delivery.ShipResult;

public class PegasusUtilFacade {
    private static final Logger log = LoggerFactory.getLogger(PegasusUtilFacade.class);
    private static PegasusUtilFacade instance;
    @Autowired
    private CommAddressService commAddressService;
    @Autowired
    private CommDictionaryService commDictionaryService;
    @Autowired
    private CommOperationRcdService commOperationRcdService;
    @Autowired
    private CommEntityOperationRcdService commEntityOperationRcdService;
    @Autowired
    private CommFileService commFileService;
    @Autowired
    private CommFileRefService commFileRefService;
    @Autowired
    private CommGlobalConfigService commGlobalConfigService;
    @Autowired
    private CommTmallService commTmallService;
    @Autowired
    private CommJdService commJdService;
    @Autowired
    private CommTypeValueService commTypeValueService;
    @Autowired
    private CommaVipService commaVipService;
    @Autowired
    private CommThirdPartyService commThirdPartyService;
    @Autowired
    private CommSendMailService commSendMailService;
    @Autowired
    private CommHolidayService commHolidayService;

    private PegasusUtilFacade() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PegasusUtilFacade getInstance() {
        if (instance != null) {
            return instance;
        }
        Class<PegasusUtilFacade> clazz = PegasusUtilFacade.class;
        synchronized (PegasusUtilFacade.class) {
            if (instance == null) {
                log.info("[fasade init start] PegasusUtilFacade");
                new ClassPathXmlApplicationContext("pegasus-util/spring.xml");
                log.info("[fasade init finish] PegasusUtilFacade");
            }
            instance = (PegasusUtilFacade)SpringUtil.getBean("pegasusUtilFacade");
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void refreshCacheAddress() {
        this.commAddressService.refreshCache();
    }

    public List<CommCountry> findAllCountry(boolean cascade) {
        return this.commAddressService.findAllCountry(cascade);
    }

    public List<CommCountry> findForeignCountry(String countryName, boolean cascade) {
        return this.commAddressService.findForeignCountry(countryName, cascade);
    }

    public CommCountry findCountryById(Long id, boolean cascade) {
        return this.commAddressService.findCountryById(id, cascade);
    }

    public CommCountry findCountryByName(String name) {
        return this.commAddressService.findCountryByName(name);
    }

    public List<CommProvince> findProvinceByCountryId(Long countryId, boolean cascade) {
        return this.commAddressService.findProvinceByCountryId(countryId, cascade);
    }

    public CommProvince findProvinceById(Long id, boolean cascade) {
        return this.commAddressService.findProvinceById(id, cascade);
    }

    public CommProvince findProvinceBydistrictIdId(Long districtId) {
        return this.commAddressService.findProvinceBydistrictIdId(districtId);
    }

    public List<CommProvince> findProvinceByCond(String cond) {
        return this.commAddressService.findProvinceByCond(cond);
    }

    public List<CommCity> findCityByProvinceId(Long provinceId, boolean cascade) {
        return this.commAddressService.findCityByProvinceId(provinceId, cascade);
    }

    public List<CommCity> findCityByProvinceIdList(List<Long> provinceIdList, boolean cascade) {
        return this.commAddressService.findCityByProvinceIdList(provinceIdList, cascade);
    }

    public List<CommCity> findCityByCond(String cond) {
        return this.commAddressService.findCityByCond(cond);
    }

    public List<CommCity> findCityByProvinceAndName(Long provinceId, String cityName) {
        return this.commAddressService.findCityByProvinceAndName(provinceId, cityName);
    }

    public CommCity findCityById(Long id, boolean cascade) {
        return this.commAddressService.findCityById(id, cascade);
    }

    public List<CommCity> findCityByIds(List<Long> ids, boolean cascade) {
        return this.commAddressService.findCityByIds(ids, cascade);
    }

    public List<CommDistrict> findDistrictByCityId(Long cityId) {
        return this.commAddressService.findDistrictByCityId(cityId);
    }

    public CommDistrict findDistrictById(Long id) {
        return this.commAddressService.findDistrictById(id);
    }

    public List<CommDistrict> findDistrictByIds(List<Long> ids) {
        return this.commAddressService.findDistrictByIds(ids);
    }

    public List<CommDistrict> findDistrictByCond(String cond) {
        return this.commAddressService.findDistrictByCond(cond);
    }

    public List<CommDistrict> findDistrictByCityAndDistrictName(Long cityId, String districtName) {
        return this.commAddressService.findDistrictByCityAndDistrictName(cityId, districtName);
    }

    public List<CommDistrict> findDistrictByProvinceId(long id) {
        return this.commAddressService.findDistrictByProvinceId(id);
    }

    public List<Long> findDistrictIdByProvinceId(long id) {
        return this.commAddressService.findDistrictIdByProvinceId(id);
    }

    public List<CommCurrency> findAllCurrency() {
        return this.commDictionaryService.findAllCurrency();
    }

    public List<CommTaxRate> findAllTaxRate() {
        return this.commDictionaryService.findAllTaxRate();
    }

    public List<CommTaxRate> findTaxRateByType(Integer rateType) {
        return this.commDictionaryService.findTaxRateByType(rateType);
    }

    public Long insertOperationRcd(CommOperationRcd commOperationRcd) {
        return this.commOperationRcdService.insertRcd(commOperationRcd);
    }

    public Long insertEntityOperationRcd(CommEntityOpRcd commEntityOpRcd) {
        return this.commEntityOperationRcdService.insertRcd(commEntityOpRcd);
    }

    public List<CommEntityOpRcd> findEntityOpRcdByClazzAndId(String entityClazz, String entityId) {
        return this.commEntityOperationRcdService.findEntityOpRcdByClazzAndId(entityClazz, entityId);
    }

    public FileResponseVO storeFile(FileRequestVO fileRequestVO) {
        return this.commFileService.store(fileRequestVO);
    }

    public void createCommFileRef(CommFileRef commFileRef) {
        this.commFileRefService.createFile(commFileRef);
    }

    public List<CommFileRef> findCommFileRef(String referenceCode, Integer referenceType) {
        return this.commFileRefService.find(referenceCode, referenceType);
    }

    public List<CommFileRef> findByCommFileRef(String returnCode, String skuCode) {
        return this.commFileRefService.findByCommFileRef(returnCode, skuCode);
    }

    public List<CommFileRef> findCommFileRefByCond(CommFileRef commFileRef) {
        return this.commFileRefService.findByCond(commFileRef);
    }

    public int updateByCond(CommFileRef record, CommFileRefExample example) {
        return this.commFileRefService.updateByCond(record, example);
    }

    public int updateByIdSelective(CommFileRef record) {
        return this.commFileRefService.updateByIdSelective(record);
    }

    public CommFileRef findCommFileRefById(Long id) {
        return this.commFileRefService.findById(id);
    }

    public List<CommFileRef> findCommFileRefByIds(List<Long> ids) {
        return this.commFileRefService.findByIds(ids);
    }

    public List<CommFileRef> findCommFileRefByCond(CommFileRefExample example) {
        return this.commFileRefService.findByCond(example);
    }

    public void deleteCommFileRef(Long id) {
        this.commFileRefService.deleteById(id);
    }

    public FileResponseVO getFile(long id) {
        return this.commFileService.getFile(id, false);
    }

    public List<FileResponseVO> getFile(List<Long> ids, boolean isread) {
        return this.commFileService.getFile(ids, isread);
    }

    public Boolean deleteFileById(long id) {
        return this.commFileService.deleteFileById(id);
    }

    public FileResponseVO storeImage(FileRequestVO fileRequestVO, Integer width, Integer height) {
        return this.commFileService.storeImage(fileRequestVO, width, height);
    }

    public String getStorePath() {
        return this.commFileService.getStorePath();
    }

    public String getPathSeparator() {
        return this.commFileService.getPathSeparator();
    }

    public Boolean modifyFileName(long id, String fileName) {
        return this.commFileService.modifyFileName(id, fileName);
    }

    public CommGlobalConfig findConfigByKey(String key) {
        return this.commGlobalConfigService.findConfigByKey(key);
    }

    @Deprecated
    public String findCancelStockToShelvesCode(String physicalWarehouseCode) {
        String keyPrefix = "wms.cancel_stock_to_shelvescode.";
        CommGlobalConfig config = this.findConfigByKey(keyPrefix + physicalWarehouseCode);
        return NullUtil.isNull(config) ? null : config.getConfigValue();
    }

    public String findCancelStockToShelvesCode(String physicalWarehouseCode, Integer skuStatus) {
        String keyPrefix = "wms.cancel_stock_to_shelvescode.";
        CommGlobalConfig config = this.findConfigByKey(keyPrefix + physicalWarehouseCode + "." + skuStatus);
        return NullUtil.isNull(config) ? null : config.getConfigValue();
    }

    public List<CommTypeValue> getCommTypeValuesByType(String type) {
        return this.commTypeValueService.getCommTypeValuesByType(type);
    }

    public String findByConfigKey(String configKey) {
        return this.commGlobalConfigService.findByConfigKey(configKey);
    }

    public Long getSkuNumIid(String outerId, String sessionKey) throws Exception {
        return this.commTmallService.getSkuNumIid(outerId, sessionKey);
    }

    public ItemSkuGetResponse taoBaoItemSkuGet(String channelCode, Long skuId, Long numIid, String nick) throws Exception {
        return this.commTmallService.taoBaoItemSkuGet(channelCode, skuId, numIid, nick);
    }

    public int getSkuQuantity(String outerId, String sessionKey, Long numIid) throws Exception {
        return this.commTmallService.getSkuQuantity(outerId, sessionKey, numIid);
    }

    public int getPromotionUmp(String sessionKey, Long numIid) throws Exception {
        return this.commTmallService.getPromotionUmp(sessionKey, numIid);
    }

    public boolean needSyncJdStock(String warehouseCode) {
        return this.commJdService.needSyncStock(warehouseCode);
    }

    public Map<String, JdStockSyncResult> syncJdSkuStock(String warehouseCode, Map<String, Integer> skuQuantityMap) {
        return this.commJdService.syncSkuStock(warehouseCode, skuQuantityMap);
    }

    public CommDistrict getDistrictIdByRegion(Region region) {
        return this.commAddressService.getDistrictIdByRegion(region);
    }

    public List<CommDictionary> findDictionaryByType(String dictType) {
        return this.commDictionaryService.findDictionaryByType(dictType);
    }

    public List<CommDictionary> findDictionaryByCond(CommDictionaryCond cond) {
        return this.commDictionaryService.findDictionaryByCond(cond);
    }

    public int batchCreateCommDictionary(List<CommDictionary> commDictionaries) {
        return this.commDictionaryService.batchInsert(commDictionaries);
    }

    public List<CommCity> getShopCity(List list) {
        return this.commAddressService.getShopCity(list);
    }

    public List<CommEntityOpRcd> findEntityOpRcdByClazzAndId(Integer operationType, String entityClazz, String entityId) {
        return this.commEntityOperationRcdService.findEntityOpRcdByClazzAndId(operationType, entityClazz, entityId);
    }

    public ShipResult vipShip(List<Ship> shipList) {
        return this.commaVipService.ship(shipList);
    }

    public PrintTemplateResponse getPrintTemplate(String outerOrderCode) {
        return this.commaVipService.getPrintTemplate(outerOrderCode);
    }

    public void addThirdPartyShipLog(ThirdpartyOrdersShipLog thirdpartyOrdersShipLog) {
        this.commThirdPartyService.addThirdPartyShipLog(thirdpartyOrdersShipLog);
    }

    public void updateThirdPartyShipLog(ThirdpartyOrdersShipLog thirdpartyOrdersShipLog) {
        this.commThirdPartyService.updateThirdPartyShipLog(thirdpartyOrdersShipLog);
    }

    public ThirdpartyOrdersShipLog findByShipLogPrimaryKey(ThirdpartyOrdersShipLogKey key) {
        return this.commThirdPartyService.findByPrimaryKey(key);
    }

    public List<ThirdpartyOrdersShipLog> findNotShipList() {
        return this.commThirdPartyService.findNotShipList();
    }

    public FileResponseVO saveOssInfoToDb(FileRequestVO fileRequestVO) {
        return this.commFileService.saveOssInfoToDb(fileRequestVO);
    }

    public void createCommSendMail(CommSendMail commSendMail) {
        this.commSendMailService.createCommSendMail(commSendMail);
    }

    public List<CommHoliday> listCommHolidaysByCond(CommHolidayCond cond) {
        return this.commHolidayService.listCommHolidaysByCond(cond);
    }

    public List<CommHoliday> listCommHolidaysByYear(Date date) {
        CommHolidayCond cond = new CommHolidayCond();
        cond.setYearValue(DateUtil.format(date, "yyyy"));
        List<CommHoliday> commHolidays = this.commHolidayService.listCommHolidaysByCond(cond);
        if (CollectionUtils.isEmpty(commHolidays) || commHolidays.size() != DateUtil.getDayOfYearByYear(date)) {
            this.commHolidayService.delCommHolidayByCond(cond);
            this.anewFetchAndInsertCommHolidayByYear(date, cond.getYearValue());
            commHolidays = this.commHolidayService.listCommHolidaysByCond(cond);
        }
        return commHolidays;
    }

    public Map<String, Integer> mapCommHolidaysTypeByYear(Date date) {
        List<CommHoliday> commHolidays = this.listCommHolidaysByYear(date);
        HashMap<String, Integer> dateAndTypeMap = new HashMap<String, Integer>();
        for (CommHoliday commHoliday : commHolidays) {
            dateAndTypeMap.put(commHoliday.getDateValue(), commHoliday.getType());
        }
        return dateAndTypeMap;
    }

    public Map<String, Boolean> mapCommHolidaysBooleanByYear(Date date) {
        List<CommHoliday> commHolidays = this.listCommHolidaysByYear(date);
        HashMap<String, Boolean> dateAndTypeMap = new HashMap<String, Boolean>();
        for (CommHoliday commHoliday : commHolidays) {
            dateAndTypeMap.put(commHoliday.getDateValue(), DateUtil.checkHolidayByType(commHoliday.getType() + ""));
        }
        return dateAndTypeMap;
    }

    public void anewFetchAndInsertCommHolidayByYear(Date date, String year) {
        List<String> daysOfYearList = DateUtil.fetchDayOfYear(date);
        ArrayList<CommHoliday> newCommHolidays = new ArrayList<CommHoliday>();
        for (String dateValue : daysOfYearList) {
            int dateType = DateUtil.fetchStatutoryHolidayType(dateValue);
            CommHoliday commHoliday = new CommHoliday();
            commHoliday.setDateValue(dateValue);
            commHoliday.setYearValue(year);
            commHoliday.setType(dateType);
            newCommHolidays.add(commHoliday);
        }
        this.commHolidayService.batchAddCommHoliday(newCommHolidays);
    }

    public void addCommHoliday(CommHoliday commHoliday) {
        this.commHolidayService.addCommHoliday(commHoliday);
    }

    public void batchAddCommHoliday(List<CommHoliday> commHolidays) {
        this.commHolidayService.batchAddCommHoliday(commHolidays);
    }

    public String findExpressCodeByExpressName(String ExpressName) {
        return this.commDictionaryService.findExpressCodeByExpressName(ExpressName);
    }

    public List<CommDictionary> listDictionaryByCond(CommDictionaryCond cond) {
        return this.commDictionaryService.listDictionaryByCond(cond);
    }

    public CommDictionary listDictionaryByTypeAndValue(String dictType, String dictValue) {
        CommDictionaryCond cond = new CommDictionaryCond();
        cond.setDictType(dictType);
        cond.setDictValue(dictValue);
        List<CommDictionary> commDictionaries = this.listDictionaryByCond(cond);
        if (CollectionUtils.isNotEmpty(commDictionaries)) {
            return commDictionaries.get(0);
        }
        return null;
    }

    public List<CommDictionary> listDicCommodityStatusByCond(CommDictionaryCond cond) {
        if (EmptyUtil.isEmpty(cond)) {
            cond = new CommDictionaryCond();
            cond.setDictType("COMMODITY_STATUS");
            cond.setOrderBy(" DICT_ORDER ASC ");
        }
        return this.commDictionaryService.listDictionaryByCond(cond);
    }

    public Map<String, String> getCommDictionaryMap(String dictType) {
        return this.commDictionaryService.getCommDictionaryMap(dictType);
    }

    public List<CommDictionary> findDicCommodityStatusFromCache() {
        return this.commDictionaryService.findDicCommodityStatus();
    }

    public String synchronizeTmallShip(Long tid, String companyCode, String deliveryCode) throws ApiException {
        return this.commTmallService.synchronizeTmallShip(tid, companyCode, deliveryCode);
    }

    public ItemQuantityUpdateResponse synCommodityStocks(String channelCode, Long numIid, String outerId, long quantity) throws Exception {
        return this.commTmallService.synCommodityStocks(channelCode, numIid, outerId, quantity);
    }

    public Date getTmallOrderPayTimeByTid(Long tid) {
        return this.commTmallService.getTmallOrderPayTimeByTid(tid);
    }

    public List<TmallTbRefundDTO> getTmallRefunds(Date startDate, Date endDate) throws HttpException, IOException {
        return this.commTmallService.getTmallRefunds(startDate, endDate);
    }

    public NextoneLogisticsWarehouseUpdateResponseDTO tmallAgWarehouseUpdate(Long refundId, String channelCode) throws ApiException {
        return this.commTmallService.tmallAgWarehouseUpdate(refundId, channelCode);
    }
}

