package com.thebeastshop.pegasus.util.service.impl;

import java.util.List;

import org.springframework.stereotype.Service;

import com.thebeastshop.pegasus.util.comm.Constants;
import com.thebeastshop.pegasus.util.service.CommaVipService;

import vipapis.delivery.PrintTemplateResponse;
import vipapis.delivery.Ship;
import vipapis.delivery.ShipResult;

@Service("commaVipService")
public class CommaVipServiceImpl implements CommaVipService {

	@Override
	public ShipResult ship(List<Ship> shipList) {
		try {
		    vipapis.delivery.DvdDeliveryServiceHelper.DvdDeliveryServiceClient client=new vipapis.delivery.DvdDeliveryServiceHelper.DvdDeliveryServiceClient();
		    com.vip.osp.sdk.context.InvocationContext invocationContext=com.vip.osp.sdk.context.InvocationContext.Factory.getInstance();
		    invocationContext.setAppKey(Constants.vipAppKey);
		    invocationContext.setAppSecret(Constants.vipAppSecrect);
		    invocationContext.setAppURL(Constants.vipAppURL);
		    invocationContext.setAccessToken(Constants.vipAccessToken);
		    invocationContext.setLanguage("zh");
		    return client.ship(Constants.vendorId, shipList);
		} catch(com.vip.osp.sdk.exception.OspException e){
		    e.printStackTrace();
		}
		return null;
	}
	
	@Override
	public PrintTemplateResponse getPrintTemplate(String outerOrderCode) {
		try {
			vipapis.delivery.DvdDeliveryServiceHelper.DvdDeliveryServiceClient client=new vipapis.delivery.DvdDeliveryServiceHelper.DvdDeliveryServiceClient();
		    com.vip.osp.sdk.context.InvocationContext invocationContext=com.vip.osp.sdk.context.InvocationContext.Factory.getInstance();
		    invocationContext.setAppKey(Constants.vipAppKey);
		    invocationContext.setAppSecret(Constants.vipAppSecrect);
		    invocationContext.setAppURL(Constants.vipAppURL);
		    invocationContext.setAccessToken(Constants.vipAccessToken);
		    invocationContext.setLanguage("zh");
		    return client.getPrintTemplate(Constants.vendorId, "A4",outerOrderCode);
		} catch(com.vip.osp.sdk.exception.OspException e){
		    e.printStackTrace();
		}
		return null;
	}

}
