/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.util.service.impl;

import com.thebeastshop.pegasus.util.dao.CommOperationRcdMapper;
import com.thebeastshop.pegasus.util.model.CommOperationRcd;
import com.thebeastshop.pegasus.util.service.CommOperationRcdService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * @author Royan
 * @version $Id: CommOperationRcdServiceImpl.java, v 0.1 2015-07-06 下午3:47
 */
@Service("commOperationRcdService")
public class CommOperationRcdServiceImpl implements CommOperationRcdService {

    private final Logger log = LoggerFactory.getLogger(CommOperationRcdServiceImpl.class);

    @Autowired
    private CommOperationRcdMapper commOperationRcdMapper;

    /**
     * 保存操作记录
     *
     * @param commOperationRcd 记录
     * @return 记录ID
     * */
    @Override
    public Long insertRcd(CommOperationRcd commOperationRcd) {
        commOperationRcd.setOperationTime(new Date());
        commOperationRcdMapper.insert(commOperationRcd);
        return commOperationRcd.getId();
    }
}