package com.thebeastshop.pegasus.util.service.impl;

import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.cond.CommHolidayCond;
import com.thebeastshop.pegasus.util.dao.CommHolidayMapper;
import com.thebeastshop.pegasus.util.model.CommHoliday;
import com.thebeastshop.pegasus.util.model.CommHolidayExample;
import com.thebeastshop.pegasus.util.service.CommHolidayService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author xw
 * @create 2018-10-12 11:38
 */
@Service("commHolidayService")
public class CommHolidayServiceImpl implements CommHolidayService {

    private final Logger log = LoggerFactory.getLogger(CommHolidayServiceImpl.class);

    @Autowired
    private CommHolidayMapper commHolidayMapper;

    @Override
    public List<CommHoliday> listCommHolidaysByCond(CommHolidayCond cond) {
        CommHolidayExample example = buildCommHolidayExampleByCond(cond);
        return commHolidayMapper.selectByExample(example);
    }

    @Override
    public void delCommHolidayByCond(CommHolidayCond cond) {
        CommHolidayExample example = buildCommHolidayExampleByCond(cond);
        commHolidayMapper.deleteByExample(example);
    }

    private CommHolidayExample buildCommHolidayExampleByCond(CommHolidayCond cond) {
        CommHolidayExample example = new CommHolidayExample();
        CommHolidayExample.Criteria criteria = example.createCriteria();
        if (EmptyUtil.isNotEmpty(cond.getDateValue())){
            criteria.andDateValueEqualTo(cond.getDateValue());
        }
        if (EmptyUtil.isNotEmpty(cond.getYearValue())){
            criteria.andYearValueEqualTo(cond.getYearValue());
        }
        if (EmptyUtil.isNotEmpty(cond.getType())){
            criteria.andTypeEqualTo(cond.getType());
        }
        example.setOrderByClause("date_value asc");
        return example;
    }

    @Override
    public void addCommHoliday(CommHoliday commHoliday) {
        commHolidayMapper.insert(commHoliday);
    }

    @Override
    public void batchAddCommHoliday(List<CommHoliday> commHolidays) {
        commHolidayMapper.batchInsertCommHoliday(commHolidays);
    }
}
