package com.thebeastshop.pegasus.util.service.impl;

import com.thebeastshop.pegasus.util.PegasusConstants;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.dao.CommFileRefMapper;
import com.thebeastshop.pegasus.util.model.CommFileRef;
import com.thebeastshop.pegasus.util.model.CommFileRefExample;
import com.thebeastshop.pegasus.util.service.CommFileRefService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import java.util.List;

/**
 * Created by yu.bao on 2016/11/8.
 */
@Service("commFileRefService")
public class CommFileRefServiceImpl implements CommFileRefService {

    @Autowired
    private CommFileRefMapper commFileRefMapper;

    @Override
    @Transactional
    public void createFile(CommFileRef commFileRef) {
        commFileRef.setCreateTime(DateUtil.getNow());
        commFileRef.setStatus(PegasusConstants.YES);
        commFileRefMapper.insert(commFileRef);
    }

    @Override
    public CommFileRef findById(Long id) {
        return commFileRefMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<CommFileRef> findByIds(List<Long> ids) {
        CommFileRefExample example = new CommFileRefExample();
        CommFileRefExample.Criteria criteria = example.createCriteria();
        criteria.andIdIn(ids);
        return findByCond(example);
    }

    @Override
    public List<CommFileRef> findByCond(CommFileRefExample example) {
        return commFileRefMapper.selectByExample(example);
    }

    @Override
    public List<CommFileRef> find(String referenceCode, Integer referenceType) {
        CommFileRefExample example = new CommFileRefExample();
        example.createCriteria().andReferenceCodeEqualTo(referenceCode).andRefTypeEqualTo(referenceType);
        return commFileRefMapper.selectByExample(example);
    }
    
    @Override
    public List<CommFileRef> findByCommFileRef(String returnCode, String skuCode) {
        return commFileRefMapper.findByCommFileRef(returnCode,skuCode);
    }

    @Override
    public List<CommFileRef> findByCond(CommFileRef commFileRef) {
        CommFileRefExample example = new CommFileRefExample();
        CommFileRefExample.Criteria criteria = example.createCriteria();
        if (EmptyUtil.isNotEmpty(commFileRef.getReferenceCode())){
            criteria.andReferenceCodeEqualTo(commFileRef.getReferenceCode());
        }else if(CollectionUtils.isNotEmpty(commFileRef.getReferenceCodes())){
            criteria.andReferenceCodeIn(commFileRef.getReferenceCodes());
        }
        if (EmptyUtil.isNotEmpty(commFileRef.getRefType())){
            criteria.andRefTypeEqualTo(commFileRef.getRefType());
        }
        if (EmptyUtil.isNotEmpty(commFileRef.getReferenceSecondCode())){
            criteria.andReferenceSecondCodeEqualTo(commFileRef.getReferenceSecondCode());
        }
        if (EmptyUtil.isNotEmpty(commFileRef.getStatus())){
            criteria.andStatusEqualTo(commFileRef.getStatus());
        }
        return commFileRefMapper.selectByExample(example);
    }

    @Override
    @Transactional
    public int deleteById(Long id) {
        CommFileRef update = new CommFileRef();
        update.setDeleteTime(DateUtil.getNow());
        update.setStatus(PegasusConstants.NO);
        update.setId(id);
        return commFileRefMapper.updateByPrimaryKeySelective(update);
    }

    @Override
    @Transactional
    public int updateByCond(CommFileRef record,CommFileRefExample example) {
        return commFileRefMapper.updateByExampleSelective(record,example);
    }

    @Override
    @Transactional
    public int updateByIdSelective(CommFileRef record) {
        return commFileRefMapper.updateByPrimaryKeySelective(record);
    }
}