package com.thebeastshop.pegasus.util.service;

import java.util.List;

import com.thebeastshop.pegasus.util.model.ThirdpartyOrdersShipLog;
import com.thebeastshop.pegasus.util.model.ThirdpartyOrdersShipLogKey;
import com.thebeastshop.pegasus.util.vo.CommAreaMatchVO;

public interface CommThirdPartyService {
	
	void addThirdPartyShipLog(ThirdpartyOrdersShipLog thirdpartyOrdersShipLog);
	
	void updateThirdPartyShipLog(ThirdpartyOrdersShipLog thirdpartyOrdersShipLog);
	
	ThirdpartyOrdersShipLog findByPrimaryKey(ThirdpartyOrdersShipLogKey key);
	
	/**
	 * 查询没有同步发货或者发货失败的记录
	 * @return
	 */
	List<ThirdpartyOrdersShipLog> findNotShipList();

	/**
	 * 通过第三方订单区域查询内部匹配的地址
	 * @param areaName
	 * @param areaLevel
	 * @return
	 */
	CommAreaMatchVO findMatchAreaByNameAndLevel(String areaName, Short areaLevel, Integer parentId);
}
