package com.thebeastshop.pegasus.util.service;

import com.thebeastshop.pegasus.util.vo.FileRequestVO;
import com.thebeastshop.pegasus.util.vo.FileResponseVO;

import java.util.List;

/**
 * @author Eric.Lou
 * @version $Id: CommFileService.java, v 0.1 2015-07-29 07:53
 */
public interface CommFileService {

    /**
     * 图片存储目录
     * @return
     */
    String getStorePath();

    /**
     * 路径分隔符
     * @return
     */
    String getPathSeparator();

    /**
     * 存储文件
     *
     * @param fileRequestVO
     * @return
     */
    FileResponseVO store(FileRequestVO fileRequestVO);

    /**
     * 先删除再存储
     *
     * @param fileRequestVO
     * @param id
     * @return
     */
    FileResponseVO storeAfterDelete(FileRequestVO fileRequestVO, long id);

    /**
     * 存储图片
     *
     * @param fileRequestVO
     * @param width
     * @param height
     * @return
     */
    FileResponseVO storeImage(FileRequestVO fileRequestVO, Integer width, Integer height);

    /**
     * 得到文件对象,isread=true包含文件数据(byte[]形式)
     *
     * @param id
     * @param isread
     * @return
     */
    FileResponseVO getFile(long id, boolean isread);

    List<FileResponseVO> getFile(List<Long> ids, boolean isread);

    /**
     * 根据ID删除文件
     *
     * @param id
     * @return
     */
    Boolean deleteFileById(long id);

    /**
     * 修改图片名称
     *
     * @param id
     * @param fileName
     * @return
     */
    Boolean modifyFileName(long id, String fileName);



    /**
     * 保存oss信息
     *
     * @param fileRequestVO
     * @return
     */
    FileResponseVO saveOssInfoToDb(FileRequestVO fileRequestVO);

}
