/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.util.service;

import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.cond.CommDictionaryCond;
import com.thebeastshop.pegasus.util.model.CommCurrency;
import com.thebeastshop.pegasus.util.model.CommDictionary;
import com.thebeastshop.pegasus.util.model.CommTaxRate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Royan
 * @version $Id: CommDictionaryService.java, v 0.1 2015-07-03 上午11:52
 */
public interface CommDictionaryService {

    /**
     * 刷新币种缓存
     * */
    public void refreshCurrency();

    /**
     * 刷新税率缓存
     * */
    public void refreshTaxRate();

    /**
     * 查找所有币种
     *
     * @return 币种列表
     * */
    public List<CommCurrency> findAllCurrency();

    /**
     * 查找所有税率
     *
     * @return 税率列表
     * */
    public List<CommTaxRate> findAllTaxRate();

    /**
     * 通过类型查找税率
     *
     * @return 税率列表
     * */
    public List<CommTaxRate> findTaxRateByType(Integer rateType);

    public List<CommDictionary> findDicCommodityStatus();

    /**
     * 更加类型查询数据字典
     * @param dictType
     * @return
     */
    public List<CommDictionary> findDictionaryByType(String dictType);
    /**
     * 查询数据字典
     * @param cond
     * @return
     */
    public List<CommDictionary> findDictionaryByCond(CommDictionaryCond cond);

    public List<CommDictionary> listDictionaryByCond(CommDictionaryCond cond);

    int batchInsert(List<CommDictionary> commDictionaries);

    /**
	 * 根据快递名称查询快递CODE
	 */
	public String findExpressCodeByExpressName(String ExpressName);

	Map<String , String> getCommDictionaryMap(String dictType);
}
