/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.util.service;

import com.thebeastshop.pegasus.util.model.CommCity;
import com.thebeastshop.pegasus.util.model.CommCountry;
import com.thebeastshop.pegasus.util.model.CommDistrict;
import com.thebeastshop.pegasus.util.model.CommProvince;
import com.thebeastshop.pegasus.util.vo.Region;

import java.util.List;

/**
 * @author Royan
 * @version $Id: CommAddressService.java, v 0.1 2015-07-03 上午10:05
 */
public interface CommAddressService {

    /**
     * 刷新缓存
     */
    public void refreshCache();

    /**
     * 根据ID查找国家
     *
     * @param id 国家ID;
     * @param cascade 是否级联;
     * @return 国家
     */
    public CommCountry findCountryById(Long id, boolean cascade);

    /**
     * 根据名称查找国家,精确匹配
     * @param name
     * @return 国家
     */
    public CommCountry findCountryByName(String name);

    /**
     * 查找所有国家
     *
     * @return 国家列表
     * @param cascade 是否级联;
     */
    public List<CommCountry> findAllCountry(boolean cascade);
    /**
     * 根据条件查询国外国家列表
     *
     * @return 国家列表
     * @param cascade 是否级联;
     */
    public List<CommCountry> findForeignCountry(String countryName, boolean cascade);

    /**
     * 根据国家ID查找省份
     *
     * @param countryId 国家ID;
     * @param cascade 是否级联;
     * @return 省份列表
     */
    public List<CommProvince> findProvinceByCountryId(Long countryId, boolean cascade);

    /**
     * 根据ID查找省份
     *
     * @param id 省份ID;
     * @param cascade 是否级联;
     * @return 省份
     */
    public CommProvince findProvinceById(Long id, boolean cascade);

    /**
     * 根据条件查找省份
     * @param cond
     * @return
     */
    public List<CommProvince> findProvinceByCond(String cond);
    
    /**
     * 根据条件查找省份
     * @param cond
     * @return
     */
    public CommProvince findProvinceBydistrictIdId(Long districtId);

    /**
     * 根据省份ID查找城市
     *
     * @param provinceId 省份ID;
     * @param cascade 是否级联;
     * @return 城市列表
     */
    public List<CommCity> findCityByProvinceId(Long provinceId, boolean cascade);

    public List<CommCity> findCityByProvinceIdList(List<Long> provinceIdList, boolean cascade);

    /**
     * 根据ID查找城市
     *
     * @param id      城市ID;
     * @param cascade 是否级联;
     * @return 城市
     */
    public CommCity findCityById(Long id, boolean cascade);

    public List<CommCity> findCityByIds(List<Long> ids, boolean cascade);

    /**
     * 根据城市ID查找区县
     *
     * @param cityId 城市ID;
     * @return 区县列表
     */
    public List<CommDistrict> findDistrictByCityId(Long cityId);

    /**
     * 根据ID查找区县
     *
     * @param id 区县ID;
     * @return 区县
     */
    public CommDistrict findDistrictById(Long id);

    /**
     * 根据ID查找区县
     *
     * @param ids 区县ID;
     * @return 区县
     */
    public List<CommDistrict> findDistrictByIds(List<Long> ids);

    /**
     * 根据条件查找城市
     *
     * @param cond 条件;
     * @return 城市列表
     */
    public List<CommCity> findCityByCond(String cond);

    /**
     * 查找省份下面的指定城市
     * @param provinceId
     * @param cityName
     * @return
     */
    public List<CommCity> findCityByProvinceAndName(Long provinceId,String cityName);

    /**
     * 根据条件查找区县
     *
     * @param cond
     * @return
     */
    public List<CommDistrict> findDistrictByCond(String cond);
    public List<CommDistrict> findDistrictByCityAndDistrictName(Long cityId,String districtName);
    /**
     *  根据省份ID查找所有级联的城市再级联到所有城市下的区县
     * @param id
     * @return
     */
    public List<CommDistrict> findDistrictByProvinceId(long id);

    /**
     *  根据省份ID查找所有级联的城市再级联到所有城市下的区县
     * @param id
     * @return
     */
    public List<Long> findDistrictIdByProvinceId(long id);

    
    /**
     * 根据省市区获取区县ID
     * @param region
     * @return
     */
    public CommDistrict getDistrictIdByRegion(Region region);

    /**
     * 获取可实体店配送店铺
     *
     * @return
     */
    List<CommCity> getShopCity(List list);
    
}