package com.thebeastshop.pegasus.util.route;

import org.apache.ibatis.session.TransactionIsolationLevel;
import org.apache.ibatis.transaction.Transaction;
import org.apache.ibatis.transaction.TransactionFactory;

import javax.sql.DataSource;
import java.sql.Connection;
import java.util.Properties;

/**
 * Created by roy on 16-1-6.
 */
public class ScmSpringManagedTransactionFactory  implements TransactionFactory {


    private final DataSource slaveDataSouce;

    public ScmSpringManagedTransactionFactory(DataSource slaveDataSouce) {
        this.slaveDataSouce = slaveDataSouce;
    }

    /**
     * {@inheritDoc}
     */
    public Transaction newTransaction(DataSource dataSource, TransactionIsolationLevel level, boolean autoCommit) {
        return new ScmSpringManagedTransaction(dataSource,slaveDataSouce);
    }

    /**
     * {@inheritDoc}
     */
    public Transaction newTransaction(Connection conn) {
        throw new UnsupportedOperationException("New Spring transactions require a DataSource");
    }

    /**
     * {@inheritDoc}
     */
    public void setProperties(Properties props) {
        // not needed in this version
    }

}
