package com.thebeastshop.pegasus.util.importExcel.write;

import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.importExcel.ErrorMessage;
import com.thebeastshop.pegasus.util.importExcel.ExcelColumn;
import com.thebeastshop.pegasus.util.importExcel.ExcelImgColumn;
import com.thebeastshop.pegasus.util.importExcel.ExcelTemplate;
import jxl.CellView;
import jxl.JXLException;
import jxl.Workbook;
import jxl.format.*;
import jxl.format.VerticalAlignment;
import jxl.write.*;
import jxl.write.Label;
import jxl.write.biff.JxlWriteException;
import jxl.write.biff.RowsExceededException;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.stereotype.Component;

import javax.imageio.ImageIO;
import javax.swing.*;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.lang.Number;

@Component("writeExcel")
@Scope(value="request",proxyMode=ScopedProxyMode.TARGET_CLASS)
public class GenericWriteExcel extends AbstractWriteExcel {
	
	private static final long serialVersionUID = 4632293456287402204L;

	protected List<String> errorMessages=new ArrayList<String>();
	
	protected Method getErrorMsgMethod;
	
	protected final SimpleDateFormat isoDateFormat = new SimpleDateFormat("yyyy-MM-dd");
	protected final SimpleDateFormat isoTimeFormat = new SimpleDateFormat("hh:mm:ss.SSSZ");
	protected final SimpleDateFormat isoDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
	protected final SimpleDateFormat dateTimeFormatForFileName = new SimpleDateFormat("yyyy-MM-dd-hh-mm-ss");
	
	protected List<String> headers=new ArrayList<String>();
	protected List<String> cellFormats=new ArrayList<String>();
	protected List<Field> ecFields=new ArrayList<Field>();
	
	protected File file;
	public static String FILE_PATH = File.separator + "data"+File.separator + "appdatas";
	protected WritableCellFormat boldText;
	protected WritableCellFormat normalText;

	private boolean containExcelImgColumn = false;
	
	protected Class<?> clazz;

	@Override
	public List<String> getErrors() {
		return this.errorMessages;
	}

	@Override
	public boolean hasError() {
		return errorMessages.size()>0?true:false;
	}

	@Override
	public File getFile() {
		return this.file;
	}
	@Override
	public void write(Class<?> clazz,List<?> datas) {
		this.write(clazz, datas, null);
	}

	@Override
	public void write(Class<?> clazz,List<?> datas, String fileName) {
		this.clazz=clazz;
		this.errorMessages.clear();
		this.headers.clear();
		this.ecFields.clear();
		this.containExcelImgColumn = false;
		if(this.clazz != null){
			initHeadersAndEcFields();
		}
		if(hasError())return;
		if(this.clazz != null){
			initErrorMessageMehtod();
		}
		File path=new File(FILE_PATH+File.separator+"import_invalid_excel"+File.separator);
		if(!path.exists())path.mkdirs();
		if(fileName == null || "".equals(fileName)) {
			fileName=dateTimeFormatForFileName.format(new Date())+".xls";
		}else 
			fileName+=".xls";
		file=new File(path,fileName);
		try {
			WritableWorkbook workbook=Workbook.createWorkbook(file);
			//粗体 11
			WritableFont boldFont= new WritableFont(WritableFont.ARIAL,WritableFont.DEFAULT_POINT_SIZE,WritableFont.BOLD);
			boldFont.setPointSize(11);

			boldText=new WritableCellFormat(boldFont);
			if(containExcelImgColumn){
				WritableFont normalFont= new WritableFont(WritableFont.ARIAL,WritableFont.DEFAULT_POINT_SIZE,WritableFont.NO_BOLD);
				normalFont.setPointSize(11);
				normalText=new WritableCellFormat(normalFont);
				normalText.setVerticalAlignment(VerticalAlignment.CENTRE);
			}else{
				//11
				WritableFont normalFont= new WritableFont(WritableFont.ARIAL,WritableFont.DEFAULT_POINT_SIZE,WritableFont.NO_BOLD);
				normalFont.setPointSize(11);
				normalText=new WritableCellFormat(normalFont);
			}
			WritableSheet s = workbook.createSheet("sheet1",0);
			writeHeader(s);
			writeContent(s,datas);			
			workbook.write();
			workbook.close();			
		} catch (IOException e) {
			errorMessages.add(e.getMessage());
			e.printStackTrace();
		} catch (WriteException e) {
			errorMessages.add(e.getMessage());
			e.printStackTrace();
		} catch (JXLException e) {
			errorMessages.add(e.getMessage());
			e.printStackTrace();
		}
			
	}
	
	private void initHeadersAndEcFields(){
		if(this.clazz==null){
			errorMessages.add("clazz不能为空!");
			return;
		}
		ExcelTemplate et=clazz.getAnnotation(ExcelTemplate.class);
		if(et==null){
			errorMessages.add(clazz.getName()+"不是excel模板类!");
			return;
		}
		Class<?> temp=clazz;
		List<Field> fieldsList=new ArrayList<Field>();
		while(temp!=null&&!temp.equals(Object.class)
				&&temp.getAnnotation(ExcelTemplate.class)!=null){
			Field []fs=temp.getDeclaredFields();
			for(int x=0;x<fs.length;x++){
				ExcelColumn ec=fs[x].getAnnotation(ExcelColumn.class);
				if(ec==null)continue;
				fieldsList.add(fs[x]);
			}
			temp=temp.getSuperclass();
		}
		for(int i=0;i<fieldsList.size();i++){
			Field tfield=fieldsList.get(i);
			ExcelColumn ec=tfield.getAnnotation(ExcelColumn.class);
			if(ec==null)continue;
			String columnName=ec.name().equals("")?tfield.getName():ec.name();
			String cellFormat=ec.cellFormat();
			ecFields.add(tfield);
			headers.add(columnName);
			cellFormats.add(cellFormat);
			if(!containExcelImgColumn){//检查是否包含图片列
				ExcelImgColumn ImgAnnotation = tfield.getAnnotation(ExcelImgColumn.class);
				if(NullUtil.isNotNull(ImgAnnotation)){
					containExcelImgColumn = true;
				}
			}
		}
		if(headers.size()<1){
			errorMessages.add("没有找到ExcelColumn!请检查模板类!");
			return;
		}
	}
	
	
	private int writeHeader(WritableSheet s) throws RowsExceededException, JXLException{
		int row=0;
		for(int i=0;i<headers.size();i++){
			Label l=new Label(i,0,headers.get(i),boldText);
			s.addCell(l);
			if(cellFormats.get(i)!=null && "TEXT".equals(cellFormats.get(i))){
				WritableFont normalFont= new WritableFont(WritableFont.ARIAL,WritableFont.DEFAULT_POINT_SIZE,WritableFont.NO_BOLD);
				normalFont.setPointSize(11);
				WritableCellFormat normalText=new WritableCellFormat(NumberFormats.TEXT);
				normalText.setFont(normalFont);
				CellView cv = new CellView();
				cv.setFormat(normalText);
				cv.setSize(20*265);
				s.setColumnView(i, cv);
			}
		}
		return row+1;
	}
	
	private int writeContent(WritableSheet s,List<?> datas){
		try {
			for(int i=0;i<datas.size();i++){
				if(ecFields != null && ecFields.size() > 0){
					if(containExcelImgColumn){
						s.setRowView(i+1,1600);
					}
					for(int j=0;j<ecFields.size();j++){
						Method method=clazz.getMethod(generateGetMethod(ecFields.get(j).getName()));
						Object obj=method.invoke(datas.get(i));
						Field ecFiled = ecFields.get(j);
						//图片列
						ExcelImgColumn ImgAnnotation = ecFiled.getAnnotation(ExcelImgColumn.class);
						if(NullUtil.isNotNull(ImgAnnotation)){
							if(NullUtil.isNull(obj)){
								continue;
							}
							String imgUrl = obj.toString();
							if(imgUrl == ""){
								continue;
							}
							try{
								CellView navCellView = new CellView();
								navCellView.setSize(5000);
								s.setColumnView(j,navCellView);
								URL url = new URL(imgUrl);
								Image src = Toolkit.getDefaultToolkit().getImage(url);
								BufferedImage bufferedImage = toBufferedImage(src);
								ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
								ImageIO.write(bufferedImage, "jpg", byteArrayOut);
								WritableImage writableImage = new WritableImage(j,i+1,1,1,byteArrayOut.toByteArray());
								writableImage.setImageAnchor(WritableImage.MOVE_AND_SIZE_WITH_CELLS);
								s.addImage(writableImage);
							}catch (Exception e){
								//写图片出错
							}
							continue;
						}
						//非图片
						if(obj instanceof Number){
							Number value=null;
							if(obj!=null)
								value=(Number)obj;
							jxl.write.Number n=new jxl.write.Number(j,i+1,value.doubleValue());
							n.setCellFormat(normalText);
							s.addCell(n);
						}else{
							Label l=null;
							if(obj!=null&&ecFields.get(j).getType().getName().equals("java.util.Date")){
								DateTimeFormat dtf=ecFields.get(j).getAnnotation(DateTimeFormat.class);
								if(dtf==null||dtf.iso().equals(DateTimeFormat.ISO.NONE)){
									l=new Label(j,i+1,isoDateFormat.format((Date)obj),normalText);	
								}else{
									String df=chooseISODateFormat(dtf.iso(),(Date)obj);
									l=new Label(j,i+1,df,normalText);	
								}
							}else l=new Label(j,i+1,obj==null?"":obj.toString(),normalText);
							s.addCell(l);
						}
					}
				}else{
					Object[] data = (Object[]) datas.get(i);
					for(int j = 0;j < data.length;j++){
						Label l=null;
						l=new Label(j,i+1,data[j]==null?"":data[j].toString(),normalText);
						s.addCell(l);
					}
				}
				if(getErrorMessage(datas.get(i)).length()>0){
					Label l=new Label(ecFields.size(),i+1,getErrorMessage(datas.get(i)),normalText);
					s.addCell(l);
				}
			}
		} catch (SecurityException e) {
			e.printStackTrace();
		} catch (NoSuchMethodException e) {
			e.printStackTrace();
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		} catch (JxlWriteException e) {
			e.printStackTrace();
		} catch (WriteException e) {
			e.printStackTrace();
		}
		return 0;
	}
	
	protected String chooseISODateFormat(DateTimeFormat.ISO iso,Date date){
		if(iso.equals(DateTimeFormat.ISO.DATE))return isoDateFormat.format(date);
		if(iso.equals(DateTimeFormat.ISO.TIME))return isoTimeFormat.format(date);
		if(iso.equals(DateTimeFormat.ISO.DATE_TIME))return isoDateTimeFormat.format(date);
		return "yyyy-MM-dd";
	}
	
	protected void initErrorMessageMehtod(){
		Field []fields=clazz.getDeclaredFields();
		try {
			for(int i=0;i<fields.length;i++){
				ErrorMessage em=fields[i].getAnnotation(ErrorMessage.class);
				if(em==null)continue;
				getErrorMsgMethod=clazz.getMethod(generateGetMethod(fields[i].getName()));
				break;
			}
		} catch (SecurityException e) {
			e.printStackTrace();
		} catch (NoSuchMethodException e) {
			e.printStackTrace();
		}
	}
	
	protected String getErrorMessage(Object obj){
		if(getErrorMsgMethod!=null){
			try {
				Object value=getErrorMsgMethod.invoke(obj);
				return value==null?"":value.toString();
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				e.printStackTrace();
			}
		}
		return "";
	}
	
	
	protected String generateGetMethod(String fieldName){
		if(fieldName==null||fieldName.length()<1)return "";
		return "get"+fieldName.toUpperCase().charAt(0)+fieldName.substring(1);
	}

	public static BufferedImage toBufferedImage(Image image) {
		if (image instanceof BufferedImage) {
			return (BufferedImage) image;
		}
		// This code ensures that all the pixels in the image are loaded
		image = new ImageIcon(image).getImage();
		BufferedImage bimage = null;
		GraphicsEnvironment ge = GraphicsEnvironment .getLocalGraphicsEnvironment();
		try {
			int transparency = Transparency.OPAQUE;
			GraphicsDevice gs = ge.getDefaultScreenDevice();
			GraphicsConfiguration gc = gs.getDefaultConfiguration();
			bimage = gc.createCompatibleImage(image.getWidth(null),image.getHeight(null), transparency);
		} catch (HeadlessException e) {

		}
		if (bimage == null) {
			// Create a buffered image using the default color model
			int type = BufferedImage.TYPE_INT_RGB;
			bimage = new BufferedImage(image.getWidth(null),
					image.getHeight(null), type);
		}
		// Copy image to buffered image
		Graphics g = bimage.createGraphics();
		// Paint the image onto the buffered image
		g.drawImage(image, 0, 0, null);
		g.dispose();
		return bimage;
	}
	
	public static void main(String[] args) {
		
		File path=new File("/import_invalid_excel/admin");
		if(!path.exists())path.mkdirs();
		
		//System.out.println(path.getAbsolutePath());
		
	}

//	@Override
//	public File createFile(String fileName) {
//		// TODO Auto-generated method stub
//		return null;
//	}
//
//	@Override
//	public void write(Class<?> clazz, DataOutputStream dataOutputStream,
//			List<?> datas, int totalPage, int currentPage, String sheetName) {
//		// TODO Auto-generated method stub
//
//	}

}
