package com.thebeastshop.pegasus.util.importExcel.write;

import com.thebeastshop.pegasus.util.importExcel.ErrorMessage;
import com.thebeastshop.pegasus.util.importExcel.ExcelColumn;
import com.thebeastshop.pegasus.util.importExcel.ExcelSheet;
import com.thebeastshop.pegasus.util.importExcel.ExcelTemplate;
import jxl.CellView;
import jxl.JXLException;
import jxl.Workbook;
import jxl.write.*;
import jxl.write.biff.JxlWriteException;
import jxl.write.biff.RowsExceededException;
import org.apache.commons.io.FileUtils;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.stereotype.Component;

import java.io.File;
import java.lang.Number;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by Administrator on 2017/8/29.
 */
@Component("advancedWriteExcel")
@Scope(value="request",proxyMode= ScopedProxyMode.TARGET_CLASS)
public class AdvancedWriteExcel implements MultSheetWriteExcel {

    protected List<String> errorMessages=new ArrayList<String>();

    public static String FILE_PATH = File.separator + "data"+File.separator + "appdatas";

    protected final SimpleDateFormat isoDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    protected final SimpleDateFormat isoTimeFormat = new SimpleDateFormat("hh:mm:ss.SSSZ");
    protected final SimpleDateFormat isoDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    protected final SimpleDateFormat dateTimeFormatForFileName = new SimpleDateFormat("yyyy-MM-dd-hh-mm-ss");

    protected WritableCellFormat boldText;
    protected WritableCellFormat normalText;

    protected File file;

    @Override
    public byte[] write(Map<Class<?>, List<?>> sheetMap) {
        List<String> headers = new ArrayList<>();
        List<String> cellFormats = new ArrayList<>();
        List<Field> ecFields = new ArrayList<>();
        Method getErrorMsgMethod = null;
        try{
            File file = createTmpFile();
            WritableWorkbook workbook = Workbook.createWorkbook(file);
            //粗体 11
            WritableFont boldFont= new WritableFont(WritableFont.ARIAL,WritableFont.DEFAULT_POINT_SIZE,WritableFont.BOLD);
            boldFont.setPointSize(11);
            //11
            WritableFont normalFont= new WritableFont(WritableFont.ARIAL,WritableFont.DEFAULT_POINT_SIZE,WritableFont.NO_BOLD);
            normalFont.setPointSize(11);
            boldText = new WritableCellFormat(boldFont);
            normalText = new WritableCellFormat(normalFont);
            int idx = 0;
            for(Map.Entry<Class<?>,List<?>> entry : sheetMap.entrySet()){
                Class<?> clazz = entry.getKey();
                List<?> datas = entry.getValue();
                WritableSheet sheet = createSheet(clazz,workbook,idx++);
                headers.clear();
                ecFields.clear();
                cellFormats.clear();
                //init
                initHeadersAndEcFields(clazz,headers,ecFields,cellFormats);
                if(hasError()){
                    break;
                }
                writeHeader(sheet,headers,cellFormats);
                getErrorMsgMethod = initErrorMessageMehtod(clazz);
                writeContent(clazz,getErrorMsgMethod,sheet,ecFields,datas);
            }
            workbook.write();
            workbook.close();
            byte[] bytes = FileUtils.readFileToByteArray(file);
            try{
                file.delete();
            }catch(Exception e){}
            return bytes;
        }catch(Exception e){
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public List<String> getErrors() {
        return errorMessages;
    }

    @Override
    public boolean hasError() {
        return errorMessages.size()>0;
    }

    private void initHeadersAndEcFields(Class<?> clazz, List<String> headers, List<Field> ecFields, List<String> cellFormats){
        ExcelTemplate et=clazz.getAnnotation(ExcelTemplate.class);
        if(et==null){
            errorMessages.add(clazz.getName()+"不是excel模板类!");
            return;
        }
        Class<?> temp=clazz;
        List<Field> fieldsList=new ArrayList<Field>();
        while(temp!=null&&!temp.equals(Object.class)
                &&temp.getAnnotation(ExcelTemplate.class)!=null){
            Field []fs=temp.getDeclaredFields();
            for(int x=0;x<fs.length;x++){
                ExcelColumn ec=fs[x].getAnnotation(ExcelColumn.class);
                if(ec==null)continue;
                fieldsList.add(fs[x]);
            }
            temp=temp.getSuperclass();
        }
        for(int i=0;i<fieldsList.size();i++){
            Field tfield=fieldsList.get(i);
            ExcelColumn ec=tfield.getAnnotation(ExcelColumn.class);
            if(ec==null)continue;
            String columnName=ec.name().equals("")?tfield.getName():ec.name();
            String cellFormat=ec.cellFormat();
            ecFields.add(tfield);
            headers.add(columnName);
            cellFormats.add(cellFormat);
        }
        if(headers.size()<1){
            errorMessages.add("没有找到ExcelColumn!请检查模板类!");
            return;
        }
    }


    private int writeHeader(WritableSheet s,List<String> headers,List<String> cellFormats) throws RowsExceededException, JXLException {
        int row=0;
        for(int i=0;i<headers.size();i++){
            Label l=new Label(i,0,headers.get(i),boldText);
            s.addCell(l);
            if(cellFormats.get(i)!=null && "TEXT".equals(cellFormats.get(i))){
                WritableFont normalFont= new WritableFont(WritableFont.ARIAL,WritableFont.DEFAULT_POINT_SIZE,WritableFont.NO_BOLD);
                normalFont.setPointSize(11);
                WritableCellFormat normalText=new WritableCellFormat(NumberFormats.TEXT);
                normalText.setFont(normalFont);
                CellView cv = new CellView();
                cv.setFormat(normalText);
                cv.setSize(20*265);
                s.setColumnView(i, cv);
            }
        }
        return row+1;
    }

    private int writeContent(Class<?> clazz,Method getErrorMsgMethod,WritableSheet s,List<Field> ecFields,List<?> datas){
        if(datas == null){
            return 0;
        }
        try {
            for(int i=0;i<datas.size();i++){
                if(ecFields != null && ecFields.size() > 0){
                    for(int j=0;j<ecFields.size();j++){
                        Method method=clazz.getMethod(generateGetMethod(ecFields.get(j).getName()));
                        Object obj=method.invoke(datas.get(i));
                        if(obj instanceof Number){
                            Number value=null;
                            if(obj!=null)
                                value=(Number)obj;
//						else
//							value=0;
                            jxl.write.Number n=new jxl.write.Number(j,i+1,value.doubleValue());
                            s.addCell(n);
                        }else{
                            Label l=null;
                            if(obj!=null&&ecFields.get(j).getType().getName().equals("java.util.Date")){
                                DateTimeFormat dtf=ecFields.get(j).getAnnotation(DateTimeFormat.class);
                                if(dtf==null||dtf.iso().equals(DateTimeFormat.ISO.NONE)){
                                    l=new Label(j,i+1,isoDateFormat.format((Date)obj),normalText);
                                }else{
                                    String df=chooseISODateFormat(dtf.iso(),(Date)obj);
                                    l=new Label(j,i+1,df,normalText);
                                }
                            }else l=new Label(j,i+1,obj==null?"":obj.toString(),normalText);
                            s.addCell(l);
                        }
                    }
                }else{
                    Object[] data = (Object[]) datas.get(i);
                    for(int j = 0;j < data.length;j++){
                        Label l=null;
                        l=new Label(j,i+1,data[j]==null?"":data[j].toString(),normalText);
                        s.addCell(l);
                    }
                }
                if(getErrorMessage(datas.get(i),getErrorMsgMethod).length()>0){
                    Label l=new Label(ecFields.size(),i+1,getErrorMessage(datas.get(i),getErrorMsgMethod),normalText);
                    s.addCell(l);
                }
            }
        } catch (SecurityException e) {
            e.printStackTrace();
        } catch (NoSuchMethodException e) {
            e.printStackTrace();
        } catch (IllegalArgumentException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        } catch (JxlWriteException e) {
            e.printStackTrace();
        } catch (WriteException e) {
            e.printStackTrace();
        }
        return 0;
    }

    protected Method initErrorMessageMehtod(Class<?> clazz){
        Field []fields=clazz.getDeclaredFields();
        try {
            for(int i=0;i<fields.length;i++){
                ErrorMessage em = fields[i].getAnnotation(ErrorMessage.class);
                if(em==null)
                    continue;
                return clazz.getMethod(generateGetMethod(fields[i].getName()));
            }
        } catch (SecurityException e) {
            e.printStackTrace();
        } catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected String generateGetMethod(String fieldName){
        if(fieldName==null||fieldName.length()<1)return "";
        return "get"+fieldName.toUpperCase().charAt(0)+fieldName.substring(1);
    }

    private File createTmpFile(){
        String fileName =dateTimeFormatForFileName.format(new Date())+".xls";
        File path = new File(FILE_PATH+File.separator+"import_invalid_excel"+File.separator);
        return new File(path,fileName);
    }

    private WritableSheet createSheet(Class<?> clazz,WritableWorkbook workbook,int idx){
        ExcelSheet es = clazz.getAnnotation(ExcelSheet.class);
        String name = es.value();
        int index = es.index();
        if(index == 0){
            index = idx;
        }
        if(name == null || name == ""){
            name = "sheet"+index;
        }
        return workbook.createSheet(name,index);
    }

    protected String getErrorMessage(Object obj,Method getErrorMsgMethod){
        if(getErrorMsgMethod!=null){
            try {
                Object value=getErrorMsgMethod.invoke(obj);
                return value==null?"":value.toString();
            } catch (IllegalArgumentException e) {
                e.printStackTrace();
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            } catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    protected String chooseISODateFormat(DateTimeFormat.ISO iso,Date date){
        if(iso.equals(DateTimeFormat.ISO.DATE))return isoDateFormat.format(date);
        if(iso.equals(DateTimeFormat.ISO.TIME))return isoTimeFormat.format(date);
        if(iso.equals(DateTimeFormat.ISO.DATE_TIME))return isoDateTimeFormat.format(date);
        return "yyyy-MM-dd";
    }
}
