package com.thebeastshop.pegasus.util.importExcel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import jxl.*;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.convert.ConversionService;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.validation.Validator;

import jxl.read.biff.BiffException;

/**
 * Created by Administrator on 2016/4/11.
 */
@Component("advancedParseExcelComponent")
@Scope(value = "request", proxyMode = ScopedProxyMode.TARGET_CLASS)
public class AdvancedParseExcelComponent {

    @Autowired
    protected Validator beanVidator;

    @Autowired
    protected ConversionService myConversionService;

    public <T> Parser<T> parse(InputStream is, Class<T> clazz) {
        Parser<T> parser = new Parser<>();
        parser.parse(is, clazz);
        return parser;
    }

    public <T> Parser<T> parse(File file, Class<T> clazz) {
        Parser<T> parser = new Parser<>();
        parser.parse(file, clazz);
        return parser;

    }

    public <T> Parser<T>  parse(String fileName, Class<T> clazz) {
        Parser<T> parser = new Parser<>();
        parser.parse(fileName, clazz);
        return parser;
    }


    public class Parser<T> {

        protected Class<T> clazz;

        protected InputStream is;

        protected List<ObjectError> errorMessages = new ArrayList<ObjectError>();

        protected List<String> warnMessages = new ArrayList<String>();

        protected Set<String> headerColumn = new HashSet<String>();

        protected Map<Integer, Field> columnMap = new HashMap<Integer, Field>();

        protected Map<String, String> fieldNameMap = new HashMap<String, String>();

        private Map<String, FieldReader> fieldReaderMap = new HashedMap();

        protected List<T> availableResults = new ArrayList<T>();

        protected List<T> allResults = new ArrayList<T>();

        protected List<T> failureResults = new ArrayList<T>();

        protected Method setErrorMsgMethod;

        protected Method getErrorMsgMethod;

        private Method setColumnNumberMethod;


        public void parse(InputStream is, Class<T> clazz) {
            this.is = is;
            this.clazz = clazz;
            validateExcel();
        }

        public void parse(File file, Class<T> clazz) {
            if (file == null)
                throw new IllegalArgumentException("the file is null!");
            try {
                this.is = new FileInputStream(file);
                this.clazz = clazz;
                validateExcel();
            } catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }

        public void parse(String fileName, Class<T> clazz) {
            if (fileName == null || fileName.trim().length() < 1)
                throw new IllegalArgumentException("the file path is empty");
            File file = new File(fileName);
            try {
                this.is = new FileInputStream(file);
                this.clazz = clazz;
                validateExcel();
            } catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }

        public List<T> getAvailableResults() {
            return availableResults;
        }

        public List<ObjectError> getErrorMessages() {
            return errorMessages;
        }

        public String getErrorInfo() {
            StringBuffer stringBuffer = new StringBuffer();
            if (errorMessages != null && errorMessages.size() > 0) {
                for (ObjectError error : errorMessages) {
                    stringBuffer.append(error.getDefaultMessage());
                    stringBuffer.append("</br>");
                }
            }
            return stringBuffer.toString();
        }

        public List<T> getFailureResults() {
            return failureResults;
        }

        public List<T> getAllResults() {
            return allResults;
        }

        public boolean hasErrors() {
            return errorMessages.size() > 0 ? true : false;
        }

        public List<String> getWarnMessages() {
            return warnMessages;
        }

        public boolean hasWarns() {
            return warnMessages.size() > 0 ? true : false;
        }


        protected Sheet getSheet(Workbook wb) {
            ExcelSheet st = clazz.getAnnotation(ExcelSheet.class);
            String sheetName = st.value();
            if (StringUtils.isNotEmpty(sheetName)) {
                return wb.getSheet(sheetName);
            }
            int index = st.index();
            return wb.getSheet(index);
        }


        private void validateExcel() {
            ExcelTemplate et = clazz.getAnnotation(ExcelTemplate.class);
            if (et == null)
                throw new RuntimeException("the class is not a excel template data");
            try {
                WorkbookSettings workbooksetting = new WorkbookSettings();
                workbooksetting.setCellValidationDisabled(true);
                Workbook wb = Workbook.getWorkbook(is, workbooksetting);
                Sheet sheet = getSheet(wb);
                if (sheet == null || sheet.getRows() <= 0) {
                    errorMessages.add(new ObjectError(clazz.getName(), "Excel文件格式不正确，请严格按照给定的格式生成excel文件!"));
                    return;
                }
                Cell[] firstRow = sheet.getRow(0);
                if (firstRow.length < 1) {
                    errorMessages.add(new ObjectError(clazz.getName(), "Excel文件没有第一行，请严格按照给定的格式生成excel文件!"));
                    return;
                }
                checkExcelHeader(firstRow);
                if (errorMessages.size() > 0)
                    return;
                if (fieldReaderMap.keySet().size() < 1) {
                    errorMessages.add(new ObjectError(clazz.getName(), "Excel文件第一行的列名与模板完全不符,请严格按照给定的格式生成excel文件!"));
                    return;
                }
                // 初始化注释ErrorMessage字段的set和get方法和columnNumber字段的set方法
                initErrorMessageAndColumnNumberMehtod();
                // 把excel转换为javabean对象，然后再对每个属性进行验证
                convertToJavaBean(sheet);
                // 验证生成的javabean
                int rowTip = 1;
                for (T t : allResults) {
                    validate(t, rowTip);
                    rowTip++;
                }
                // 检查注释ExcelColumn中unique为true的field
                checkUniqueConstrain();

            } catch (BiffException e) {
                e.printStackTrace();
            } catch (IOException e) {
                e.printStackTrace();
            } catch (SecurityException e) {
                e.printStackTrace();
            }
        }

        protected void checkExcelHeader(Cell[] firstRowCells) {
            Class<? super T> temp = clazz;
            List<Field> fieldsList = new ArrayList<Field>();
            while (temp != null && !temp.equals(Object.class) && temp.getAnnotation(ExcelTemplate.class) != null) {
                Field[] fs = temp.getDeclaredFields();
                for (int x = 0; x < fs.length; x++) {
                    Field f = fs[x];
                    ExcelColumn ec = f.getAnnotation(ExcelColumn.class);
                    ExcelColumnList ecl = f.getAnnotation(ExcelColumnList.class);
                    if (ec == null && ecl == null)
                        continue;
                    fieldsList.add(f);
                }
                temp = temp.getSuperclass();
            }
            for (int i = 0; i < firstRowCells.length; i++) {
                String content = firstRowCells[i].getContents();
                if (content == null || content.trim().length() < 1)
                    continue;
                content = content.trim();
                for (int j = 0; j < fieldsList.size(); j++) {
                    Field f = fieldsList.get(j);
                    ExcelColumn ec = f.getAnnotation(ExcelColumn.class);
                    ExcelColumnList ecl = f.getAnnotation(ExcelColumnList.class);
                    if (ec == null && ecl == null)
                        continue;
                    FieldReader fieldReader = null;
                    if (ecl != null) {
                        int from = ecl.from();
                        int to = ecl.to();
                        if (i < from) {
                            continue;
                        }
                        if (to >= 0 && i > to) {
                            continue;
                        }
                        if (to < 0 && i > firstRowCells.length + to) {
                            continue;
                        }
                        fieldReader = new ListFieldReader();
                        ListFieldReader listFieldReader = (ListFieldReader) fieldReader;
                        listFieldReader.setFrom(ecl.from());
                        listFieldReader.setTo(ecl.to());
                        listFieldReader.setItemClass(ecl.type());
                        listFieldReader.setColumnFieldName(ecl.columnFiled());
                        listFieldReader.setValueFieldName(ecl.valueField());
                        columnMap.put(i, fieldsList.get(j));
                        fieldNameMap.put(fieldsList.get(j).getName(), content);
                    } else {
                        fieldReader = new FieldReader();
                        String columnName = ec.name().equals("") ? fieldsList.get(j).getName() : ec.name();
                        fieldNameMap.put(fieldsList.get(j).getName(), ec.name());
                        if (content.equals(columnName)) {
                            if (!headerColumn.add(columnName))
                                errorMessages.add(new ObjectError(clazz.getName(), "在模板中发现有重复的列名" + columnName));
                            else
                                columnMap.put(i, fieldsList.get(j));
                        }
                    }
                    fieldReader.setField(f);
                    fieldReader.setIndex(i);
                    fieldReaderMap.put(f.getName(), fieldReader);
                }
            }
        }

        private class FieldReader {
            protected String chineseName;
            protected Field field;
            protected int index = 0;

            public Object read(Cell cell, RowReader<T> rowReader) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, NoSuchFieldException, InstantiationException {
                //String content = cell.getContents().trim();
                String content = getCellContent(cell);
                //4为小数点精度问题
                if (field.getType().getName().equals("java.math.BigDecimal")){
                    if (cell instanceof  NumberCell) {
                        if (cell != null) {
                            content = ((NumberCell) cell).getValue() + "";
                        }
                    }
                }
                T instance = rowReader.getInstance();
                Object value = null;
                if (content.length() > 0) {
                    Method method = clazz.getMethod(generateSetMethod(field.getName()), field.getType());
                    // 如果为string类型则不做转型
                    if (!String.class.getName().equals(field.getType().getName())) {
                        try {
                            // excel里面是date类型，对应模板里也是date类型的情况
                            if (Date.class.getName().equals(field.getType().getName())) {
                                DateCell dc = (DateCell) cell;
                                value = dc.getDate();
                                method.invoke(instance, value);
                            } else {
                                value = myConversionService.convert(content, field.getType());
                                method.invoke(instance, value);
                            }
                        } catch (Exception e) {
                            warnMessages.add("第" + (rowReader.getRowNumber() + 1) + "行中," + chineseName + "格式不正确");
                            errorMessages.add(new
                                    FieldError(clazz.getName(), field.getName(), "第" + rowReader.getRowNumber() + "行中," + chineseName + "格式不正确"));
                        }
                    } else {
                        value = content;
                        method.invoke(instance, value);
                        // System.out.println("~~~~~~~~~~~"+method.getName());
                        // Method
                        // method=ReflectionUtils.findMethod(clazz,
                        // field.getName());
                    }
                } else {
                    rowReader.incNullCount();
                }

                return value;
            }

            public String getChineseName() {
                return chineseName;
            }

            public void setChineseName(String chineseName) {
                this.chineseName = chineseName;
            }

            public Field getField() {
                return field;
            }

            public void setField(Field field) {
                this.field = field;
            }

            public int getIndex() {
                return index;
            }

            public void setIndex(int index) {
                this.index = index;
            }

            private String getCellContent(Cell cell){
                if(CellType.NUMBER_FORMULA.equals(cell.getType())
                        || CellType.STRING_FORMULA.equals(cell.getType())
                        || CellType.BOOLEAN_FORMULA.equals(cell.getType())
                        || CellType.DATE_FORMULA.equals(cell.getType())
                        || CellType.FORMULA_ERROR.equals(cell.getType())){
                    FormulaCell nfc = (FormulaCell) cell;
                    try{
                        return nfc.getFormula();
                    }catch(Exception e){
                        throw new RuntimeException(e.getMessage());
                    }
                }else{
                    return cell.getContents().trim();
                }
            }
        }


        private Class classFromType(Type type, int i) {
            if (type instanceof ParameterizedType) { // 处理泛型类型
                return getGenericClass((ParameterizedType) type, i);
            } else if (type instanceof TypeVariable) {
                return (Class) classFromType(((TypeVariable) type).getBounds()[0], 0); // 处理泛型擦拭对象
            } else {// class本身也是type，强制转型
                return (Class) type;
            }
        }


        private Class getGenericClass(ParameterizedType parameterizedType, int i) {
            Object genericClass = parameterizedType.getActualTypeArguments()[i];
            if (genericClass instanceof ParameterizedType) { // 处理多级泛型
                return (Class) ((ParameterizedType) genericClass).getRawType();
            } else if (genericClass instanceof GenericArrayType) { // 处理数组泛型
                return (Class) ((GenericArrayType) genericClass).getGenericComponentType();
            } else if (genericClass instanceof TypeVariable) { // 处理泛型擦拭对象
                return (Class) classFromType(((TypeVariable) genericClass).getBounds()[0], 0);
            } else {
                return (Class) genericClass;
            }
        }

        private class ListFieldReader extends FieldReader {
            private int from = 0;
            private int to = -1;
            private Class itemClass;
            private String columnFieldName;
            private String valueFieldName;

            @Override
            public Object read(Cell cell, RowReader<T> rowReader) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, NoSuchFieldException, InstantiationException {
                String content = cell.getContents().trim();
                T instance = rowReader.getInstance();
                List value = null;
                if (content.length() > 0) {
                    Class fieldType = field.getType();
                    Method getter = clazz.getMethod(generateGetMethod(field.getName()));
                    value = (List) getter.invoke(instance);
                    Method setter = clazz.getMethod(generateSetMethod(field.getName()), field.getType());
                    if (value == null) {
                        value = new ArrayList();
                        setter.invoke(instance, value);
                    }
                    Integer num = null;
                    try {
                        num = Integer.parseInt(content);
                    } catch (Exception ex) {
                    }
                    if (num != null) {
                        if (itemClass.equals(Object.class)) {
                            itemClass = classFromType(fieldType.getGenericInterfaces()[0], 0);
                        }
                        Object itemObj = itemClass.newInstance();

                        if (itemObj != null) {
                            Field columnField = itemClass.getDeclaredField(columnFieldName);
                            Field valueField = itemClass.getDeclaredField(valueFieldName);

                            String columnSetterName = generateSetMethod(columnField.getName());
                            String valueSetterName = generateSetMethod(valueField.getName());
                            Method columnSetter = itemClass.getDeclaredMethod(columnSetterName, columnField.getType());
                            Method valueSetter = itemClass.getDeclaredMethod(valueSetterName, valueField.getType());
                            columnSetter.invoke(itemObj, chineseName);
                            valueSetter.invoke(itemObj, num);
                            value.add(itemObj);
                        }
                    }

                }
                return value;
            }

            public String getColumnFieldName() {
                return columnFieldName;
            }

            public void setColumnFieldName(String columnFieldName) {
                this.columnFieldName = columnFieldName;
            }

            public String getValueFieldName() {
                return valueFieldName;
            }

            public void setValueFieldName(String valueFieldName) {
                this.valueFieldName = valueFieldName;
            }

            public Class getItemClass() {
                return itemClass;
            }

            public void setItemClass(Class itemClass) {
                this.itemClass = itemClass;
            }

            public int getFrom() {
                return from;
            }

            public void setFrom(int from) {
                this.from = from;
            }

            public int getTo() {
                return to;
            }

            public void setTo(int to) {
                this.to = to;
            }
        }

        private class RowReader<T> {
            private int rowNumber = 0;
            private T instance;
            private int nullCount = 0;

            public int getRowNumber() {
                return rowNumber;
            }

            public void setRowNumber(int rowNumber) {
                this.rowNumber = rowNumber;
            }

            public T getInstance() {
                return instance;
            }

            public void setInstance(T instance) {
                this.instance = instance;
            }

            public int getNullCount() {
                return nullCount;
            }

            public void setNullCount(int nullCount) {
                this.nullCount = nullCount;
            }

            public int incNullCount() {
                nullCount++;
                return nullCount;
            }
        }

        protected void convertToJavaBean(Sheet sheet) {
            try {
                int row = sheet.getRows();
                for (int i = 1; i < row; i++) {
                    Cell[] cells = sheet.getRow(i);
                    RowReader<T> rowReader = new RowReader<>();
                    rowReader.setRowNumber(i);
                    rowReader.setInstance(clazz.newInstance());
                    rowReader.setNullCount(0);
                    for (Integer j : columnMap.keySet()) {
                        Field field = columnMap.get(j);
                        if (field == null) {
                            rowReader.incNullCount();
                            continue;
                        }
                        // 可能头的列数会大于下面内容的列数，所以做如下处理
                        if (j < cells.length) {
                            Cell[] firstRow = sheet.getRow(0);
//                        String chineseName = fieldNameMap.get(field.getName()).length() < 1 ? field.getName() : fieldNameMap.get(field.getName());
                            String chineseName = firstRow[j].getContents();
                            FieldReader fieldReader = fieldReaderMap.get(field.getName());
                            fieldReader.setChineseName(chineseName);
                            Cell cell = cells[j];
                            Object newValue = fieldReader.read(cell, rowReader);
//                        field.set(rowReader.getInstance(), newValue);
/*
                        if (CellType.EMPTY.equals(cells[j].getType()) || CellType.ERROR.equals(cells[j].getType())) {
                            rowReader.incNullCount();
                            continue;
                        }
                        String content = cells[j].getContents().trim();
                        if (content.length() > 0) {
                            Method method = clazz.getMethod(generateSetMethod(field.getName()), field.getType());
                            // 如果为string类型则不做转型
                            if (!String.class.getName().equals(field.getType().getName())) {
                                try {
                                    // excel里面是date类型，对应模板里也是date类型的情况
                                    if (Date.class.getName().equals(field.getType().getName())) {
                                        DateCell dc = (DateCell) cells[j];
                                        method.invoke(rowReader.getInstance(), dc.getDate());
                                    } else {
                                        method.invoke(rowReader.getInstance(), myConversionService.convert(content, field.getType()));
                                    }
                                } catch (Exception e) {
                                    warnMessages.add("第" + (i + 1) + "行中," + chineseName + "格式不正确");
                                    errorMessages.add(new
                                            FieldError(clazz.getName(),field.getName(),"第"+i+"行中,"+chineseName+"格式不正确"));
                                }
                            } else {
                                method.invoke(rowReader.getInstance(), content);
                                // System.out.println("~~~~~~~~~~~"+method.getName());
                                // Method
                                // method=ReflectionUtils.findMethod(clazz,
                                // field.getName());
                            }
                        } else {
                            rowReader.incNullCount();
                        }
*/
                        } else {
                            rowReader.incNullCount();
                        }
                    }
                    if (columnMap.size() > rowReader.getNullCount()) {
                        setExcelColumnNumber(rowReader.getInstance(), i + 1);
                        allResults.add(rowReader.getInstance());
                    }
                }
            } catch (InstantiationException e) {
                e.printStackTrace();
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            } catch (SecurityException e) {
                e.printStackTrace();
            } catch (NoSuchMethodException e) {
                e.printStackTrace();
            } catch (NoSuchFieldException e) {
                e.printStackTrace();
            } catch (IllegalArgumentException e) {
                e.printStackTrace();
            } catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }

        // 验证通过添加到availableResults否则添加到failureResults
        @SuppressWarnings("unchecked")
        protected void validate(T obj, int row) {
            BindException errors = new BindException(obj, clazz.getSimpleName());
            beanVidator.validate(obj, errors);
            if (errors.hasErrors()) {
                for (FieldError error : (List<FieldError>) errors.getFieldErrors()) {
                    if (fieldNameMap.get(error.getField()) == null)
                        continue;
                    String chineseName = fieldNameMap.get(error.getField()).length() < 1 ? error.getField() : fieldNameMap.get(error.getField());
                    errorMessages.add(new FieldError(error.getObjectName(), error.getField(), "第" + (row + 1) + "行中," + chineseName
                            + error.getDefaultMessage()));
                    setErrorMessage(obj, chineseName + error.getDefaultMessage());
                }
                failureResults.add(obj);
            } else {
                availableResults.add(obj);
            }
        }

        protected void checkUniqueConstrain() {
            // 得到unique为true的field
            Set<Field> fields = new HashSet<Field>();
            for (int i : columnMap.keySet()) {
                Field field = columnMap.get(i);
                ExcelColumn ec = field.getAnnotation(ExcelColumn.class);
                if (ec == null)
                    continue;
                if (ec.unique() == true)
                    fields.add(field);
            }
            if (fields.size() < 1)
                return;
            try {
                List<T> needToRemove = new ArrayList<T>();
                for (Field f : fields) {
                    Method method = clazz.getMethod(generateGetMethod(f.getName()));
                    for (int i = 0; i < availableResults.size(); i++) {
                        T t = availableResults.get(i);
                        Object obj = method.invoke(t);
                        int rowDis = 2;
                        boolean hasIt = false;
                        String chineseName = fieldNameMap.get(f.getName()).length() < 1 ? f.getName() : fieldNameMap.get(f.getName());
                        for (int j = 0; j < availableResults.size(); j++) {
                            T sub = availableResults.get(j);
                            if (j != i && !needToRemove.contains(sub)) {
                                Object sobj = method.invoke(sub);
                                if (obj != null && obj.equals(sobj)) {
                                    errorMessages.add(new FieldError(clazz.getName(), "multiple_" + f.getName(), "第" + (i + rowDis) + "行和第"
                                            + (j + rowDis) + "行中的" + chineseName + "数据重复!"));
                                    setErrorMessage(sub, chineseName + "数据重复!");
                                    needToRemove.add(sub);
                                    hasIt = true;
                                }
                            }
                        }
                        if (hasIt) {
                            needToRemove.add(t);
                            setErrorMessage(t, chineseName + "数据重复!");
                        }
                    }
                    if (needToRemove.size() > 0) {
                        availableResults.removeAll(needToRemove);
                        failureResults.addAll(needToRemove);
                    }
                    needToRemove.clear();
                }
            } catch (SecurityException e) {
                e.printStackTrace();
            } catch (NoSuchMethodException e) {
                e.printStackTrace();
            } catch (IllegalArgumentException e) {
                e.printStackTrace();
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            } catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }

        protected void initErrorMessageAndColumnNumberMehtod() {
            Field[] fields = clazz.getDeclaredFields();
            try {
                for (int i = 0; i < fields.length; i++) {
                    ErrorMessage em = fields[i].getAnnotation(ErrorMessage.class);
                    ExcelColumnNumber ecn = fields[i].getAnnotation(ExcelColumnNumber.class);
                    if (em != null && setErrorMsgMethod == null) {
                        setErrorMsgMethod = clazz.getMethod(generateSetMethod(fields[i].getName()), fields[i].getType());
                        getErrorMsgMethod = clazz.getMethod(generateGetMethod(fields[i].getName()));
                    }
                    if (ecn != null && setColumnNumberMethod == null) {
                        setColumnNumberMethod = clazz.getMethod(generateSetMethod(fields[i].getName()), fields[i].getType());
                    }
                }
            } catch (SecurityException e) {
                e.printStackTrace();
            } catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }

        private void setExcelColumnNumber(T obj, Integer number) {
            if (setColumnNumberMethod != null) {
                try {
                    setColumnNumberMethod.invoke(obj, number);
                } catch (IllegalArgumentException e) {
                    e.printStackTrace();
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                } catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }

        private void setErrorMessage(T obj, String message) {
            if (setErrorMsgMethod != null)
                try {
                    String em = getErrorMessage(obj);
                    if (em != null && em.trim().length() > 0)
                        setErrorMsgMethod.invoke(obj, em + ";" + message);
                    else
                        setErrorMsgMethod.invoke(obj, message);
                } catch (IllegalArgumentException e) {
                    e.printStackTrace();
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                } catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
        }

        private String getErrorMessage(T obj) {
            if (getErrorMsgMethod != null)
                try {
                    return (String) getErrorMsgMethod.invoke(obj);
                } catch (IllegalArgumentException e) {
                    e.printStackTrace();
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                } catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            return null;
        }

        private String generateSetMethod(String fieldName) {
            if (fieldName == null || fieldName.length() < 1)
                return "";
            return "set" + fieldName.toUpperCase().charAt(0) + fieldName.substring(1);
        }

        private String generateGetMethod(String fieldName) {
            if (fieldName == null || fieldName.length() < 1)
                return "";
            return "get" + fieldName.toUpperCase().charAt(0) + fieldName.substring(1);
        }

//        public static void main(String[] args) {

		/*
		 * File file=new File("e:/0510.xls"); ApplicationContext context = new
		 * ClassPathXmlApplicationContext( new
		 * String[]{"classpath*:META-INF/spring/applicationContext*.xml"});
		 * Validator beanValidator=(Validator)context.getBean("beanValidator");
		 * ConversionService
		 * conversionService=(ConversionService)context.getBean
		 * ("conversionService"); ParseExcelComponent<MemberImportData> pe=new
		 * ParseExcelComponent<MemberImportData>(file,MemberImportData.class);
		 * pe.setBeanVidator(beanValidator);
		 * pe.setConversionService(conversionService); pe.validateExcel();
		 *
		 * for(String e:pe.getErrorMessages()){ System.out.println(e); }
		 */
//        }

        // //only for test
        // public void setConversionService(ConversionService conversionService) {
        // this.conversionService = conversionService;
        // }
        //
        // //only for test
        // public void setBeanVidator(Validator beanVidator) {
        // this.beanVidator = beanVidator;
        // }
    }

}
