package com.thebeastshop.pegasus.util.enums;

/**
 * 订单包裹报关高捷，海关，支付宝状态
 * Created by huan.xiong on 2016/12/13.
 */
public enum PackageDeclarationStateEnum implements EnumPackageMessage{

    /*仓库状态*/
    NOT_SEND_WARAHOUSE(1, "未下发仓库", 1),
    SEND_WARAHOUSE(2, "已下发仓库", 1),
    NOT_OUT_WARAHOUSE(3, "未出库", 1),
    IDENTITY_REPREAT(4, "身份证重复", 1),
    FINISH_WARAHOUSE_OPRATION(5, "仓库完成操作", 1),
    /*订单状态*/
    PUSH_GAOJIE_FAIL(-1, "推送失败", 2),
    PUSH_GAOJIE_SUCCESS(2, "推送成功", 2),
    ORDER_NOT_CONFIRM(6, "订单未确认", 2),
    ORDER_CANCEL(7, "订单已取消", 2),
    WAITING_DECLEAR(10, "订单待报关", 2),
    CUSTOM_PENDING(1, "报关审核中", 2),
    CLEAR_PASS(11, "清单通过", 2),
    CLEAR_NOT_PASS(12, "清单不通过", 2),
    DECLARATION_PASS(21, "报关通过", 2),
    /*支付宝报关状态,小于0表示处理异常回执*/
    QUERY_ALIPAY_FAIL(-2, "支付宝报关失败", 3),
    PUSH_ALIPAY_FAIL(-1, "推送失败", 3),
    PUSH_ALIPAY_SUCCESS(1, "推送成功", 3),
    ALIPAY_IN_DECLARATION(2, "电子口岸申报中", 3),
    ALIPAY_SEND_CUSTIOM_SUCCESS(3, "发送海关成功", 3),
    ALIPAY_SEND_CUSTOM_FAIL(4, "发送海关失败", 3),
    ALIPA_CUSTOM_CHARGEBACK(100, "海关退单", 3),
    ALIPAY_CUSTOM_CONCLUDE(120, "海关入库", 3),
    /*订单海关报关状态,小于0表示处理异常回执*/
    CUSTOM_RECEIPT_FAIL(-2, "回执异常", 4),
    PUSH_CUSTOM_FAIL(-1, "推送失败", 4),
    PUSH_CUSTOM_SUCCESS(1, "推送成功", 4),
    IN_DECLARATION(2, "订单新增申报成功", 4),
    SEND_CUSTOM_SUCCESS(3, "发送海关成功", 4),
    SEND_CUSTOM_FAIL(4, "发送海关失败", 4),
    CUSTOM_CHARGEBACK(100, "海关退单", 4),
    CUSTOM_IN_STORAGE(120, "海关入库", 4);

    private int index;

    private String name;

    private int type;

    PackageDeclarationStateEnum(int index, String name, int type) {
        this.index = index;
        this.name = name;
        this.type = type;
    }

    public int getIndex() {
        return index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getKey() {
        return index + "-" + type;
    }
}
