/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.util.cond;

import java.io.Serializable;

/**
 * @author Roy.Chen
 * @version $Id: BaseQueryCond.java, v 0.1 2015-07-28 12:15
 */
public class BaseQueryCond implements Serializable {

    /**
     *第几页
     */
    private Integer currpage;
    /**
     *每页的数量
     */
    private Integer pagenum = 20;

    public Integer getCurrpage() {
        return currpage;
    }

    public void setCurrpage(Integer currpage) {
        this.currpage = currpage;
    }

    public Integer getPagenum() {
        return pagenum;
    }

    public void setPagenum(Integer pagenum) {
        this.pagenum = pagenum;
    }

    /**
     * 获取分页 Limit后的 str
     * @return
     */
    public String getCriteriaStr() {
        if (currpage == null) {
            return "";
        }
        Integer pagestart = getPageStart();

        return new StringBuilder(" LIMIT ").append(pagestart).append(",").append(pagenum).append("  ").toString();
    }

    public int getPageStart() {
        return (currpage > 0 ? (currpage - 1) * pagenum : 0);
    }

}
