
package com.thebeastshop.pegasus.util.comm;

import org.apache.commons.codec.Charsets;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.formula.functions.T;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;


/**
 * @author Roy.Chen
 * @version $Id: XMLUtil.java, v 0.1 2015-12-29 14:26
 */
public class XMLUtil {

    public static final Logger log = LoggerFactory.getLogger(XMLUtil.class);

    /**
     * @param express xpath express
     * @param xml
     * @return
     * @throws XPathExpressionException
     */
    public static String parseString(String express, String xml) throws XPathExpressionException {
        if (StringUtils.isNotBlank(xml)) {
            XPath xPath = getXPath();
            return (String) xPath.evaluate(express, new InputSource(new ByteArrayInputStream(xml.getBytes(Charsets.UTF_8))), XPathConstants.STRING);
        }
        return null;
    }

    /**
     * @param express xpath express
     * @param xml
     * @return
     * @throws XPathExpressionException
     */
    public static NodeList parseNodeList(String express, String xml) throws XPathExpressionException {
        if (StringUtils.isNotBlank(xml)) {
            XPath xPath = getXPath();
            return (NodeList) xPath.evaluate(express, new InputSource(new ByteArrayInputStream(xml.getBytes(Charsets.UTF_8))), XPathConstants.NODESET);
        }
        return null;
    }

    public static XPath getXPath() {
        return XPathFactory.newInstance().newXPath();
    }

    public static <T> List<T> getObjecList(String filePath, Class<T> clazz, String childNote) throws Exception{
        Document doc = null;
        List<T> list = new ArrayList<>();
        try {
            SAXReader reader = new SAXReader(); //User.hbm.xml表示你要解析的xml文档
            doc = reader.read(new File(filePath));
            Element rootElt = doc.getRootElement(); // 获取根节点
            log.info("root node:{}", rootElt.getName());
            Iterator<Element> it = rootElt.elementIterator(childNote);// 获取根节点下所有对应名称子节点
            while (it.hasNext()) {
                Element elementGroupService = (Element) it.next();
                T baseBean = (T) XMLUtil.fromXmlToBean(
                        elementGroupService, clazz);
                list.add(baseBean);
            }
        } catch (DocumentException e) {
            log.error("read document exception! {}", e);
        }
        return list;
    }

    public static Object fromXmlToBean(Element rootElt, Class clazz) throws Exception{
        Field[] fields = clazz.getDeclaredFields();
        Object obj = clazz.newInstance();
        try {
            for (Field field : fields) {
                // 设置字段可访问（必须，否则报错）
                field.setAccessible(true);
                // 得到字段的属性名
                String name = field.getName();
                // 这一段的作用是如果字段在Element中不存在会抛出异常，如果出异常，则跳过。
                rootElt.elementTextTrim(name);
                if (rootElt.elementTextTrim(name) != null && !"".equals(rootElt.elementTextTrim(name))) {
                    // 根据字段的类型将值转化为相应的类型，并设置到生成的对象中。
                    if (field.getType().equals(Long.class) || field.getType().equals(long.class)) {
                        field.set(obj, Long.parseLong(rootElt.elementTextTrim(name)));
                    } else if (field.getType().equals(String.class)) {
                        field.set(obj, rootElt.elementTextTrim(name));
                    } else if (field.getType().equals(Double.class) || field.getType().equals(double.class)) {
                        field.set(obj, Double.parseDouble(rootElt.elementTextTrim(name)));
                    } else if (field.getType().equals(Integer.class) || field.getType().equals(int.class)) {
                        field.set(obj, Integer.parseInt(rootElt.elementTextTrim(name)));
                    } else if (field.getType().equals(java.util.Date.class)) {
                        field.set(obj, Date.parse(rootElt.elementTextTrim(name)));
                    } else {
                        continue;
                    }
                }
            }
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return obj;
    }

}
