package com.thebeastshop.pegasus.util.comm;

import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.validator.routines.EmailValidator;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/***
 * 验证辅助类
 * 
 * @author fs
 *
 */
public class ValidationUtil {

	private static final String MAIL_REG = "^([a-z0-9A-Z]+[-|_|\\.]?)+[a-z0-9A-Z]+[-|_|\\.]?@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$";
	private static final String MOBILE_REG = "1([\\d]{10})|((\\+[0-9]{2,4})?\\(?[0-9]+\\)?-?)?[0-9]{7,8}";

	/***
	 * 判断是否是合法的email
	 * 
	 * @param mail
	 * @return
	 */
	public static Boolean isEmail(String mail) {
		return EmailValidator.getInstance().isValid(mail);
	}

	/***
	 * 判断是否是合法的手机号码
	 * 
	 * @param mobile
	 * @return
	 */
	public static Boolean isMobile(String mobile) {
		Pattern regex = Pattern.compile(MOBILE_REG);
		Matcher matcher = regex.matcher(mobile);
		return matcher.matches();
	}

}
