package com.thebeastshop.pegasus.util.comm;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class PriceUtil {

	private static final double VIP_DISCOUNT=0.95;//VIP折扣
	private static final double VVIP_DISCOUNT=0.9;//vvip 折扣
	/**
	 * 根据等级取得相应的折扣
	 * @param price
	 * @param leavl
	 * @return BigDecimal
	 */
	public static BigDecimal getLevelPrice(BigDecimal price, int leavl) {

		BigDecimal discountPrice=price;
		if (discountPrice == null) {

			return new BigDecimal(0);
		}

		// vip
		if (leavl == 1) {
			discountPrice= price.multiply(new BigDecimal(0.95));
			// vvip
		} else if (leavl == 2 || leavl==3) {
	
			discountPrice= price.multiply(new BigDecimal(0.9));
		}
		discountPrice=discountPrice.setScale(2, RoundingMode.HALF_UP);
		return discountPrice;
	}
	
	/**
	 * 取得相应的折扣(天猫，京东渠道)
	 * @param price
	 * @param leavl
	 * @return BigDecimal
	 */
	public static BigDecimal getDiscountPrice(BigDecimal price, float discount) {

		BigDecimal discountPrice=price;
		if (discountPrice == null) {
			return new BigDecimal(0);
		}
		// vip
		discountPrice= price.multiply(new BigDecimal(discount));
		discountPrice=discountPrice.setScale(2, RoundingMode.HALF_UP);
		return discountPrice;
	}
	
	
	public static Double getVipPrice(Double price){
		return price*VIP_DISCOUNT;
	}
	public static Double getVvipPrice(Double price){
		return price*VVIP_DISCOUNT;
	}
}
