package com.thebeastshop.pegasus.util.comm;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

import javax.imageio.ImageIO;

import org.apache.commons.lang.StringUtils;

public class ImageUtil {

	/**
	 * jim.huang
	 * @param args
	 */
	public static void main(String[] args) {
		String imageUrl = "http://avatar.csdn.net/9/F/2/1_5iasp.jpg";
		BufferedImage image = getBufferedImage(imageUrl);
		if (image != null) {
			System.out.println("图片高度:" + image.getHeight());
			System.out.println("图片宽度:" + image.getWidth());
		} else {
			System.out.println("图片不存在！");
		}
	}

	/**
	 * 通过图片链接获取
	 * 
	 * @param imgUrl
	 *            图片地址
	 * @return
	 */
	public static BufferedImage getBufferedImage(String imgUrl) {
		URL url = null;
		InputStream is = null;
		BufferedImage img = null;
		try {
			url = new URL(imgUrl);
			is = url.openStream();
			img = ImageIO.read(is);
		} catch (MalformedURLException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} finally {

			try {
				is.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		return img;
	}

	/**
	 * 文件
	 * 
	 * @param imgUrl
	 * @return
	 */
	public static BufferedImage getBufferedImageByLocal(File file) {
		InputStream is = null;
		BufferedImage img = null;
		try {

			is = new FileInputStream(file);
			img = ImageIO.read(is);
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			try {
				is.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		return img;
	}

	public static BufferedImage getBufferedImageByLocal(String imgUrl) {
		if (StringUtils.isBlank(imgUrl)) {
			throw new NullPointerException("图片路径不能为空！");
		}
		File file = new File(imgUrl);
		return getBufferedImageByLocal(file);
	}

}