/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.util.vo;

import com.thebeastshop.pegasus.util.comm.EmptyUtil;

import java.io.InputStream;
import java.io.Serializable;

/**
 * @author Eric.Lou
 * @version $Id: FileRequest.java, v 0.1 2015-07-29 08:02
 */
public class FileRequestVO implements Serializable {

    /**
     * 输入流
     */
    private InputStream inputStream;

    /**
     * 文件原始名称
     */
    private String originalFilename;

    //子目录
    private String subdirectory;

    //OSS文件key
    private String ossKey;

    //constructor
    public FileRequestVO(InputStream inputStream, String originalFilename) {
        this.inputStream = inputStream;
        this.originalFilename = originalFilename;
    }

    private FileRequestVO() {

    }

    //method

    /**
     * 获取文件输入流
     *
     * @return
     */
    public InputStream getInputStream() {
        return inputStream;
    }

    /**
     * 获取文件原始名称
     *
     * @return
     */
    public String getOriginalFilename() {
        return originalFilename;
    }

    /**
     * 获取文件扩展名称,如doc,xls,jpg,gif,rar等
     *
     * @return
     */
    public String getExtName() {
        if (EmptyUtil.isNotEmpty(originalFilename)) {
            return originalFilename.substring(originalFilename.lastIndexOf(".") + 1);
        }
        return null;
    }

    /**
     * 获取文件名称，不包含后缀
     *
     * @return
     */
    public String getFileName() {
        if (EmptyUtil.isNotEmpty(originalFilename)) {
            return originalFilename.substring(0, originalFilename.lastIndexOf("."));
        }
        return null;
    }

    public String getSubdirectory() {
        return subdirectory;
    }

    public void setSubdirectory(String subdirectory) {
        this.subdirectory = subdirectory;
    }

    public String getOssKey() {
        return ossKey;
    }

    public void setOssKey(String ossKey) {
        this.ossKey = ossKey;
    }
}
