package com.thebeastshop.pegasus.util.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.taobao.api.ApiException;
import com.taobao.api.response.ItemQuantityUpdateResponse;
import com.taobao.api.response.ItemSkuGetResponse;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.tmall.dto.NextoneLogisticsWarehouseUpdateResponseDTO;
import com.thebeastshop.tmall.dto.TmallItemQuantitySyncDTO;
import com.thebeastshop.tmall.dto.TmallShipDTO;
import com.thebeastshop.tmall.dto.TmallTbRefundDTO;
import com.thebeastshop.tmall.dto.TmallTbRefundQueryDTO;
import com.thebeastshop.tmall.dto.TmallTbTradeDTO;
import org.apache.http.HttpException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import com.thebeastshop.pegasus.util.service.CommTmallService;
import org.springframework.web.client.RestTemplate;

import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

@Service("commTmallService")
public class CommTmallServiceImpl implements CommTmallService {

	private final static Logger log = LoggerFactory.getLogger(CommTmallService.class);

	@Value("${tmall.jushita.url}")
	private String tmallJushitaUrl;

	@Autowired
	private RestTemplate restTemplate;


	@Override
	public Long getSkuNumIid(String outerId, String sessionKey) throws Exception {
		ResponseEntity<Long> responseEntity = restTemplate.getForEntity(tmallJushitaUrl + "/items/item/{channelCode}/{skuCode}", Long.class, sessionKey, outerId);
		return  responseEntity.getBody();
	}
	

	@Override
	public int getSkuQuantity(String outerId, String channelCode, Long numIid) throws Exception {
		ResponseEntity<Integer> responseEntity = restTemplate.getForEntity(tmallJushitaUrl + "/items/{channelCode}/{numIid}/{skuCode}", Integer.class,
																																			 channelCode, numIid, outerId);
		return  responseEntity.getBody();
	}


	@Override
	public int getPromotionUmp(String channelCode, Long numIid) throws Exception {
		ResponseEntity<Integer> responseEntity = restTemplate.getForEntity(tmallJushitaUrl + "/items/promotion/{channelCode}/{skuCode}", Integer.class,
																																			 channelCode, numIid);
		return  responseEntity.getBody();
	}

	@Override
	public ItemSkuGetResponse taoBaoItemSkuGet(String channelCode, Long skuId, Long numIid, String nick) throws Exception {
		ResponseEntity<ItemSkuGetResponse> responseEntity = restTemplate.getForEntity(tmallJushitaUrl + "/items/{channelCode}/{skuId}/{numIid}/{nick}", ItemSkuGetResponse.class,
				channelCode,skuId, numIid,nick);
		return  responseEntity.getBody();
	}


	/**
	 * 同步天猫发货
	 * @param tid 天猫订单号
	 * @param companyCode 物流公司编号（跟天猫后台对应）
	 * @param deliveryCode 快递单号
	 * @return 天猫后台返回信息
	 */
	@Override
	public String synchronizeTmallShip(Long tid, String companyCode, String deliveryCode) throws ApiException {
		TmallShipDTO tmallShipDTO = new TmallShipDTO();
		tmallShipDTO.setTid(tid);
		tmallShipDTO.setCompanyCode(companyCode);
		tmallShipDTO.setDeliveryCode(deliveryCode);
		ResponseEntity<String> responseEntity = restTemplate.postForEntity(tmallJushitaUrl + "/trades/synchronizeShip", tmallShipDTO, String.class);
		return  responseEntity.getBody();
	}

	@Override
	public ItemQuantityUpdateResponse synCommodityStocks(String channelCode, Long numIid, String outerId, long quantity) throws Exception {
		TmallItemQuantitySyncDTO tmallItemQuantitySyncDTO = new TmallItemQuantitySyncDTO();
		tmallItemQuantitySyncDTO.setNumIid(numIid);
		tmallItemQuantitySyncDTO.setOuterId(outerId);
		tmallItemQuantitySyncDTO.setQuantity(quantity);
		tmallItemQuantitySyncDTO.setChannelCode(channelCode);
		ResponseEntity<ItemQuantityUpdateResponse> responseEntity = restTemplate.postForEntity(tmallJushitaUrl + "/items/synCommodityStocks", tmallItemQuantitySyncDTO, ItemQuantityUpdateResponse.class);
		return  responseEntity.getBody();
	}

	@Override
	public Date getTmallOrderPayTimeByTid(Long tid) {
		TmallTbTradeDTO tmallTbTradeDTO = getTmallOrderByTid(tid);
		if (EmptyUtil.isEmpty(tmallTbTradeDTO)) {
			return  null;
		}
		JSONObject tradeFullinfo = JSON.parseObject(tmallTbTradeDTO.getJdpResponse()).getJSONObject("trade_fullinfo_get_response").getJSONObject("trade");
		return  tradeFullinfo.getDate("pay_time");
	}

	@Override
	public TmallTbTradeDTO getTmallOrderByTid(Long tid) {
		ResponseEntity<TmallTbTradeDTO> responseEntity = restTemplate.getForEntity(tmallJushitaUrl + "/trades/{tid}", TmallTbTradeDTO.class, tid);
		return  responseEntity.getBody();
	}

	@Override
	public List<TmallTbRefundDTO> getTmallRefunds(Date startDate, Date endDate) throws HttpException, IOException {
		TmallTbRefundQueryDTO tmallTbRefundQueryDTO = new TmallTbRefundQueryDTO();
		tmallTbRefundQueryDTO.setModifiedStart(startDate);
		tmallTbRefundQueryDTO.setModifiedEnd(endDate);
		ResponseEntity<TmallTbRefundDTO[]> responseEntity = restTemplate.postForEntity(tmallJushitaUrl + "/refunds", tmallTbRefundQueryDTO, TmallTbRefundDTO[].class);
		TmallTbRefundDTO[] tmallTbRefundArray = responseEntity.getBody();
		if (EmptyUtil.isEmpty(tmallTbRefundArray)) {
			return  null;
		}

		return Arrays.asList(tmallTbRefundArray);
	}


	@Override
	public NextoneLogisticsWarehouseUpdateResponseDTO tmallAgWarehouseUpdate(Long refundId,String channelCode) throws ApiException {
		ResponseEntity<NextoneLogisticsWarehouseUpdateResponseDTO> responseEntity = restTemplate.getForEntity(tmallJushitaUrl + "/refunds/tmallAgWarehouseUpdate/{refundId}/{channelCode}", NextoneLogisticsWarehouseUpdateResponseDTO.class, refundId,channelCode);
		return responseEntity.getBody();
	}
}
