/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.util.service.impl;

import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.dao.CommGlobalConfigMapper;
import com.thebeastshop.pegasus.util.model.CommGlobalConfig;
import com.thebeastshop.pegasus.util.model.CommGlobalConfigExample;
import com.thebeastshop.pegasus.util.service.CommGlobalConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author Royan
 * @version $Id: CommGlobalConfigServiceImpl.java, v 0.1 2015-08-17 下午4:17
 */
@Service("commGlobalConfigService")
public class CommGlobalConfigServiceImpl implements CommGlobalConfigService {

    private final Logger           log = LoggerFactory.getLogger(CommGlobalConfigServiceImpl.class);

    @Autowired
    private CommGlobalConfigMapper commGlobalConfigMapper;

    /**
     * 根据key查找配置
     *
     * @param key
     * @return
     */
    @Override
    public CommGlobalConfig findConfigByKey(String key) {
        CommGlobalConfigExample example = new CommGlobalConfigExample();
        example.createCriteria().andConfigKeyEqualTo(key);
        List<CommGlobalConfig> result = commGlobalConfigMapper.selectByExample(example);
        return EmptyUtil.isNotEmpty(result) ? result.get(0) : null;
    }

    @Override
    public String findByConfigKey(String configKey) {
        if (EmptyUtil.isEmpty(configKey)) return null;
        String config = commGlobalConfigMapper.findByConfigKey(configKey);
        return EmptyUtil.isNotEmpty(config) ? config : null;
    }
}