package com.thebeastshop.pegasus.util.service;

import com.taobao.api.ApiException;
import com.taobao.api.response.ItemQuantityUpdateResponse;
import com.taobao.api.response.ItemSkuGetResponse;
import com.thebeastshop.tmall.dto.NextoneLogisticsWarehouseUpdateResponseDTO;
import com.thebeastshop.tmall.dto.TmallTbRefundDTO;
import com.thebeastshop.tmall.dto.TmallTbTradeDTO;
import org.apache.http.HttpException;

import java.io.IOException;
import java.util.Date;
import java.util.List;

public interface CommTmallService {
	
	/**
	 * 获取天猫的商品ID
	 * @param outerId
	 * @return
	 */
	Long getSkuNumIid(String outerId, String sessionKey) throws Exception;
	/**
	 * 获取天猫的SKU库存 
	 * @param outerId
	 * @return
	 */
	int getSkuQuantity(String outerId, String sessionKey, Long numIid) throws Exception;
	
	/**
	 * 获取商品活动详情
	 */
	int getPromotionUmp(String sessionKey, Long numIid) throws Exception;


	ItemSkuGetResponse taoBaoItemSkuGet(String channelCode, Long skuId, Long numIid, String nick) throws Exception;


	String synchronizeTmallShip(Long tid, String companyCode, String deliveryCode) throws ApiException;

	ItemQuantityUpdateResponse synCommodityStocks(String channelCode, Long numIid, String outerId, long quantity) throws Exception;

	Date getTmallOrderPayTimeByTid(Long tid);

	TmallTbTradeDTO getTmallOrderByTid(Long tid);

	List<TmallTbRefundDTO> getTmallRefunds(Date startDate, Date endDate) throws HttpException, IOException;
	
	NextoneLogisticsWarehouseUpdateResponseDTO tmallAgWarehouseUpdate(Long refundId,String channelCode) throws ApiException;

}
