package com.thebeastshop.pegasus.util.service;

import com.thebeastshop.pegasus.util.model.CommEntityOpRcd;

import java.util.List;

/**
 * @author Eric.Lou
 * @version $Id: CommEntityOperationRcdService.java, v 0.1 2015-10-12 15:32
 */
public interface CommEntityOperationRcdService {

    /**
     * 保存操作记录
     *
     * @param commEntityOpRcd 记录
     * @return 记录ID
     * */
    Long insertRcd(CommEntityOpRcd commEntityOpRcd);

    /**
     * 根据类型和ID查找实体变更操作记录
     * @param entityName
     * @param entityId
     * @return
     */
    List<CommEntityOpRcd> findEntityOpRcdByClazzAndId(String entityName,String entityId);
    
    /**
     * 根据类型,操作类型和ID查找实体变更操作记录
     * @param entityName
     * @param entityId
     * @return
     */
    List<CommEntityOpRcd> findEntityOpRcdByClazzAndId(Integer operationType, String entityName,String entityId);

}
