package com.thebeastshop.pegasus.util.route;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.aop.AfterReturningAdvice;
import org.springframework.aop.MethodBeforeAdvice;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by roy on 15-12-16.
 */
public class ScmDataSourceRouteIntercepter implements MethodBeforeAdvice, AfterReturningAdvice {
    private List<String> readMethodPrefix;

    private boolean _is_can_route = false;

    private static final String _PATTERN_APPEND = ".*";

    /**
     * Callback before a given method is invoked.
     *
     * @param method method being invoked
     * @param args   arguments to the method
     * @param target target of the method invocation. May be {@code null}.
     * @throws Throwable if this object wishes to abort the call.
     *                   Any exception thrown will be returned to the caller if it's
     *                   allowed by the method signature. Otherwise the exception
     *                   will be wrapped as a runtime exception.
     */
    @Override
    public void before(Method method, Object[] args, Object target) throws Throwable {
        if (_is_can_route) {
            String methodName = method.getName();
            for (String patternMethodPath : readMethodPrefix) {
                Pattern pattern = Pattern.compile(patternMethodPath);
                Matcher m = pattern.matcher(methodName);
                if (m.matches()) {
                    DBTypeHolder.setDBType(DBType.SLAVE);
                    return;
                }
            }
        }
    }

    public void setReadMethodPrefix(List<String> methodPrefixes) {
        if (CollectionUtils.isNotEmpty(methodPrefixes)) {
            this.readMethodPrefix = new ArrayList<>();
            for (String prefix : methodPrefixes) {
                readMethodPrefix.add(new StringBuilder(prefix).append(_PATTERN_APPEND).toString());
            }
            _is_can_route = true;
        }
    }

    /**
     * Callback after a given method successfully returned.
     *
     * @param returnValue the value returned by the method, if any
     * @param method      method being invoked
     * @param args        arguments to the method
     * @param target      target of the method invocation. May be {@code null}.
     * @throws Throwable if this object wishes to abort the call.
     *                   Any exception thrown will be returned to the caller if it's
     *                   allowed by the method signature. Otherwise the exception
     *                   will be wrapped as a runtime exception.
     */
    @Override
    public void afterReturning(Object returnValue, Method method, Object[] args, Object target) throws Throwable {
        DBTypeHolder.clearDBType();
    }
}
