/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.util.comm;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * @author Roy.Chen
 * @version $Id: NumberUtil.java, v 0.1 2015-07-27 11:43
 */
public class NumberUtil {

    /**
     * 判断是否为空，或者0
     * @param number
     * @return
     */
    public static boolean isNullOrZero(Number number) {
        return number == null || number.intValue() == 0;
    }

    public static Number avoidNull(Number number) {
        return NumberUtil.avoidNull(number, 0);
    }
    public static Number avoidNull(Number number, Number defVal) {
        return number == null? defVal : number;
    }

    public static List<Long> convertListFromString(List<String> codes) {
        if(CollectionUtils.isEmpty(codes)) return Collections.emptyList();
        List<Long> ids = new ArrayList<>(codes.size());
        for (String code : codes) {
            try {
                ids.add(Long.valueOf(code));
            } catch (Exception ex) {
            }
        }
        return ids;
    }

    public static List<String> convertStringFromNumber(List<Long> idList) {
        if(CollectionUtils.isEmpty(idList)) return Collections.emptyList();
        List<String> strList = new ArrayList<>(idList.size());
        for (Long id : idList) {
            strList.add(String.valueOf(id));
        }
        return strList;
    }

}
