package com.thebeastshop.pegasus.util.comm;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;

import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

/**
 * 下载文件
 * @author donghui
 */
public class FileDownLoadBuilder {
	private static final Logger log = LoggerFactory.getLogger(FileDownLoadBuilder.class);

	/**
     * 下载文件名
     */
    private String name = null; 
    
    /**
     * 文件字节流
     */
    private byte[] bytes = null;
    
    /**
     * 类型
     */
    private MediaType mediaType = MediaType.APPLICATION_OCTET_STREAM;
    
    /**
     * 设置文件名
     */
    public FileDownLoadBuilder name(String name){
    	this.name = name;
    	return this;
    }
    
    /**
     * 文件流类型
     */
    public FileDownLoadBuilder type(MediaType mediaType){
    	try {
    		this.mediaType = mediaType;
    	} catch (Exception e) {
			log.error(null , e);
    	}
    	return this;
    }
    
    public FileDownLoadBuilder file(byte[] bytes){
   		this.bytes = bytes;
    	return this;
    }
    
    public FileDownLoadBuilder file(InputStream inputStream){
    	try {
    		this.bytes = IOUtils.toByteArray(inputStream);
    	} catch (Exception e) {
    		log.error(null , e);
    	}
    	return this;
    }
    
    public FileDownLoadBuilder file(File file){
    	this.name = StringUtils.defaultIfBlank(this.name, file.getName());
    	try {
    		this.bytes = FileUtils.readFileToByteArray(file);
    	} catch (Exception e) {
    		log.error(null , e);
    	}
    	return this;
    }
    
    public FileDownLoadBuilder file(String path){
    	ClassPathResource classPathResource = new ClassPathResource(path);
    	this.name = StringUtils.defaultIfBlank(this.name, classPathResource.getFilename());
    	InputStream is = null;
		try {
			is = classPathResource.getInputStream();
		} catch (IOException e) {
			log.error(null , e);
		}
    	return this.file(is);
    }

    /**
     * 执行导出
     */
    public ResponseEntity<byte[]> builder() {
		try {
			this.name = new String((name).getBytes("UTF-8"), "ISO-8859-1");
		} catch (Exception e) {
			log.error(null , e);
		}
		HttpHeaders headers = new HttpHeaders();
		headers.setContentType(this.mediaType);
        headers.setContentDispositionFormData("attachment", this.name);
        return new ResponseEntity<byte[]>(this.bytes, headers, HttpStatus.OK);
    }

}