/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.util.comm;

import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Transparency;
import java.awt.image.BufferedImage;
import java.io.*;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.zip.ZipOutputStream;

import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

import com.thebeastshop.pegasus.util.enums.ExcelCellTypeEnum;
import com.thebeastshop.pegasus.util.exception.UtilException;
import com.thebeastshop.pegasus.util.exception.UtilExceptionErrorCode;
import com.thebeastshop.pegasus.util.importExcel.XSSFDateUtil;
import org.apache.poi.hssf.usermodel.*;
import org.apache.poi.ss.usermodel.*;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.usermodel.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

/**
 * @author Royan
 * @version $Id: ExcelUtil.java, v 0.1 2015-09-11 下午5:01
 */
public class ExcelUtil {

    private final static Logger log = LoggerFactory.getLogger(ExcelUtil.class);

    /**
     * 写excel
     *
     * @param sheetName sheet名
     * @param allLines 内容
     * @param oldVersion 是否老版本（2013含2013[xls]为老版本，之后[xlsx]为新版本）
     * @return
     */
    public static byte[] write(String sheetName, List<List<String>> allLines, boolean oldVersion) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();

        Workbook wb = oldVersion ? new HSSFWorkbook() : new XSSFWorkbook();
        Sheet sheet = wb.createSheet(sheetName);
        Row row = sheet.createRow(0);
        CellStyle style = wb.createCellStyle();
        style.setAlignment(HSSFCellStyle.ALIGN_RIGHT);
        style.setWrapText(true);

        for (int i = 0; i < allLines.size(); i++) {
            row = sheet.createRow(i);
            List<String> line = allLines.get(i);

            for (int j = 0; j < line.size(); j++) {
                Cell cell = row.createCell(j);
                cell.setCellType(HSSFCell.CELL_TYPE_STRING);
                cell.setCellValue(line.get(j));
            }
        }

        try {
            wb.write(os);
            os.flush();
            os.close();
        } catch (IOException e) {
            log.warn("", e);
            throw new RuntimeException("Write Excel File Error");
        }

        return os.toByteArray();
    }


    /**
     * 写excel
     *
     * @param sheetName sheet名
     * @param allLines 内容
     * @param oldVersion 是否老版本（2013含2013[xls]为老版本，之后[xlsx]为新版本）
     * @return
     */
    public ByteArrayOutputStream writeToZip(String sheetName, List<List<String>> allLines, boolean oldVersion) {

        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Workbook wb = oldVersion ? new HSSFWorkbook() : new XSSFWorkbook();
        Sheet sheet = wb.createSheet(sheetName);
        Row row = sheet.createRow(0);
        CellStyle style = wb.createCellStyle();
        style.setAlignment(HSSFCellStyle.ALIGN_RIGHT);
        style.setWrapText(true);

        for (int i = 0; i < allLines.size(); i++) {
            row = sheet.createRow(i);
            List<String> line = allLines.get(i);

            for (int j = 0; j < line.size(); j++) {
                Cell cell = row.createCell(j);
                cell.setCellType(HSSFCell.CELL_TYPE_STRING);
                cell.setCellValue(line.get(j));
            }
        }

        try {
            wb.write(os);
            os.flush();
        } catch (IOException e) {
            log.warn("", e);
            throw new RuntimeException("Write Excel File Error");
        }

        return os;
        //return zipOutputStream.toByteArray();
    }
    /**
     * 写excel(包含图片)
     * 
     * @param sheetName sheet名
     * @param allLines 内容
     * @param oldVersion 是否老版本（2013含2013[xls]为老版本，之后[xlsx]为新版本）
     * @return
     * @throws Exception 
     */
    public static byte[] writeImgExcel(String sheetName, List<List<String>> allLines, boolean oldVersion) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        
        HSSFWorkbook wb = new HSSFWorkbook();
        
        HSSFSheet sheet = wb.createSheet(sheetName);
        
        //画图的顶级管理器，一个sheet只能获取一个（一定要注意这点）
        HSSFPatriarch patriarch = sheet.createDrawingPatriarch();
        
        Row row = sheet.createRow(0);
        HSSFCellStyle style = wb.createCellStyle();
        style.setAlignment(HSSFCellStyle.ALIGN_CENTER);// 创建一个居中格式
        style.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
        style.setWrapText(true);

        for (int i = 0; i < allLines.size(); i++) {
            row = sheet.createRow(i);
            List<String> line = allLines.get(i);
            if(i >= 1){
            	row.setHeight((short) 1500);
            	for (int j = 0; j < line.size(); j++) {
            		if(j == 2 || j == 3 || j == 6){
            			sheet.setColumnWidth(j, 6000);
            		}else if(j == 5){
            			sheet.setColumnWidth(j, 4500);
            		}else{
            			sheet.setColumnWidth(j, 3000);
            		}
            		if(j == 9){//图片
            			try {
            				if(line.get(j) != ""){
            					BufferedImage bufferImg = null;
            			        ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
            					URL url = new URL(line.get(j));
            					Image src = Toolkit.getDefaultToolkit().getImage(url);
            					bufferImg = toBufferedImage(src);//Image to BufferedImage
                				ImageIO.write(bufferImg, "jpg", byteArrayOut);
                		        HSSFClientAnchor anchor = new HSSFClientAnchor(0, 0, 0, 0,(short) 9, i, (short) 10, i+1);//anchor主要用于设置图片的属性
                		        anchor.setAnchorType(3);
                		        patriarch.createPicture(anchor, wb.addPicture(byteArrayOut.toByteArray(), HSSFWorkbook.PICTURE_TYPE_JPEG));//插入图片
            				}else{
            					Cell cell = row.createCell(j);
                                cell.setCellType(HSSFCell.CELL_TYPE_STRING);
                                cell.setCellValue(line.get(j));
            				}
            			} catch (IOException e1) {
            				e1.printStackTrace();
            			}
            		}else{
            			Cell cell = row.createCell(j);
                        cell.setCellType(HSSFCell.CELL_TYPE_STRING);
                        cell.setCellValue(line.get(j));
            		}
                    
                }
            }else{
            	for (int j = 0; j < line.size(); j++) {
                    Cell cell = row.createCell(j);
                    cell.setCellType(HSSFCell.CELL_TYPE_STRING);
                    cell.setCellValue(line.get(j));
                }
            }
            
        }

        try {
            wb.write(os);
            os.flush();
            os.close();
        } catch (IOException e) {
            log.warn("", e);
            throw new RuntimeException("Write Excel File Error");
        }

        return os.toByteArray();
    }
    
    public static BufferedImage toBufferedImage(Image image) {
    	if (image instanceof BufferedImage) { 
    		return (BufferedImage) image; 
    	} 
    	// This code ensures that all the pixels in the image are loaded 
    	image = new ImageIcon(image).getImage(); 
    	BufferedImage bimage = null; 
    	GraphicsEnvironment ge = GraphicsEnvironment .getLocalGraphicsEnvironment(); 
    	try { 
	    	int transparency = Transparency.OPAQUE; 
	    	GraphicsDevice gs = ge.getDefaultScreenDevice(); 
	    	GraphicsConfiguration gc = gs.getDefaultConfiguration(); 
	    	bimage = gc.createCompatibleImage(image.getWidth(null),image.getHeight(null), transparency); 
    	} catch (HeadlessException e) { 
    		
    	} 
    	if (bimage == null) { 
	    	// Create a buffered image using the default color model 
	    	int type = BufferedImage.TYPE_INT_RGB; 
	    	bimage = new BufferedImage(image.getWidth(null), 
	    	image.getHeight(null), type); 
    	} 
	    	// Copy image to buffered image 
	    	Graphics g = bimage.createGraphics(); 
	    	// Paint the image onto the buffered image 
	    	g.drawImage(image, 0, 0, null); 
	    	g.dispose(); 
	    	return bimage; 
    }
    
//    public static File filePathName(String ossUrl) throws Exception {
//        //new一个URL对象  
//        URL url = new URL(ossUrl);
//        //打开链接  
//        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
//        //设置请求方式为"GET"  
//        conn.setRequestMethod("GET");
//        //超时响应时间为5秒  
//        conn.setConnectTimeout(5 * 1000);
//        //通过输入流获取图片数据  
//        InputStream inStream = conn.getInputStream();
//        //得到图片的二进制数据，以二进制封装得到数据，具有通用性
//        byte[] data = readInputStream(inStream);
//        //new一个文件对象用来保存图片，默认保存当前工程根目录
//        File imageFile = new File("D:/Image/testImage.jpg");
//        //创建输出流
//        FileOutputStream outStream = new FileOutputStream(imageFile);
//        //写入数据
//        outStream.write(data);
//        //关闭输出流
//        outStream.close();
//        return imageFile;
//    }
//
//    public static byte[] readInputStream(InputStream inStream) throws Exception{  
//        ByteArrayOutputStream outStream = new ByteArrayOutputStream();  
//        //创建一个Buffer字符串  
//        byte[] buffer = new byte[1024];  
//        //每次读取的字符串长度，如果为-1，代表全部读取完毕  
//        int len = 0;  
//        //使用一个输入流从buffer里把数据读取出来  
//        while( (len=inStream.read(buffer)) != -1 ){  
//            //用输出流往buffer里写入数据，中间参数代表从哪个位置开始读，len代表读取的长度  
//            outStream.write(buffer, 0, len);  
//        }  
//        //关闭输入流  
//        inStream.close();  
//        //把outStream里的数据写入内存  
//        return outStream.toByteArray();  
//    }
//    
    /**
     * 写excel
     * @param sheets
     * @param oldVersion
     * @return
     */
    public static byte[] write(Map<String,List<List<String>>> sheets,boolean oldVersion){
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Workbook wb = oldVersion ? new HSSFWorkbook() : new XSSFWorkbook();

        Set<String> sheetNames = sheets.keySet();
        for (String sheetName : sheetNames) {
            List<List<String>> allLines = sheets.get(sheetName);
            Sheet sheet = wb.createSheet(sheetName);
            Row row = sheet.createRow(0);
            CellStyle style = wb.createCellStyle();
            style.setAlignment(HSSFCellStyle.ALIGN_RIGHT);
            style.setWrapText(true);

            for (int i = 0; i < allLines.size(); i++) {
                row = sheet.createRow(i);
                List<String> line = allLines.get(i);

                for (int j = 0; j < line.size(); j++) {
                    Cell cell = row.createCell(j);
                    cell.setCellType(HSSFCell.CELL_TYPE_STRING);
                    cell.setCellValue(line.get(j));
                }
            }
        }

        try {
            wb.write(os);
            os.flush();
            os.close();
        } catch (IOException e) {
            log.warn("", e);
            throw new RuntimeException("Write Excel File Error");
        }

        return os.toByteArray();
    }

    /**
     * 读取excel
     *
     * @param is 输入流
     * @param oldVersion 是否老版本（2013含2013[xls]为老版本，之后[xlsx]为新版本）
     * @return
     */
    public static List<List<String>> read(InputStream is, boolean oldVersion) {
        return read(is, 0, oldVersion);
    }

    /**
     * 读取excel
     *
     * @param is 输入流
     * @param page 第几个sheet
     * @param oldVersion 是否老版本（2013含2013[xls]为老版本，之后[xlsx]为新版本）
     * @return
     */
    public static List<List<String>> read(InputStream is, int page , boolean oldVersion) {
        List<List<String>> allLines = new ArrayList<>();

        Workbook workbook = null;
        Sheet sheet = null;
        Row row = null;
        Cell cell = null;

        try {
            workbook = oldVersion ? new HSSFWorkbook(is) : new XSSFWorkbook(is);
            sheet = workbook.getSheetAt(page);
            int headLength= 0;	// 头信息列长度
            for (int i = 0; i < sheet.getPhysicalNumberOfRows(); i++) {
                row = sheet.getRow(i);
                if (row != null) {
                    List<String> line = new ArrayList<>();
                    if(row.getPhysicalNumberOfCells() > headLength){
                        headLength = row.getPhysicalNumberOfCells();
                    }
                    for (int j = 0; j < headLength; j++) {
                        cell = row.getCell(j);
                        String cellValue = getCellValue(cell);
//                        if (cell != null && HSSFCell.CELL_TYPE_NUMERIC == cell.getCellType() && HSSFDateUtil.isCellDateFormatted(cell)) {
//                            line.add(DateUtil.format(HSSFDateUtil.getJavaDate(cell.getNumericCellValue()),DateUtil.DEFAULT_DATETIME_FORMAT));
//                            continue;
//                        }
//                        String cellValue = (cell != null ? ((HSSFCell.CELL_TYPE_STRING == cell
//                                .getCellType()) ? cell.getStringCellValue() :
//                                	HSSFCell.CELL_TYPE_BLANK == cell.getCellType()? "":(new Double(
//                                cell.getNumericCellValue()).intValue() + "")) : "");
                        line.add(EmptyUtil.isNotEmpty(cellValue) ? cellValue.trim() : "");
                    }
                    allLines.add(line);
                }
            }

        } catch (IOException e) {
            log.warn("", e);
            return null;
        }

        return allLines;
    }

    public static String getCellValue(Cell cell){
        if(NullUtil.isNull(cell)){
            return "";
        }
        if(Cell.CELL_TYPE_FORMULA == cell.getCellType()){
            throw new UtilException(UtilExceptionErrorCode.FILE_COMMONS_ERROR,String.format("%s行%s列存在公式，无法上传",cell.getRowIndex()+1,cell.getColumnIndex()+1));
        }
        String value = null;
        NumberFormat nf = NumberFormat.getInstance();//格式化数字
        switch (cell.getCellType()) {
            case Cell.CELL_TYPE_STRING:
                value = cell.getRichStringCellValue().getString();
                break;
            case Cell.CELL_TYPE_NUMERIC:
                if (XSSFDateUtil.isCellDateFormatted(cell)) {
                    value = DateUtil.format(HSSFDateUtil.getJavaDate(cell.getNumericCellValue()),DateUtil.DEFAULT_DATETIME_FORMAT);
                } else{ // 纯数字
                    value = String.valueOf(Double.valueOf(cell.getNumericCellValue()).longValue());
                }
                break;
            case Cell.CELL_TYPE_FORMULA:
                Workbook wb = cell.getSheet().getWorkbook();
                CreationHelper crateHelper = wb.getCreationHelper();
                FormulaEvaluator evaluator = crateHelper.createFormulaEvaluator();
                value = getCellValue(evaluator.evaluateInCell(cell));
                break;
            case Cell.CELL_TYPE_BOOLEAN:
                value = String.valueOf(cell.getBooleanCellValue());
                break;
            case Cell.CELL_TYPE_BLANK:
                value = "";
                break;
            default:
                break;
        }
        return value;
    }




    public static Map<String, List<List<String>>> readMultipleSheet(InputStream is, int pageNum, boolean oldVersion) {
        Workbook workbook = null;
        Map<String, List<List<String>>> sheetMap = new  HashMap<>();
        try {
            workbook = oldVersion ? new HSSFWorkbook(is) : new XSSFWorkbook(is);
            for (int i = 0; i < pageNum; i ++) {
                sheetMap.put(i + "", readSheet(workbook.getSheetAt(i))) ;
            }

        } catch (IOException e) {
            e.printStackTrace();
        }
        return  sheetMap;
    }

    public static Map<String, List<List<String>>> readMultipleSheet(InputStream is, boolean oldVersion) {
        Workbook workbook = null;
        Map<String, List<List<String>>> sheetMap = new  HashMap<>();
        try {
            workbook = oldVersion ? new HSSFWorkbook(is) : new XSSFWorkbook(is);
            int sheetNumber = workbook.getNumberOfSheets();
            for (int i = 0; i < sheetNumber; i ++) {
                sheetMap.put(workbook.getSheetName(i), readSheet(workbook.getSheetAt(i))) ;
            }

        } catch (IOException e) {
            e.printStackTrace();
        }
        return  sheetMap;
    }

    public static List<List<String>> readSheet(Sheet sheet) {
        List<List<String>> allLines = new ArrayList<>();
        Row row = null;
        Cell cell = null;
        int headLength= 0;	// 头信息列长度
        for (int i = 0; i < sheet.getPhysicalNumberOfRows(); i++) {
            row = sheet.getRow(i);
            if (row != null) {
                List<String> line = new ArrayList<>();
                if(row.getPhysicalNumberOfCells() > headLength){
                    headLength = row.getPhysicalNumberOfCells();
                }
                for (int j = 0; j < headLength; j++) {
                    cell = row.getCell(j);
                    String cellValue = getCellValue(cell);
//                    if (cell != null && HSSFCell.CELL_TYPE_NUMERIC == cell.getCellType() && HSSFDateUtil.isCellDateFormatted(cell)) {
//                        line.add(DateUtil.format(HSSFDateUtil.getJavaDate(cell.getNumericCellValue()),DateUtil.DEFAULT_DATETIME_FORMAT));
//                        continue;
//                    }
//                    String cellValue = (cell != null ? ((HSSFCell.CELL_TYPE_STRING == cell
//                      .getCellType()) ? cell.getStringCellValue() :
//                                                        HSSFCell.CELL_TYPE_BLANK == cell.getCellType()? "":(new BigDecimal(
//                                                          cell.getNumericCellValue()) + "")) : "");
                    line.add(EmptyUtil.isNotEmpty(cellValue) ? cellValue.trim() : "");
                }
                allLines.add(line);
            }
        }
        return  allLines;
    }


    /**
     * 特殊处理ProdSku读取excel
     *
     * @param is 输入流
     * @param page 第几个sheet
     * @param oldVersion 是否老版本（2013含2013[xls]为老版本，之后[xlsx]为新版本）
     * @return
     */
    public static List<List<String>> readProdSku(InputStream is, int page , boolean oldVersion) {
        List<List<String>> allLines = new ArrayList<>();

        Workbook workbook = null;
        Sheet sheet = null;
        Row row = null;
        Cell cell = null;

        try {
            workbook = oldVersion ? new HSSFWorkbook(is) : new XSSFWorkbook(is);
            sheet = workbook.getSheetAt(page);
            for (int i = 0; i < sheet.getPhysicalNumberOfRows(); i++) {
                row = sheet.getRow(i);
                if (row != null) {
                    List<String> line = new ArrayList<>();

                    for (int j = 0; j < 2; j++) {
                        cell = row.getCell(j);
                        String cellValue = ExcelUtil.getCellValue(cell);
//                        if (cell != null && HSSFCell.CELL_TYPE_NUMERIC == cell.getCellType() && HSSFDateUtil.isCellDateFormatted(cell)) {
//                            line.add(DateUtil.format(HSSFDateUtil.getJavaDate(cell.getNumericCellValue()),DateUtil.DEFAULT_DATETIME_FORMAT));
//                            continue;
//                        }
//                        String cellValue = (cell != null ? ((HSSFCell.CELL_TYPE_STRING == cell
//                                .getCellType()) ? cell.getStringCellValue() : (new Double(
//                                cell.getNumericCellValue()).intValue() + "")) : "");
                        line.add(EmptyUtil.isNotEmpty(cellValue) ? cellValue.trim() : "");
                    }
                    allLines.add(line);
                }
            }

        } catch (IOException e) {
            log.warn("", e);
            return null;
        }

        return allLines;
    }

    
    /**
     * 读取excel,保留小数
     *
     * @param is 输入流
     * @param page 第几个sheet
     * @param oldVersion 是否老版本（2013含2013[xls]为老版本，之后[xlsx]为新版本）
     * @return
     */
    public static List<List<String>> readNormal(InputStream is, int page , boolean oldVersion) {
        List<List<String>> allLines = new ArrayList<>();

        Workbook workbook = null;
        Sheet sheet = null;
        Row row = null;
        Cell cell = null;

        try {
            workbook = oldVersion ? new HSSFWorkbook(is) : new XSSFWorkbook(is);
            sheet = workbook.getSheetAt(page);
            for (int i = 0; i < sheet.getPhysicalNumberOfRows(); i++) {
                row = sheet.getRow(i);
                if (row != null) {
                    List<String> line = new ArrayList<>();

                    for (int j = 0; j < row.getPhysicalNumberOfCells(); j++) {
                        cell = row.getCell(j);
                        String cellValue = ExcelUtil.getCellValue(cell);
//                        if (cell != null && HSSFCell.CELL_TYPE_NUMERIC == cell.getCellType() && HSSFDateUtil.isCellDateFormatted(cell)) {
//                            line.add(DateUtil.format(HSSFDateUtil.getJavaDate(cell.getNumericCellValue()),DateUtil.DEFAULT_DATETIME_FORMAT));
//                            continue;
//                        }
//                        String cellValue = (cell != null ? ((HSSFCell.CELL_TYPE_STRING == cell
//                                .getCellType()) ? cell.getStringCellValue() : (new Double(
//                                cell.getNumericCellValue()) + "")) : "");
                        line.add(EmptyUtil.isNotEmpty(cellValue) ? cellValue.trim() : "");
                    }
                    allLines.add(line);
                }
            }

        } catch (IOException e) {
            log.warn("", e);
            return null;
        }

        return allLines;
    }
    //    public static void main(String[] args) throws Exception {
    //        List<List<String>> allLines = ExcelUtil.read(new FileInputStream(new File(
    //            "/Users/yuanchongyu/Desktop/c.xlsx")), false);
    //        for (List<String> line : allLines) {
    //            System.out.println(line.get(0) + "," + line.get(1));
    //        }
    //    }




    /**
     * 写excel(包含图片)
     *
     * @param sheetName sheet名
     * @param allLines 内容
     * @return
     * @throws Exception
     */
    public static byte[] writeImgExcelNew(String sheetName, List<List<String[]>> allLines) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();

        HSSFWorkbook wb = new HSSFWorkbook();

        HSSFSheet sheet = wb.createSheet(sheetName);

        //画图的顶级管理器，一个sheet只能获取一个（一定要注意这点）
        HSSFPatriarch patriarch = sheet.createDrawingPatriarch();

        Row row = sheet.createRow(0);
        HSSFCellStyle cellStyle= wb.createCellStyle();
        for (int i = 0; i < allLines.size(); i++) {
            row = sheet.createRow(i);
            log.info("writeImgExcelNew:sku_code={}",allLines.get(i).get(0)[0]);
            List<String[]> line = allLines.get(i);
            File imagefile;
            //第一行为标题
            if(i >= 1){
                row.setHeight((short) 1500);
                for (int j = 0; j < line.size(); j++) {
                    String[] cellInfo = line.get(j);
                    Cell cell = row.createCell(j);
                    if(Integer.valueOf(cellInfo[1]).intValue() == ExcelCellTypeEnum.TYPE_STRING.getCode()){
                        sheet.setColumnWidth(j, 6000);
                        cellStyle.setWrapText(true);
                        cell.setCellType(HSSFCell.CELL_TYPE_STRING);
                        cell.setCellStyle(cellStyle);
                        cell.setCellValue(new HSSFRichTextString(cellInfo[0]));
                    }
                    if(Integer.valueOf(cellInfo[1]).intValue() == ExcelCellTypeEnum.TYPE_IMAGE.getCode()){
                        sheet.setColumnWidth(j, 3500);
                        if(!ObjectUtils.isEmpty(cellInfo[0])){
                            try {
                                imagefile = new File(cellInfo[0]);
                                if(imagefile.length() < 1048576){
                                    BufferedImage bufferImg = null;
                                    ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
                                    URL url = new URL(cellInfo[0]);
                                    Image src = Toolkit.getDefaultToolkit().getImage(url);
                                    bufferImg = toBufferedImage(src);//Image to BufferedImage
                                    ImageIO.write(bufferImg, "jpg", byteArrayOut);
                                    //
                                    HSSFClientAnchor anchor = new HSSFClientAnchor(0, 0, 0, 0,(short) j, (short) i, (short) (j+1),  (short) (i+1));//anchor主要用于设置图片的属性
                                    anchor.setAnchorType(3);
                                    patriarch.createPicture(anchor, wb.addPicture(byteArrayOut.toByteArray(), HSSFWorkbook.PICTURE_TYPE_JPEG));//插入图片
                                }else{
                                    cell.setCellType(HSSFCell.CELL_TYPE_STRING);
                                    cell.setCellValue(cellInfo[0]);
                                }
                            } catch (Exception e1) {
                                e1.printStackTrace();
                                cell.setCellType(HSSFCell.CELL_TYPE_STRING);
                                cell.setCellValue(cellInfo[0]);
                            }
                        }else{
                            cell.setCellType(HSSFCell.CELL_TYPE_STRING);
                            cell.setCellValue("");
                        }

                    }
                    if(Integer.valueOf(cellInfo[1]).intValue() == ExcelCellTypeEnum.TYPE_NUMBER.getCode()){
                        HSSFDataFormat df = wb.createDataFormat();
                        cellStyle.setDataFormat(df.getFormat("#,#0.00"));
                        cell.setCellType(HSSFCell.CELL_TYPE_NUMERIC);
                        cell.setCellStyle(cellStyle);
                        cell.setCellValue(Double.valueOf(cellInfo[0]));
                    }
                }
            }else{
                for (int j = 0; j < line.size(); j++) {
                    Cell cell = row.createCell(j);

                    cell.setCellType(HSSFCell.CELL_TYPE_STRING);
                    cell.setCellValue(new HSSFRichTextString(line.get(j)[0]));
                }
            }

        }

        try {
            wb.write(os);
            os.flush();
            os.close();
        } catch (IOException e) {
            log.warn("", e);
            throw new RuntimeException("Write Excel File Error");
        }

        return os.toByteArray();
    }


    /**
     * 在已有的Excel文件中插入一行新的数据的入口方法
     */
    public final static byte[] insertRows(File file, String sheetName, List<ExcelRowTemplate> rows) {
        XSSFWorkbook wb = returnWorkBookGivenFileHandle(file);
        XSSFSheet sheet1 = wb.getSheet(sheetName);
        int rowTotal = rows.size();
        for(int i = 0; i < rowTotal; i ++) {
            ExcelRowTemplate rowTemplate = rows.get(i);
            if (rowTemplate.isInsertRow()) {
                sheet1.shiftRows(rowTemplate.getRowNum(), sheet1.getLastRowNum(), 1, true, false);
            }
            insertCells(wb, sheet1, rowTemplate.getCells());
        }
      /*  for(int i = 0; i < rowTotal; i ++) {
            ExcelRowTemplate rowTemplate = rows.get(i);

        }*/
        //createCell(row);
       return saveExcel(wb);
    }

    public static void  insertCells(XSSFWorkbook wb, XSSFSheet sheet1, List<ExcelRowCellTemplate> cellTemplates) {
        int cellTotal = cellTemplates.size();
        for (int i = 0; i < cellTotal; i ++) {
            createCell(wb, sheet1, cellTemplates.get(i));
        }
    }
    /**
     * 保存工作薄
     * @param wb
     */
    private static byte[] saveExcel(XSSFWorkbook wb) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            wb.write(os);
            wb.close();
            os.flush();
            os.close();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return os.toByteArray();
    }
    /**
     * 创建要出入的行中单元格
     * @param
     * @return
     */
    private static XSSFCell createCell(XSSFWorkbook wb, XSSFSheet sheet, ExcelRowCellTemplate cellTemplate) {
        int rowNum = cellTemplate.getRowNum();
        XSSFRow row = sheet.getRow(rowNum);
        if (row == null) {
            row = sheet.createRow(rowNum);
        }
        int columnIndex = cellTemplate.getColumnIndex();
        if (cellTemplate.isWhetherToMergeCells()) {
            //单元格合并
            sheet.addMergedRegion(new CellRangeAddress(cellTemplate.getFirstRow() == null ? rowNum : cellTemplate.getFirstRow()
                    , cellTemplate.getLastRow() == null ? rowNum : cellTemplate.getLastRow()
                    , cellTemplate.getFirstCol() == null ? columnIndex : cellTemplate.getFirstCol()
                    , cellTemplate.getLastCol() == null ? columnIndex : cellTemplate.getLastCol()));
        }
        XSSFCellStyle style = wb.createCellStyle();
        if (cellTemplate.getAlignCenter() != null) {
            style.setAlignment(cellTemplate.getAlignCenter());
        }

        if(cellTemplate.getVerticalCenter() != null) {
            style.setVerticalAlignment(cellTemplate.getVerticalCenter());
        }

        if (cellTemplate.getFillPattern() != null) {
            style.setFillPattern(cellTemplate.getFillPattern());
        }
        if (cellTemplate.getFillForegroundColor() != null) {
            style.setFillForegroundColor(cellTemplate.getFillForegroundColor());
        }


        ExcelCellStyle excelCellStyle = cellTemplate.getStyle();
        //设置字体
        XSSFFont font = wb.createFont();
        if (cellTemplate.getFontSize() != null) {
            font.setFontHeightInPoints(cellTemplate.getFontSize()); // 字体高度
        }

        if (cellTemplate.getFontName() != null) {
            font.setFontName(cellTemplate.getFontName()); // 字体
        }

        if (excelCellStyle != null) {
            if (excelCellStyle.getBorderLeft() != null) {
                style.setBorderLeft(excelCellStyle.getBorderLeft());
            }
            if(excelCellStyle.getBorderRight() != null) {
                style.setBorderRight(excelCellStyle.getBorderRight());
            }
            if (excelCellStyle.getBorderBottom() != null) {
                style.setBorderBottom(excelCellStyle.getBorderBottom());
            }
            if (excelCellStyle.getBorderTop() != null) {
                style.setBorderTop(excelCellStyle.getBorderTop());
            }
            if (excelCellStyle.getFontSize() != null) {
                font.setFontHeightInPoints(excelCellStyle.getFontSize());
            }
            if (excelCellStyle.getFontName() != null) {
                font.setFontName(excelCellStyle.getFontName());
            }

            if (excelCellStyle.getAlignment() != null) {
              style.setAlignment(excelCellStyle.getAlignment());
            }
            style.setVerticalAlignment(excelCellStyle.getVerticalAlignment());
            style.setWrapText(excelCellStyle.isWrapText());

            byte[] rgb = {89, 89 , 89};
            XSSFColor color = new XSSFColor(rgb);
            style.setLeftBorderColor(color);
            style.setBottomBorderColor(color);
        }
        style.setFont(font);

        XSSFCell cell = row.createCell(cellTemplate.getColumnIndex());
        cell.setCellStyle(style);
        if (cellTemplate.isLink()) {
            try {
                row.setHeightInPoints(50);
                URL url = new URL(cellTemplate.getCellValue());
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setConnectTimeout(50 * 1000);
                InputStream inStream = conn.getInputStream();//通过输入流获取图片数据
                byte[] bytes = IOUtils.toByteArray(inStream);
                int pictureIdx = wb.addPicture(bytes, Workbook.PICTURE_TYPE_PNG);

                CreationHelper helper = wb.getCreationHelper();
                Drawing drawing = sheet.createDrawingPatriarch();
                ClientAnchor anchor = helper.createClientAnchor();

                // 图片插入坐标
                anchor.setDx1(0);
                anchor.setDy1(0);
                anchor.setDx2(0);
                anchor.setDy2(0);
                anchor.setCol1(cellTemplate.getColumnIndex());
                anchor.setCol2(cellTemplate.getColumnIndex() + 1);
                anchor.setRow1(rowNum);
                anchor.setRow2(rowNum + 1);
                // 插入图片
                Picture pict = drawing.createPicture(anchor, pictureIdx);
                pict.resize(1);



            } catch (FileNotFoundException e) {
                e.printStackTrace();
            } catch (ProtocolException e) {
                e.printStackTrace();
            } catch (MalformedURLException e) {
                e.printStackTrace();
            } catch (IOException e) {
                e.printStackTrace();
            }finally {

            }
            /*Hyperlink link = wb.getCreationHelper().createHyperlink(Hyperlink.LINK_URL);
            link.setAddress(cellTemplate.getCellValue());
            cell.setHyperlink(link);
            cell.setCellValue(cellTemplate.getCellValue());*/
        } else {
            cell.setCellValue(cellTemplate.getCellValue());
        }
        return cell;
    }
    /**
     * 得到一个已有的工作薄的POI对象
     * @return
     */
    private static XSSFWorkbook returnWorkBookGivenFileHandle(File f) {
        XSSFWorkbook wb = null;
        FileInputStream fis = null;
        try {
            if (f != null) {
                fis = new FileInputStream(f);
                wb = new XSSFWorkbook(fis);
            }
        } catch (Exception e) {
            return null;
        } finally {
            if (fis != null) {
                try {
                    fis.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return wb;
    }
    /**
     * 找到需要插入的行数，并新建一个POI的row对象
     * @param sheet
     * @param rowIndex
     * @return
     */
    private XSSFRow createRow(XSSFSheet sheet, ExcelRowTemplate rowTemplate) {
        int rowIndex = rowTemplate.getRowNum();
        XSSFRow row = sheet.getRow(rowIndex);
        if (row == null) {
            int lastRowNo = sheet.getLastRowNum();
            sheet.shiftRows(rowIndex, lastRowNo, 1);
        }
        row = sheet.createRow(rowIndex);
        return row;
    }

    /**
     * 找到需要插入的行数，并新建一个POI的row对象
     * @param sheet
     * @param rowIndex
     * @return
     */
    private XSSFRow getRow(XSSFSheet sheet, Integer rowIndex) {
        return sheet.getRow(rowIndex);
    }



    public static void main(String[] args) throws Exception{
        /* Create a Workbook and Worksheet */
        XSSFWorkbook my_workbook = new XSSFWorkbook();
        XSSFSheet my_sheet = my_workbook.createSheet("MyBanner");
        /* Read the input image into InputStream */
        InputStream my_banner_image = new FileInputStream("D:\\10010001_thumb.jpg");
        /* Convert Image to byte array */
        byte[] bytes = IOUtils.toByteArray(my_banner_image);
        /* Add Picture to workbook and get a index for the picture */
        int my_picture_id = my_workbook.addPicture(bytes, Workbook.PICTURE_TYPE_JPEG);
        /* Close Input Stream */
        my_banner_image.close();
        /* Create the drawing container */
        XSSFDrawing drawing = my_sheet.createDrawingPatriarch();
        /* Create an anchor point */
        ClientAnchor my_anchor = new XSSFClientAnchor();
        /* Define top left corner, and we can resize picture suitable from there */
        my_anchor.setCol1(2);
        my_anchor.setRow1(1);
        /* Invoke createPicture and pass the anchor point and ID */
        XSSFPicture  my_picture = drawing.createPicture(my_anchor, my_picture_id);
        /* Call resize method, which resizes the image */
        my_picture.resize();
        /* Write changes to the workbook */
        FileOutputStream out = new FileOutputStream(new File("D:\\excel_insert_image_example.xlsx"));
        my_workbook.write(out);
        out.close();
    }

}