package com.thebeastshop.pegasus.util.comm;

import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class ExcelImportBuilder {
	private static final Logger log = LoggerFactory.getLogger(ExcelImportBuilder.class);
    
	private MultipartFile multipartFile = null; 
    private int columnNum = 0; 
    
    public ExcelImportBuilder fileName(MultipartFile multipartFile){
    	this.multipartFile = multipartFile;
    	return this;
    }
    
    public ExcelImportBuilder col(int columnNum){
    	this.columnNum = columnNum;
    	return this;
    }

    public List<String[]> builder(){
    	Workbook wb = null;
		List<String[]> result = new ArrayList<String[]>();
		try{
			InputStream inputStream = this.multipartFile.getInputStream();
			/*try {
	            wb = new HSSFWorkbook(inputStream);
	        } catch (Exception ex) {
	        	wb = new XSSFWorkbook(inputStream);
	        }*/
			wb = WorkbookFactory.create(inputStream);
			Sheet sheet1 = wb.getSheetAt(0);
			int i = 0;
			for (Row row : sheet1) {
				i ++;
				//忽略第一行标题
				if (i == 1) {
					continue;
				}
				//如果第一列为空，则忽略
				if (StringUtils.isBlank(this.getCellValue(row.getCell(0)))) {
					break;
				}
				String[] array = new String[this.columnNum];
				for (int j = 0; j < this.columnNum; j++) {
					String value = this.getCellValue(row.getCell(j));
					array[j] = value;
				}
				result.add(array);
			}
		} catch (Exception e) {
			log.error(null, e);
		} finally {
			IOUtils.closeQuietly(wb);
		}
     	return result;
    }



	public List<String[]> builderNotColumnNum(){
		Workbook wb = null;
		List<String[]> result = new ArrayList<String[]>();
		try{
			InputStream inputStream = this.multipartFile.getInputStream();
			/*try {
	            wb = new HSSFWorkbook(inputStream);
	        } catch (Exception ex) {
	        	wb = new XSSFWorkbook(inputStream);
	        }*/
			wb = WorkbookFactory.create(inputStream);
			Sheet sheet1 = wb.getSheetAt(0);
			int i = 0;
			for (Row row : sheet1) {
				i ++;
				//忽略第一行标题
				if (i == 1) {
					continue;
				}
			/*	//如果第一列为空，则忽略
				if (StringUtils.isBlank(this.getCellValue(row.getCell(0)))) {
					break;
				}*/
				int count = row.getLastCellNum();
				String[] array = new String[count];
				for (int j = 0; j < count; j++) {
					String value = this.getCellValue(row.getCell(j));
					array[j] = value;
				}
				result.add(array);
			}
		} catch (Exception e) {
			log.error(null, e);
		} finally {
			IOUtils.closeQuietly(wb);
		}
		return result;
	}

    /**
	 * 得到一个xls单元格内容字符串
	 */
	private String getCellValue(Cell cell){
		if (cell == null) {
			return "";
		}
		int type = cell.getCellType();
		String result = "";
		if (type ==  Cell.CELL_TYPE_NUMERIC) {
			Double d = (Double)cell.getNumericCellValue();
			result = d.intValue() + "";
		} else if (type ==  Cell.CELL_TYPE_STRING){
			result = cell.getStringCellValue();
		}
		return result;
	}
}