package com.thebeastshop.pegasus.util.comm;

import com.thebeastshop.pegasus.util.enums.EnumMessage;
import org.apache.commons.collections.map.HashedMap;

import java.util.List;
import java.util.Map;

/**
 * Created by jim.huang on 2016/12/29.
 */
public class DictionaryUtil {

    public static <T extends EnumMessage> String getEnumNameByCode(int code, String className) throws Exception {
        Class clazz = Class.forName(className);
        Map<Object, T> enumMap = EnumUtil.toMap(clazz, "getCode");
        if (enumMap != null) {
            String enumName = "";
            T enumItem = (T) enumMap.get(code);
            if (enumItem != null) {
                enumName = enumItem.getName();
            }
            return enumName;
        } else {
            return "";
        }
    }

    public static <T extends EnumMessage> List<T> getEnumsByClazz(String className) throws Exception {
        Class clazz = Class.forName(className);
        return EnumUtil.toList(clazz);
    }

    public static void main(String[] args) {
        /*int i = 101;
        Map<Object, PackagePushGoljetStatusEnum> map = new HashedMap();
        map = EnumUtil.toMap(PackagePushGoljetStatusEnum.class, "getCode");
        map.get(i).getName();*/
    }
}
