/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.util.comm;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * Date 工具类
 *
 * @author Royan
 * @version $Id: CodeGenerator.java, v 0.1 2015-07-07 上午10:44
 */
public class DateUtil {
    private static final Logger log                     = LoggerFactory.getLogger(DateUtil.class);

    public static final String  DEFAULT_DATE_FORMAT     = "yyyy-MM-dd";

    public static final String  DEFAULTDATEFORMAT     = "yyyyMMdd";

    public static final String  YEAR_FORMAT = "yyyy";

    public static final String  YEAR_MONTH_BAR_FORMAT     = "yyyy-MM";

    public static final String  YEAR_MONTH_FORMAT     = "yyyy年MM月";

    public static final String  DEFAULT_CN_DATE_FORMAT     = "yyyy年MM月dd日";

    public static final String  DEFAULT_TIME_FORMAT     = "HH:mm:ss";

    public static final String  DATE_STR_FORMAT_SSS     = "HH:mm:ss:SSS";

    public static final String  DEFAULT_DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public static final String  DEFAULT_STR_FORMAT      = "yyyyMMddHHmmss";

    public static final String  DATE_STR_FORMAT      = "yyyyMMddHHmmssSSS";

    public static final String  DATE_FORMAT            = "dd";

    public static final String  MOUNTH_FORMAT          = "MM";

    public static final Integer  WORK_DAY          = 0;
    public static final Integer  WEEK_DAY          = 1;
    public static final Integer  HOLIDAY          = 2;


    private final static SimpleDateFormat getFormat(String pattern, Locale locale) {
        return new SimpleDateFormat(pattern, locale);
    }

    /**
     * format 日期类型 格式化成字符串类型
     *
     * @param date
     * @param pattern
     * @return
     */
    public static String format(Date date, String pattern) {
        return format(date, pattern, Locale.getDefault());
    }

    /**
     * format 日期类型 格式化成字符串类型
     *
     * @param date
     * @param pattern
     * @param locale
     * @return
     */
    public static String format(Date date, String pattern, Locale locale) {
        if(date==null){
            return "";
        }
        if (StringUtils.isNotBlank(pattern)) {
            String format = getFormat(pattern, locale).format(date);
            return format;
        }
        throw new IllegalArgumentException("param pattern can not be null");
    }

    /**
     * parse 字符串类型转成日期类型
     *
     * @param dateString
     * @param pattern
     * @return
     */
    public static Date parse(String dateString, String pattern) {
        return parse(dateString, pattern, Locale.getDefault());
    }

    /**
     * 字符串类型转成日期类型
     *
     * @param dateString
     * @param pattern
     * @param locale
     * @return
     */
    public static Date parse(String dateString, String pattern, Locale locale) {
        if (StringUtils.isNotBlank(dateString)) {
            ParsePosition parsePosition = new ParsePosition(0);
            Date date = getFormat(pattern, locale).parse(dateString, parsePosition);
            Object[] objects = { dateString, pattern };
            log.debug("dateString:[{}], pattern:[{}], parsePosition:[{}]", objects);
            return date;
        }
        throw new IllegalArgumentException("param dateString can not be null");
    }

    /**
     * 增加或减少指定数量的时间
     *
     * @param date   时间
     * @param field  计算域
     * @param amount 数值
     */
    public static Date add(Date date, int field, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(field, amount);
        return calendar.getTime();
    }

    /**
     * 增加或减少指定天数
     *
     * @param date
     * @param amount
     * @return
     */
    public static Date addDay(Date date, int amount) {
        return add(date, Calendar.DAY_OF_YEAR, amount);
    }
    
    public static Date addBeforeMonthBeginDay(Date date){
    	Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
    	String strY = null;
    	int x = calendar.get(Calendar.YEAR);
        int y = calendar.get(Calendar.MONTH);
    	strY = y >= 10 ? String.valueOf(y) : ("0" + y);
    	String beginDay = x + "-" + strY + "-01";
    	return parse(beginDay,"yyyy-MM-dd");
    }
    
    public static Date addBeforeMonthEndDay(Date date){
    	Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        String strY = null;
        String strZ = null;
        boolean leap = false;
        int x = calendar.get(Calendar.YEAR);
        int y = calendar.get(Calendar.MONTH);
        if (y == 1 || y == 3 || y == 5 || y == 7 || y == 8 || y == 10 || y == 12) {
        	strZ = "31";
        }
        if (y == 4 || y == 6 || y == 9 || y == 11) {
            strZ = "30";
        }
        if (y == 2) {
            leap = leapYear(x);
        if (leap) {
            strZ = "29";
        }else {
            strZ = "28";
        }
        }
        strY = y >= 10 ? String.valueOf(y) : ("0" + y);
        String endDay =  x + "-" + strY + "-" + strZ;
    	return parse(endDay,"yyyy-MM-dd");
    }
    
    /**
     * 功能：判断输入年份是否为闰年<br>
     * 
     * @param year
     * @return 是：true  否：false
     * @author pure
     */
     public static boolean leapYear(int year) {
    	 boolean leap;
         if (year % 4 == 0) {
            if (year % 100 == 0) {
                 if (year % 400 == 0) leap = true;
                 else leap = false;
             }
             else leap = true;
         }
         else leap = false;
         return leap;
     }

    /**
     * 添加年。
     *
     * @param date
     *            日期
     * @param num
     *            添加的年数
     * @return 添加后的日期
     */
    public static Date addYears(Date date, int num) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(Calendar.YEAR, num);
        return cal.getTime();
    }
    /**
     * 增加或减少指定分钟
     *
     * @param date
     * @param amount
     * @return
     */
    public static Date addMinutes(Date date, int amount) {
        return add(date, Calendar.MINUTE, amount);
    }

    /**
     * 获得指定时间当天 00:00:00 的Date对象
     *
     * @param date 指定时间
     * @return 结果
     */
    public static Date dayStart(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND,0);
        return calendar.getTime();
    }

    public static Date yesterdayStart(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.DATE, -1);
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND,0);
        return calendar.getTime();
    }

    /**
     * 获得指定时间当天 23:59:59 的Date对象
     *
     * @param date 指定时间
     * @return 结果
     */
    public static Date dayEnd(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(Calendar.HOUR_OF_DAY, 23);
        calendar.set(Calendar.MINUTE, 59);
        calendar.set(Calendar.SECOND, 59);
        calendar.set(Calendar.MILLISECOND,999);
        return calendar.getTime();
    }

    public static Date dayEndSecond(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(Calendar.HOUR_OF_DAY, 23);
        calendar.set(Calendar.MINUTE, 59);
        calendar.set(Calendar.SECOND, 59);
        calendar.set(Calendar.MILLISECOND,000);
        return calendar.getTime();
    }

    public static Date yesterdayEnd(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.DATE, -1);
        calendar.set(Calendar.HOUR_OF_DAY, 23);
        calendar.set(Calendar.MINUTE, 59);
        calendar.set(Calendar.SECOND, 59);
        calendar.set(Calendar.MILLISECOND,999);
        return calendar.getTime();
    }

    /**
     * 获得中文周N
     *
     * @return 结果
     */
    public static String weekDayInChinese() {
        return weekDayInChinese(new Date());
    }

    /**
     * 根据指定日期获得中文周N
     *
     * @param date 指定日期
     * @return 结果
     */
    public static String weekDayInChinese(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int week = calendar.get(GregorianCalendar.DAY_OF_WEEK);
        switch (week) {
            case 1:
                return "日";
            case 2:
                return "一";
            case 3:
                return "二";
            case 4:
                return "三";
            case 5:
                return "四";
            case 6:
                return "五";
            case 7:
                return "六";
            default:
                return "";
        }
    }

    /**
     *  获取当前系统时间
     * @return
     */
    public static Date getNow() {
        return new Date();
    }

    public static String getNowFormat(String foramt){
        return format(getNow(),foramt);
    }

    public static Date getCurrDateByDateStr(String dateStr) {
        Date date = null;
        try {
            date = new SimpleDateFormat(DEFAULT_DATE_FORMAT).parse(dateStr);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static int getCurrYear() {
        return Calendar.getInstance().get(Calendar.YEAR);
    }

    public static int getCurrMonth() {
        return Calendar.getInstance().get(Calendar.MONTH)+1;
    }

    public static Date getPreMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.MONTH,-1);
        return calendar.getTime();
    }

    public static Date getYesterday() {
        return getPreDay(-1);
    }

    public static Date getPreDay(int preDay) {
        Calendar calendar = Calendar.getInstance();
        return addDay(calendar.getTime(),preDay);
    }

    public static Date getCurrMonthDate() {
        Calendar calendar = Calendar.getInstance();
        return calendar.getTime();
    }

    public static Date getNextMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.MONTH,1);
        return calendar.getTime();
    }

    public static Date getNextMonthByDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.MONTH,1);
        return calendar.getTime();
    }

    public static Date getFirstDateFromCurrMonth(){
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.MONTH,0);
        calendar.set(Calendar.DAY_OF_MONTH,1);
        return calendar.getTime();
    }

    public static Date getFirstDateFromCustomMonth(Date date){
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.MONTH,0);
        calendar.set(Calendar.DAY_OF_MONTH,1);
        return calendar.getTime();
    }

    public static Date getLastDateFromCurrMonth(){
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.MONTH,1);
        calendar.set(Calendar.DAY_OF_MONTH,0);
        return calendar.getTime();
    }

    public static Date getLastDateFromCustomMonth(Date date){
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.MONTH,1);
        calendar.set(Calendar.DAY_OF_MONTH,0);
        return calendar.getTime();
    }

    /**
     * 取得当月天数
     * */
    public static int getCurrentMonthLastDay(){
        Calendar a = Calendar.getInstance();
        a.set(Calendar.DATE, 1);//把日期设置为当月第一天
        a.roll(Calendar.DATE, -1);//日期回滚一天，也就是最后一天
        int maxDate = a.get(Calendar.DATE);
        return maxDate;
    }

    /**
     * 得到指定月的天数
     * */
    public static int getMonthLastDay(Date date){
        Calendar a = Calendar.getInstance();
        a.setTime(date);
        a.set(Calendar.DATE, 1);//把日期设置为当月第一天
        a.roll(Calendar.DATE, -1);//日期回滚一天，也就是最后一天
        int maxDate = a.get(Calendar.DATE);
        return maxDate;
    }

    /**
     * 获取周几(上周/下周)的时间
     * @param week 周几 	Calendar.MONDAY Calendar.FRIDAY...
     * @param weekNum 几周 	1[1周] 2[2周]...
     * @return
     */
    private static Date getLastOrNextWeek(int week,int weekNum) {
        GregorianCalendar currentDate = new GregorianCalendar();  
        currentDate.setFirstDayOfWeek(Calendar.MONDAY);
        currentDate.set(GregorianCalendar.DAY_OF_WEEK, week);  // 设置星期为周week
        currentDate.add(GregorianCalendar.WEEK_OF_YEAR, weekNum); // 加/减weekNum周 
        Date nextWeek = currentDate.getTime();  
        return nextWeek;
    }
    
    public static Date getLastWeek(int weekNum,int nextNum) {
        return getLastOrNextWeek(weekNum,-nextNum);
    }
    
    public static Date getCurrWeek(int weekNum) {
        return getLastOrNextWeek(weekNum,0);
    }
    
    public static Date getNextWeek(int weekNum,int nextNum) {
    	return getLastOrNextWeek(weekNum,nextNum); 
    }
    
	/**
     * 获取上周五时间
     */
    private static Date getLastFriday() {
    	return getLastWeek(Calendar.FRIDAY,1);
    }
    
    public static Date getLastFridayStart(){
    	Date fridayStart = getLastFriday();  
        return dayStart(fridayStart);
    }
    
    public static Date getLastFridayEnd(){
    	Date fridayEnd = getLastFriday();  
        return dayEnd(fridayEnd);
    }
    
    /**
     * 获得下周五时间
     */
    private static Date getNextFriday() {  
        return getNextWeek(Calendar.FRIDAY,1);
    }  
    
    public static Date getNextFridayStart() {  
        Date fridayStart = getNextFriday();  
        return dayStart(fridayStart);
    }
    
    public static Date getNextFridayEnd() {  
        Date nextFridayEnd = getNextFriday();  
        return dayEnd(nextFridayEnd);
    }
	
	/**
	 * 获取本周五时间
	 */
	public static Date getCurrFriday(){
		return getCurrWeek(Calendar.FRIDAY);
	}
	
	public static Date getCurrFridayStart(){
		Date date = getCurrFriday();
		return dayStart(date);
	}
	public static Date getCurrFridayEnd(){
		Date date = getCurrFriday();
		return dayEnd(date);
	}
	
	/**  
     * 计算两个日期之间相差的天数  
     * @param smdate 较小的时间 
     * @param bdate  较大的时间 
     * @return 相差天数 
     * @throws ParseException  
     */    
    public static int daysBetween(Date smdate,Date bdate) throws ParseException{    
        SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd");  
        smdate=sdf.parse(sdf.format(smdate));
        bdate=sdf.parse(sdf.format(bdate));  
        Calendar cal = Calendar.getInstance();    
        cal.setTime(smdate);    
        long time1 = cal.getTimeInMillis();                 
        cal.setTime(bdate);    
        long time2 = cal.getTimeInMillis();         
        long betweenDays=(time2-time1)/(1000*3600*24);  
       return Integer.parseInt(String.valueOf(betweenDays));           
    }

    /**
     * 判断当前时间是否在一个区间内(包含开始时间和结束时间)
     *
     * @param strDateBegin
     *            开始时间 如:16:00:01
     * @param strDateEnd
     *            结束时间 如:23:59:59
     * @return
     * @throws IllegalArgumentException
     */
    public static boolean isInTime(String strDateBegin, String strDateEnd){
    	// 截取开始时间时分秒
        int strDateBeginH = Integer.parseInt(strDateBegin.substring(0, 2));
        int strDateBeginM = Integer.parseInt(strDateBegin.substring(3, 5));
        int strDateBeginS = Integer.parseInt(strDateBegin.substring(6, 8));
        // 截取结束时间时分秒
        int strDateEndH = Integer.parseInt(strDateEnd.substring(0, 2));
        int strDateEndM = Integer.parseInt(strDateEnd.substring(3, 5));
        int strDateEndS = Integer.parseInt(strDateEnd.substring(6, 8));

    	Calendar calendarStart = Calendar.getInstance();
    	calendarStart.setTime(Calendar.getInstance().getTime());
    	calendarStart.set(Calendar.HOUR_OF_DAY,strDateBeginH);
    	calendarStart.set(Calendar.MINUTE,strDateBeginM);
    	calendarStart.set(Calendar.SECOND,strDateBeginS);

    	Calendar calendarEnd = Calendar.getInstance();
    	calendarEnd.setTime(Calendar.getInstance().getTime());
    	calendarEnd.set(Calendar.HOUR_OF_DAY,strDateEndH);
    	calendarEnd.set(Calendar.MINUTE,strDateEndM);
    	calendarEnd.set(Calendar.SECOND,strDateEndS);

    	if(Calendar.getInstance().getTimeInMillis() >= calendarStart.getTimeInMillis()
    			&& Calendar.getInstance().getTimeInMillis()< calendarEnd.getTimeInMillis()){

    		return true;
    	}

    	return false;
    }

    /**
     * 有效期
     * @param startDate
     * @param endDate
     * @return
     */
    public static boolean termOfValidity(Date startDate ,Date endDate){
        if(null == startDate || null == endDate){
            return false;
        }
        Calendar instance = Calendar.getInstance();
        Long nowTime = instance.getTime().getTime();
        if(nowTime>startDate.getTime() && nowTime<endDate.getTime()){
            return true;
        }
        return false;
    }


    public static Boolean isInTime(Date startDate,Date endDate ,Date date){
        long startTimes =0L;
        long endTime = 0L;
        long sourceTime = new Date().getTime();
        if(null != startDate){
            startTimes = startDate.getTime();
        }
        if(null != endDate){
            endTime = endDate.getTime();
        }
        if(null != date){
            sourceTime = date.getTime();
        }
        if(startTimes<=sourceTime && endTime >= sourceTime){
            return true;
        }
        return false;
    }
    
    /** 
     * 获得指定日期的前一天 
     *  
     * @param specifiedDay 
     * @return 
     * @throws Exception 
     */  
    public static Date getSpecifiedDayBefore(String specifiedDay) {
        Calendar c = Calendar.getInstance();  
        Date date = null;  
        try {  
            date = new SimpleDateFormat(DEFAULT_DATETIME_FORMAT).parse(specifiedDay);  
        } catch (ParseException e) {  
            e.printStackTrace();  
        }  
        c.setTime(date);  
        int day = c.get(Calendar.DATE);  
        c.set(Calendar.DATE, day - 1);  
  
        String dayBefore = new SimpleDateFormat(DEFAULT_DATETIME_FORMAT).format(c  
                .getTime());
        Date beforeDay = parse(dayBefore, DEFAULT_DATETIME_FORMAT);
        return beforeDay;  
    }  

    /**
     * 通过时间秒毫秒数判断两个时间的间隔
     * @param date1
     * @param date2
     * @return
     */
    public static int differentDaysByMillisecond(Date date1,Date date2)
    {
        int days = (int) ((date2.getTime() - date1.getTime()) / (1000*3600*24));
        return days;
    }

    /**
     * @param :请求接口 http://api.goseek.cn/
     * @param currDate :日期参数yyyyMMdd
     * @return 返回结果 {"code":10000,"data":0}  0:工作日  1：星期天 2：节假日
     * 其它链接：http://tool.bitefu.net/jiari/vip.php
     */
    public static JSONObject fetchHoliday(String currDate) {
        BufferedReader reader = null;
        String result = null;
        JSONObject jsonObjectResult = null;
        StringBuffer sbf = new StringBuffer();
        String httpUrl = "http://api.goseek.cn/Tools/holiday?date=" + currDate;
        try {
            URL url = new URL(httpUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.connect();
            InputStream is = connection.getInputStream();
            reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String strRead = null;
            while ((strRead = reader.readLine()) != null) {
                sbf.append(strRead);
                sbf.append("\r\n");
            }
            result = sbf.toString();
            jsonObjectResult = JSONObject.parseObject(result);//转为JSONObject对象
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (reader != null){
                try {
                    reader.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return jsonObjectResult;
    }

    /**
     *
     * @param currDate
     * @return true:节假日 false：工作日
     */
    public static boolean checkHoliday(String currDate) {
        JSONObject jsonObject = fetchHoliday(currDate);
        String date = jsonObject.getString("data");
        return checkHolidayByType(date);
    }

    public static boolean checkHolidayByType(String dateType){
        if (EmptyUtil.isNotEmpty(dateType) && (dateType.equals("1")|| dateType.equals("2"))){
            return true;
        }
        return false;
    }

    /**
     * 获取法定日期类型
     * @param currDate
     * @return 0工作日，1星期天，2：节假日
     */
    public static int fetchStatutoryHolidayType(String currDate) {
        JSONObject jsonObject = fetchHoliday(currDate);
        String date = jsonObject.getString("data");
        if (EmptyUtil.isNotEmpty(date)){
            try{
                return Integer.parseInt(date);
            }catch (NumberFormatException e){
            }
        }
        return 0;
    }

    /**
     * 获取1年中每天的 格式化日期值
     * @param date
     * @return
     */
    public static List<String> fetchDayOfYear(Date date){
        List<String> daysOfYearList = new ArrayList<>();
        int days = getDayOfYearByYear(date);
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        for (int i=1;i<=days;i++){
            c.set(Calendar.DAY_OF_YEAR,i);
            daysOfYearList.add(DateUtil.format(c.getTime(),DateUtil.DEFAULTDATEFORMAT));
        }
        return daysOfYearList;
    }

    // 获取当年的天数
    public static int getDayOfYear() {
        Calendar c = Calendar.getInstance();
        return c.getActualMaximum(Calendar.DAY_OF_YEAR);
    }

    // 获取指定 日期所属年份的天数
    public static int getDayOfYearByYear(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.getActualMaximum(Calendar.DAY_OF_YEAR);
    }

    // 统计从当天至指定日期内和天数，除去节假日及星期
    public static int countCurDateToHolidayDays(Date minDate,Date currDate,Map<String,Boolean> dayHolidayMap){
        // 统计节假日天数
        int holidayDays = 0;
        Date addDate = null;
        Boolean isHoliday = false;
        try{
            int intervalDays = DateUtil.daysBetween(minDate,currDate);
            if (intervalDays>=0){
                for (int i=0;i<=intervalDays;i++){
                    addDate = DateUtil.addDay(currDate,-i);
                    isHoliday = dayHolidayMap.get(DateUtil.format(addDate,DateUtil.DEFAULTDATEFORMAT));
                    if (isHoliday == null){
                        isHoliday = checkHolidayByDate(addDate);
                        dayHolidayMap.put(DateUtil.format(addDate,DateUtil.DEFAULTDATEFORMAT),isHoliday);
                    }
                    if (isHoliday){
                        holidayDays += 1;
                    }
                }
            }
        }catch (Exception e){
            e.printStackTrace();
        }
        return holidayDays;
    }

    private static boolean checkHolidayByDate(Date date){
        return DateUtil.checkHoliday(DateUtil.format(date,DateUtil.DEFAULTDATEFORMAT));
    }

    /**
     *
     * @param currDate
     * @return 0:工作日  1：星期天 2：节假日
     */
    public static Integer fetchHolidayNum(String currDate) {
        JSONObject jsonObject = fetchHoliday(currDate);
        String date = jsonObject.getString("data");
        if (EmptyUtil.isNotEmpty(date)){
            return Integer.parseInt(date);
        }
        return 0;
    }

    public static void main(String[] args) {
		try {
			/*if("2017-08-14".compareTo("2017-08-15")>0){
				System.out.println(true);
			}else{
				System.out.println(false);
			}*/
            //System.out.println(DateUtil.format(getNextMonth(),YEAR_MONTH_FORMAT));
            /*System.out.println(DateUtil.format(new Date(117,11,12),DEFAULT_DATE_FORMAT));
            System.out.println(DateUtil.format(getNextMonthByDate(new Date(117,11,12)),DEFAULT_DATETIME_FORMAT));
            System.out.println(DateUtil.format(getFirstDateFromCurrMonth(),DEFAULT_DATETIME_FORMAT));
            System.out.println(DateUtil.format(getLastDateFromCurrMonth(),DEFAULT_DATETIME_FORMAT));
            System.out.println(DateUtil.format(getFirstDateFromCustomMonth(new Date(117,11,12)),DEFAULT_DATETIME_FORMAT));
            System.out.println(DateUtil.format(getLastDateFromCustomMonth(new Date(117,11,12)),DEFAULT_DATETIME_FORMAT));
            System.out.println(getMonthLastDay(new Date()));*/
            // System.out.println(format(getCurrDateByDateStr("2018-04-16"),DEFAULT_DATE_FORMAT));

            //boolean a = DateUtil.checkHoliday("20180101");
            //System.out.println("节假日："+a);

            //Map<String,Boolean> dayHolidayMap = new HashMap<>();
            //System.out.println(countCurDateToHolidayDays(DateUtil.addDay(new Date(),-4),new Date(),dayHolidayMap));

            System.out.println(getDayOfYearByYear(new Date()));
        } catch (Exception e) {
			e.printStackTrace();
		}
	}
    
    //获取指定月份的天数
    public static int getDaysByYearMonth(int year, int month) {
        Calendar a = Calendar.getInstance();
        a.set(Calendar.YEAR, year);
        a.set(Calendar.MONTH, month - 1);
        a.set(Calendar.DATE, 1);
        a.roll(Calendar.DATE, -1);
        int maxDate = a.get(Calendar.DATE);
        return maxDate;
    }

}