package com.thebeastshop.pegasus.util.comm;


import com.thebeastshop.pegasus.util.annotation.ObjectChangeLog;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class CompareObejct<T> {

    private CompareStatus status;
    /**
     * 之前原始的值
     */
    private T original;
    /**
     * 当前的值
     */
    private T current;

    private Class<T> tClass;


    public CompareObejct(T original, T current, Class<T> tClass) {
      this.original = original;
      this.current = current;
      this.tClass = tClass;
    }


    public CompareStatus getStatus() {
        return status;
    }


    public T getOriginal() {
        return original;
    }


    public void setOriginal(T original) {
        this.original = original;
    }


    public T getCurrent() {
        return current;
    }


    public void setCurrent(T current) {
        this.current = current;
    }


    public String contrastObj() {
        StringBuilder changeStringBuilder = new StringBuilder();
        boolean isEqual=true;
        try {
            if(this.original == null){
                this.status = CompareStatus.NEW;
                Field[] fields = tClass.getDeclaredFields();
                for (Field field : fields) {
                    ObjectChangeLog objectChangeLog = field.getAnnotation(ObjectChangeLog.class);
                    if (objectChangeLog != null) {
                        String filedName = objectChangeLog.name();
                        PropertyDescriptor pd = new PropertyDescriptor(field.getName(), tClass);
                        Method getMethod = pd.getReadMethod();
                        Object o2 = getMethod.invoke(this.current);
                        String s2 = o2 == null ? "" : o2.toString();//避免空指针异常
                        if (s2 != null && s2 != "") {
                            changeStringBuilder.append("" + filedName + "：[" + s2 + "]");
                        }

                    }
                }
            } else {
                //Class clazz = this.original.getClass();
                Field[] fields = tClass.getDeclaredFields();
                for (Field field : fields) {
                     System.out.println(field.getName());
                    ObjectChangeLog objectChangeLog = field.getAnnotation(ObjectChangeLog.class);
                    if (objectChangeLog != null) {
                        String filedName = objectChangeLog.name();
                        PropertyDescriptor pd = new PropertyDescriptor(field.getName(), tClass);
                        Method getMethod = pd.getReadMethod();
                        Object o1 = getMethod.invoke(this.original);
                        Object o2 = getMethod.invoke(this.current);
                        String s1 = o1 == null ? "" : o1.toString();//避免空指针异常
                        String s2 = o2 == null ? "" : o2.toString();//避免空指针异常
                        //思考下面注释的这一行：会bug的，虽然被try catch了，程序没报错，但是结果不是我们想要的
                        //if (!o1.toString().equals(o2.toString())) {
                        if (!s1.equals(s2)) {
                            //textList.add("不一样的属性：" + field.getName() + " 属性值：[" + s1 + "," + s2 + "]");
                            isEqual = false;
                            System.out.println("" + filedName + "：[" + s1 + "->" + s2 + "]");
                            changeStringBuilder.append("" + filedName + "：[" + s1 + "->" + s2 + "]");
                        }
                    }

                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        if(isEqual){
            this.status=CompareStatus.NO_CHANGE;
        }else{
            this.status=CompareStatus.CHANGE;
        }
        return changeStringBuilder.toString();
    }

}
