/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.util.comm;

import com.thebeastshop.pegasus.util.exception.UtilException;
import freemarker.template.Configuration;
import freemarker.template.Template;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.StringWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

/**
 * CODE 生成器
 *
 * @author Royan
 * @version $Id: CodeGenerator.java, v 0.1 2015-07-07 上午10:44
 */
public class CodeGenerator {

    private final Logger log = LoggerFactory.getLogger(CodeGenerator.class);

    private static CodeGenerator instance;

    // 缓存内容
    private Map<String, Template> __cachedTemplateMap = new ConcurrentHashMap<String, Template>();

    private CodeGenerator() {
        ResourceBundle config = ResourceBundle.getBundle("pegasus-util/code");
        Configuration cfg = new Configuration();
        Enumeration<String> codeTempNames = config.getKeys();
        while (codeTempNames.hasMoreElements()) {
            String codeTemplateName = codeTempNames.nextElement();
            try {
                Template tpl = new Template(codeTemplateName, config.getString(codeTemplateName), cfg);
                __cachedTemplateMap.put(codeTemplateName, tpl);
            } catch (Exception e) {
                log.warn("", e);
            }
        }
    }

    public static CodeGenerator getInstance() {
        if (instance != null) {
            return instance;
        }
        synchronized (CodeGenerator.class) {
            if (instance == null) {
                instance = new CodeGenerator();
            }
        }
        return instance;
    }

    /**
     * 生成CODE
     *
     * @param codeTemplateName CODE模板名
     * @param params           参数
     * @return CODE
     */
    public String generate(String codeTemplateName, Map<String, Object> params) {
        String result;
        Template tpl = __cachedTemplateMap.get(codeTemplateName);
        if (tpl == null) {
            throw new UtilException("can't find template for name : " + codeTemplateName);
        } else {
            StringWriter sw = new StringWriter();
            try {
                tpl.process(params, sw);
                result = sw.toString().toUpperCase();
            } catch (Exception e) {
                log.warn("", e);
                throw new UtilException("CodeGenerator.generate failed : " + codeTemplateName + " : " + params);
            }
        }
        return result;
    }
}