/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.util.comm;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;

import java.io.*;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * @author Roy.Chen
 * @version $Id: ReflectionUtil.java, v 0.1 2015-08-12 18:20
 */
public class BeanUtil {

    /**
     *
     * @param src  源bean
     * @param clz   目标bean class
     * @return
     */
    public static <T> T buildFrom(Object src, Class<T> clz) {
        return buildFrom(src, clz, null);
    }

    /**
     *
     * @param src  源bean
     * @param clz   目标bean class
     * @param ignoreProperties 忽略的属性
     * @return
     */
    public static <T> T buildFrom(Object src, Class<T> clz, String[] ignoreProperties) {
        if (src == null)
            return null;
        Object obj = null;
        try {
            obj = clz.newInstance();
            BeanUtils.copyProperties(src, obj, ignoreProperties);
        } catch (InstantiationException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return (T) obj;
    }

    /**
     *
     * @param src  源bean
     * @param clz   目标bean class
     * @return
     */
    public static <T> List<T> buildListFrom(Collection src, Class<T> clz) {
        return buildListFrom(src, clz, null);
    }

    /**
     *
     * @param src  源bean
     * @param clz   目标bean class
     * @param ignoreProperties 忽略的属性
     * @return
     */
    public static <T> List<T> buildListFrom(Collection src, Class<T> clz, String[] ignoreProperties) {
        if (CollectionUtils.isEmpty(src))
            return Collections.emptyList();

        List<T> objs = new ArrayList<T>(src.size());
        try {
            for (Object o : src) {
                Object obj = clz.newInstance();
                BeanUtils.copyProperties(o, obj, ignoreProperties);
                objs.add((T) obj);
            }
        } catch (InstantiationException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return objs;
    }

    /**
     *
     * @param src  源bean
     * @param clz   目标bean class
     * @return
     */
    public static <T> Map<String, T> copyMap(Map<String, Object> src, Class<T> clz)
      throws IllegalAccessException, InstantiationException {
        if (EmptyUtil.isEmpty(src)) {
            return  null;
        }
        Map<String, T> resultMap = new HashMap<>();
        for (Map.Entry<String, Object> entry : src.entrySet()) {
            Object obj = clz.newInstance();
            BeanUtils.copyProperties(src, obj);
            resultMap.put(entry.getKey(), (T)obj);
        }
        return resultMap;
    }

    public static <T> T deepCopy(Object src, Class<T> clz) {
       if (src == null) {
         return  null;
       }
       Object targetObj = null;
       ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(src);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(outputStream.toByteArray());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            targetObj = (T)objectInputStream.readObject();
        } catch (IOException e) {
            e.printStackTrace();
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        }finally {
            try {
                outputStream.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return (T)targetObj;
    }


}
