/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.util.comm;

import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Base64 工具类
 *
 * @author Royan
 * @version $Id: CodeGenerator.java, v 0.1 2015-07-07 上午10:44
 */
public class Base64Util {

    private final static Logger log = LoggerFactory.getLogger(Base64Util.class);

    /**
     * 编码
     *
     * @param binary 待编码
     * @return 编码结果
     * */
    public static String encode(byte[] binary) {
        String res = null;
        try {
            res = Base64.encodeBase64String(binary);
        } catch (Exception e) {
            log.error("", e);
        }
        return res;
    }

    /**
     * 解码
     *
     * @param content 待解码
     * @return 解码结果
     * */
    public static byte[] decode(String content) {
        byte[] res = null;
        try {
            res = Base64.decodeBase64(content);
        } catch (Exception e) {
            log.error("", e);
        }
        return res;
    }

}
