/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.util;

import java.io.IOException;
import java.util.*;

import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.cond.CommHolidayCond;
import com.thebeastshop.pegasus.util.vo.*;
import com.taobao.api.response.ItemSkuGetResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.HttpException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import com.taobao.api.ApiException;
import com.taobao.api.response.ItemQuantityUpdateResponse;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.cond.CommDictionaryCond;
import com.thebeastshop.pegasus.util.model.CommCity;
import com.thebeastshop.pegasus.util.model.CommCountry;
import com.thebeastshop.pegasus.util.model.CommCurrency;
import com.thebeastshop.pegasus.util.model.CommDictionary;
import com.thebeastshop.pegasus.util.model.CommDistrict;
import com.thebeastshop.pegasus.util.model.CommEntityOpRcd;
import com.thebeastshop.pegasus.util.model.CommFileRef;
import com.thebeastshop.pegasus.util.model.CommFileRefExample;
import com.thebeastshop.pegasus.util.model.CommGlobalConfig;
import com.thebeastshop.pegasus.util.model.CommOperationRcd;
import com.thebeastshop.pegasus.util.model.CommProvince;
import com.thebeastshop.pegasus.util.model.CommSendMail;
import com.thebeastshop.pegasus.util.model.CommTaxRate;
import com.thebeastshop.pegasus.util.model.CommTypeValue;
import com.thebeastshop.pegasus.util.model.ThirdpartyOrdersShipLog;
import com.thebeastshop.pegasus.util.model.ThirdpartyOrdersShipLogKey;
import com.thebeastshop.pegasus.util.service.CommAddressService;
import com.thebeastshop.pegasus.util.service.CommDictionaryService;
import com.thebeastshop.pegasus.util.service.CommEntityOperationRcdService;
import com.thebeastshop.pegasus.util.service.CommFileRefService;
import com.thebeastshop.pegasus.util.service.CommFileService;
import com.thebeastshop.pegasus.util.service.CommGlobalConfigService;
import com.thebeastshop.pegasus.util.service.CommOperationRcdService;
import com.thebeastshop.pegasus.util.service.CommSendMailService;
import com.thebeastshop.pegasus.util.service.CommThirdPartyService;
import com.thebeastshop.pegasus.util.service.CommTmallService;
import com.thebeastshop.pegasus.util.service.CommTypeValueService;
import com.thebeastshop.pegasus.util.service.CommaVipService;
import com.thebeastshop.pegasus.util.model.*;
import com.thebeastshop.pegasus.util.service.*;
import com.thebeastshop.tmall.dto.NextoneLogisticsWarehouseUpdateResponseDTO;
import com.thebeastshop.tmall.dto.TmallTbRefundDTO;

import vipapis.delivery.PrintTemplateResponse;
import vipapis.delivery.Ship;
import vipapis.delivery.ShipResult;

/**
 * @author Royan
 * @version $Id: PegasusUtilFacade.java, v 0.1 2015-07-01 下午3:00
 */
public class PegasusUtilFacade {

    private final static Logger log = LoggerFactory.getLogger(PegasusUtilFacade.class);

    private static PegasusUtilFacade instance;

    @Autowired
    private CommAddressService commAddressService;

    @Autowired
    private CommDictionaryService commDictionaryService;

    @Autowired
    private CommOperationRcdService commOperationRcdService;

    @Autowired
    private CommEntityOperationRcdService commEntityOperationRcdService;

    @Autowired
    private CommFileService commFileService;

    @Autowired
    private CommFileRefService commFileRefService;

    @Autowired
    private CommGlobalConfigService commGlobalConfigService;
    
    @Autowired
    private CommTmallService commTmallService;

    @Autowired
    private CommJdService commJdService;


    @Autowired
    private CommTypeValueService commTypeValueService;
    
    @Autowired
    private CommaVipService commaVipService;
    
    @Autowired
    private CommThirdPartyService commThirdPartyService;

    @Autowired
    private CommSendMailService commSendMailService;

    @Autowired
    private CommHolidayService commHolidayService;

    private PegasusUtilFacade() {

    }

    public static PegasusUtilFacade getInstance() {
        if (instance != null) {
            return instance;
        }

        synchronized (PegasusUtilFacade.class) {
            if (instance == null) {
                log.info("[fasade init start] PegasusUtilFacade");
                new ClassPathXmlApplicationContext("pegasus-util/spring.xml");
                log.info("[fasade init finish] PegasusUtilFacade");
            }
            instance = (PegasusUtilFacade) SpringUtil.getBean("pegasusUtilFacade");
        }
        return instance;
    }

    // commAddressService

    public  void refreshCacheAddress(){
        commAddressService.refreshCache();
    }

    /**
     * 查找所有国家
     *
     * @param cascade 是否级联;
     * @return 国家列表
     */
    public List<CommCountry> findAllCountry(boolean cascade) {
        return commAddressService.findAllCountry(cascade);
    }
    
    /**
     * 查找国外国家列表
     * @param countryName
     * @param cascade
     * @return
     */
    public List<CommCountry> findForeignCountry(String countryName, boolean cascade) {
    	return commAddressService.findForeignCountry(countryName, cascade);
    }

    /**
     * 根据ID查找国家
     *
     * @param id      国家ID;
     * @param cascade 是否级联;
     * @return 国家
     */
    public CommCountry findCountryById(Long id, boolean cascade) {
        return commAddressService.findCountryById(id, cascade);
    }

    /**
     * 根据名称查找国家,精确匹配
     *
     * @param name
     * @return 国家
     */
    public CommCountry findCountryByName(String name) {
        return commAddressService.findCountryByName(name);
    }

    /**
     * 根据国家ID查找省份
     *
     * @param countryId 国家ID;
     * @param cascade   是否级联;
     * @return 省份列表
     */
    public List<CommProvince> findProvinceByCountryId(Long countryId, boolean cascade) {
        return commAddressService.findProvinceByCountryId(countryId, cascade);
    }

    /**
     * 根据ID查找省份
     *
     * @param id      省份ID;
     * @param cascade 是否级联;
     * @return 省份
     */
    public CommProvince findProvinceById(Long id, boolean cascade) {
        return commAddressService.findProvinceById(id, cascade);
    }

    /**
     * 根据区县ID查找省份
     * @param districtId
     * @return
     */
    public CommProvince findProvinceBydistrictIdId(Long districtId) {
        return commAddressService.findProvinceBydistrictIdId(districtId);
    }

    /**
     * 根据条件查找省份
     * @param cond
     * @return
     */
    public List<CommProvince> findProvinceByCond(String cond) {
        return commAddressService.findProvinceByCond(cond);
    }

    /**
     * 根据省份ID查找城市
     *
     * @param provinceId 省份ID;
     * @param cascade    是否级联;
     * @return 城市列表
     */
    public List<CommCity> findCityByProvinceId(Long provinceId, boolean cascade) {
        return commAddressService.findCityByProvinceId(provinceId, cascade);
    }

    /**
     * 根据省份ID列表查找城市
     *
     * @param provinceIdList
     * @param cascade
     * @return
     */
    public List<CommCity> findCityByProvinceIdList(List<Long> provinceIdList, boolean cascade) {
        return commAddressService.findCityByProvinceIdList(provinceIdList, cascade);
    }


    /**
     * 根据条件查找城市
     *
     * @param cond 条件;
     * @return 城市列表
     */
    public List<CommCity> findCityByCond(String cond) {
        return commAddressService.findCityByCond(cond);
    }
    public List<CommCity> findCityByProvinceAndName(Long provinceId,String cityName){
        return commAddressService.findCityByProvinceAndName(provinceId,cityName);
    }
    /**
     * 根据ID查找城市
     *
     * @param id      城市ID;
     * @param cascade 是否级联;
     * @return 城市
     */
    public CommCity findCityById(Long id, boolean cascade) {
        return commAddressService.findCityById(id, cascade);
    }

    public List<CommCity> findCityByIds(List<Long> ids, boolean cascade) {
        return commAddressService.findCityByIds(ids, cascade);
    }

    /**
     * 根据城市ID查找区县
     *
     * @param cityId 城市ID;
     * @return 区县列表
     */
    public List<CommDistrict> findDistrictByCityId(Long cityId) {
        return commAddressService.findDistrictByCityId(cityId);
    }

    /**
     * 根据ID查找区县
     *
     * @param id 区县ID;
     * @return 区县
     */
    public CommDistrict findDistrictById(Long id) {
        return commAddressService.findDistrictById(id);
    }

    public List<CommDistrict> findDistrictByIds(List<Long> ids) {
        return commAddressService.findDistrictByIds(ids);
    }

    /**
     * 根据条件查找区县
     *
     * @return
     */
    public List<CommDistrict> findDistrictByCond(String cond) {
        return commAddressService.findDistrictByCond(cond);
    }
    public List<CommDistrict> findDistrictByCityAndDistrictName(Long cityId,String districtName) {
        return commAddressService.findDistrictByCityAndDistrictName(cityId,districtName);
    }
    /**
     *  根据省份ID查找所有级联的城市再级联到所有城市下的区县
     * @param id
     * @return
     */
    public List<CommDistrict> findDistrictByProvinceId(long id){
        return commAddressService.findDistrictByProvinceId(id);
    }

    /**
     *  根据省份ID查找所有级联的城市再级联到所有城市下的区县
     * @param id
     * @return
     */
    public List<Long> findDistrictIdByProvinceId(long id){
        return commAddressService.findDistrictIdByProvinceId(id);
    }

    // commDictionaryService

    /**
     * 查找所有币种
     *
     * @return 币种列表
     */
    public List<CommCurrency> findAllCurrency() {
        return commDictionaryService.findAllCurrency();
    }

    /**
     * 查找所有税率
     *
     * @return 税率列表
     */
    public List<CommTaxRate> findAllTaxRate() {
        return commDictionaryService.findAllTaxRate();
    }

    /**
     * 通过税率适用类型查找税率
     *
     * @return 税率列表
     */
    public List<CommTaxRate> findTaxRateByType(Integer rateType) {
        return commDictionaryService.findTaxRateByType(rateType);
    }

    // commOperationRcdService

    /**
     * 保存操作记录
     *
     * @param commOperationRcd 记录
     * @return 记录ID
     */
    public Long insertOperationRcd(CommOperationRcd commOperationRcd) {
        return commOperationRcdService.insertRcd(commOperationRcd);
    }

    // commEntityOperationRcdService

    /**
     * 保存实体变更操作记录
     *
     * @param commEntityOpRcd 记录
     * @return 记录ID
     * */
    public Long insertEntityOperationRcd(CommEntityOpRcd commEntityOpRcd){
        return commEntityOperationRcdService.insertRcd(commEntityOpRcd);
    }

    /**
     * 根据类型和ID查找实体变更操作记录
     * @param entityClazz
     * @param entityId
     * @return
     */
    public List<CommEntityOpRcd> findEntityOpRcdByClazzAndId(String entityClazz,String entityId){
        return commEntityOperationRcdService.findEntityOpRcdByClazzAndId(entityClazz,entityId);
    }

    // commFileService

    /**
     * 存储文件
     *
     * @param fileRequestVO
     * @return
     */
    public FileResponseVO storeFile(FileRequestVO fileRequestVO) {
        return commFileService.store(fileRequestVO);
    }

    public void createCommFileRef(CommFileRef commFileRef){
        commFileRefService.createFile(commFileRef);
    }

    public List<CommFileRef> findCommFileRef(String referenceCode,Integer referenceType){
        return commFileRefService.find(referenceCode,referenceType);
    }

    public List<CommFileRef> findByCommFileRef(String returnCode,String skuCode){
        return commFileRefService.findByCommFileRef(returnCode,skuCode);
    }

    public List<CommFileRef> findCommFileRefByCond(CommFileRef commFileRef){
        return commFileRefService.findByCond(commFileRef);
    }

    public int updateByCond(CommFileRef record,CommFileRefExample example){
        return commFileRefService.updateByCond(record,example);
    }
    public int updateByIdSelective(CommFileRef record){
        return commFileRefService.updateByIdSelective(record);
    }

    public CommFileRef findCommFileRefById(Long id){
        return commFileRefService.findById(id);
    }

    public List<CommFileRef> findCommFileRefByIds(List<Long> ids){
        return commFileRefService.findByIds(ids);
    }

    public List<CommFileRef> findCommFileRefByCond(CommFileRefExample example){
        return commFileRefService.findByCond(example);
    }

    public void deleteCommFileRef(Long id){
        commFileRefService.deleteById(id);
    }
    /**
     * 得到文件对象包含文件数据(String形式)
     *
     * @param id
     * @return
     */
    public FileResponseVO getFile(long id) {
        return commFileService.getFile(id, false);
    }

    public List<FileResponseVO> getFile(List<Long> ids, boolean isread) {
        return commFileService.getFile(ids, isread);
    }
    /**
     * 根据ID删除文件
     *
     * @param id
     * @return
     */
    public Boolean deleteFileById(long id) {
        return commFileService.deleteFileById(id);
    }

    /**
     * 存储图片
     *
     * @param fileRequestVO
     * @param width
     * @param height
     * @return
     */
    public FileResponseVO storeImage(FileRequestVO fileRequestVO, Integer width, Integer height) {
        return commFileService.storeImage(fileRequestVO, width, height);
    }

    /**
     * 图片存储目录
     *
     * @return
     */
    public String getStorePath() {
        return commFileService.getStorePath();
    }

    /**
     * 路径分隔符
     *
     * @return
     */
    public String getPathSeparator() {
        return commFileService.getPathSeparator();
    }


    /**
     * 修改图片名称
     *
     * @param id
     * @param fileName
     * @return
     */
    public Boolean modifyFileName(long id, String fileName) {
        return commFileService.modifyFileName(id, fileName);
    }


    // commGlobalConfigService

    /**
     * 根据key查找配置
     *
     * @param key
     * @return
     */
    public CommGlobalConfig findConfigByKey(String key) {
        return commGlobalConfigService.findConfigByKey(key);
    }

    @Deprecated
    public String findCancelStockToShelvesCode(String physicalWarehouseCode){
        String keyPrefix = "wms.cancel_stock_to_shelvescode.";
        CommGlobalConfig config = findConfigByKey(keyPrefix+physicalWarehouseCode);
        return NullUtil.isNull(config)?null:config.getConfigValue();
    }

    /***
     *
     * @param physicalWarehouseCode
     * @param skuStatus
     * key wms.cancel_stock_to_shelvescode.physicalWarehouseCode.skuStatus
     * @return
     */
    public String findCancelStockToShelvesCode(String physicalWarehouseCode,Integer skuStatus){
        String keyPrefix = "wms.cancel_stock_to_shelvescode.";
        CommGlobalConfig config = findConfigByKey(keyPrefix+physicalWarehouseCode+"."+skuStatus);
        return NullUtil.isNull(config)?null:config.getConfigValue();
    }
    
    /**
     * 根据类型获取配置数据
     * */
    public List<CommTypeValue> getCommTypeValuesByType(String type){
    	return commTypeValueService.getCommTypeValuesByType(type);
    }

    /**
     * 根据key查找配置
     *
     * @param configKey
     * @return
     */
    public String findByConfigKey(String configKey){
        return commGlobalConfigService.findByConfigKey(configKey);
    }
    
    public Long getSkuNumIid(String outerId, String sessionKey) throws Exception {
    	return commTmallService.getSkuNumIid(outerId, sessionKey);
    }

    public ItemSkuGetResponse taoBaoItemSkuGet(String channelCode, Long skuId, Long numIid, String nick) throws Exception {
    	return commTmallService.taoBaoItemSkuGet(channelCode, skuId ,numIid ,nick);
    }

    public int getSkuQuantity(String outerId, String sessionKey, Long numIid) throws Exception {
    	return commTmallService.getSkuQuantity(outerId, sessionKey, numIid);
    }
    
    public int getPromotionUmp(String sessionKey, Long numIid) throws Exception {
    	return commTmallService.getPromotionUmp(sessionKey, numIid);
    }

    public boolean needSyncJdStock(String warehouseCode){
        return commJdService.needSyncStock(warehouseCode);
    }
    public Map<String,JdStockSyncResult> syncJdSkuStock(String warehouseCode, Map<String,Integer> skuQuantityMap){
        return commJdService.syncSkuStock(warehouseCode,skuQuantityMap);
    }

    public CommDistrict getDistrictIdByRegion(Region region) {
    	return commAddressService.getDistrictIdByRegion(region);
    }
    
    public List<CommDictionary> findDictionaryByType(String dictType) {
    	return commDictionaryService.findDictionaryByType(dictType);
    }
    public List<CommDictionary> findDictionaryByCond(CommDictionaryCond cond) {
    	return commDictionaryService.findDictionaryByCond(cond);
    }

    public int batchCreateCommDictionary(List<CommDictionary> commDictionaries) {
    	return commDictionaryService.batchInsert(commDictionaries);
    }

    /**
     * 获取所有可店送城市
     *
     * @return
     */
    public List<CommCity> getShopCity(List list){
        return commAddressService.getShopCity(list);
    }
    /**
     * 根据类型、操作类型和ID查找实体变更操作记录
     * @param entityClazz
     * @param entityId
     * @return
     */
    public List<CommEntityOpRcd> findEntityOpRcdByClazzAndId(Integer operationType, String entityClazz,String entityId){
        return commEntityOperationRcdService.findEntityOpRcdByClazzAndId(operationType, entityClazz,entityId);
    }
    
    public ShipResult vipShip(List<Ship> shipList) {
    	return commaVipService.ship(shipList);
    }
    
    public PrintTemplateResponse getPrintTemplate(String outerOrderCode) {
    	return commaVipService.getPrintTemplate(outerOrderCode);
    }
    
    public void addThirdPartyShipLog(ThirdpartyOrdersShipLog thirdpartyOrdersShipLog) {
    	commThirdPartyService.addThirdPartyShipLog(thirdpartyOrdersShipLog);
    }
	
	public void updateThirdPartyShipLog(ThirdpartyOrdersShipLog thirdpartyOrdersShipLog) {
		commThirdPartyService.updateThirdPartyShipLog(thirdpartyOrdersShipLog);
	}
	
	public ThirdpartyOrdersShipLog findByShipLogPrimaryKey(ThirdpartyOrdersShipLogKey key) {
		return commThirdPartyService.findByPrimaryKey(key);
	}
	
	public List<ThirdpartyOrdersShipLog> findNotShipList()  {
		return commThirdPartyService.findNotShipList();
	}
	public FileResponseVO saveOssInfoToDb(FileRequestVO fileRequestVO) {
      return  commFileService.saveOssInfoToDb(fileRequestVO);
    }

    public void createCommSendMail(CommSendMail commSendMail){
        commSendMailService.createCommSendMail(commSendMail);
    }

    public List<CommHoliday> listCommHolidaysByCond(CommHolidayCond cond){
        return commHolidayService.listCommHolidaysByCond(cond);
    }

    /**
     * 获取当前年份的所有日期
     * 如果不存在，则重新从网上获取当前年份法定节假日信息 并保存下来
     * @param date
     * @return
     */
    public List<CommHoliday> listCommHolidaysByYear(Date date){
        CommHolidayCond cond = new CommHolidayCond();
        cond.setYearValue(DateUtil.format(date,DateUtil.YEAR_FORMAT));
        List<CommHoliday> commHolidays = commHolidayService.listCommHolidaysByCond(cond);
        if (CollectionUtils.isEmpty(commHolidays)
                || (commHolidays.size() != DateUtil.getDayOfYearByYear(date))){
            // 先清空
            commHolidayService.delCommHolidayByCond(cond);
            // 重新获取并保存
            anewFetchAndInsertCommHolidayByYear(date,cond.getYearValue());
            // 再查询一次
            commHolidays = commHolidayService.listCommHolidaysByCond(cond);
        }
        return commHolidays;
    }

    /**
     * 获取节假日的类型值
     * @param date
     * @return
     */
    public Map<String,Integer> mapCommHolidaysTypeByYear(Date date){
        List<CommHoliday> commHolidays = listCommHolidaysByYear(date);
        Map<String,Integer> dateAndTypeMap = new HashMap<>();
        for (CommHoliday commHoliday : commHolidays){
            dateAndTypeMap.put(commHoliday.getDateValue(),commHoliday.getType());
        }
        return dateAndTypeMap;
    }

    /**
     * 获节假日的 true/false 值 [工作日：false 星期或节假日：true]
     * @param date
     * @return
     */
    public Map<String,Boolean> mapCommHolidaysBooleanByYear(Date date){
        List<CommHoliday> commHolidays = listCommHolidaysByYear(date);
        Map<String,Boolean> dateAndTypeMap = new HashMap<>();
        for (CommHoliday commHoliday : commHolidays){
            dateAndTypeMap.put(commHoliday.getDateValue(),DateUtil.checkHolidayByType(commHoliday.getType()+""));
        }
        return dateAndTypeMap;
    }

    /**
     * 重新获取法定节假日 并批量保存
     * @param date
     * @param year
     */
    public void anewFetchAndInsertCommHolidayByYear(Date date,String year){
        List<String> daysOfYearList = DateUtil.fetchDayOfYear(date);
        List<CommHoliday> newCommHolidays = new ArrayList<>();
        for (String dateValue : daysOfYearList){
            int dateType = DateUtil.fetchStatutoryHolidayType(dateValue);
            CommHoliday commHoliday = new CommHoliday();
            commHoliday.setDateValue(dateValue);
            commHoliday.setYearValue(year);
            commHoliday.setType(dateType);
            newCommHolidays.add(commHoliday);
        }
        commHolidayService.batchAddCommHoliday(newCommHolidays);
    }

    public void addCommHoliday(CommHoliday commHoliday){
        commHolidayService.addCommHoliday(commHoliday);
    }

    public void batchAddCommHoliday(List<CommHoliday> commHolidays){
        commHolidayService.batchAddCommHoliday(commHolidays);
    }

    /**
	 * 根据快递名称查询快递CODE
	 */
	public String findExpressCodeByExpressName(String ExpressName){
		return commDictionaryService.findExpressCodeByExpressName(ExpressName);
	}

    public List<CommDictionary> listDictionaryByCond(CommDictionaryCond cond) {
        return commDictionaryService.listDictionaryByCond(cond);
    }

    public CommDictionary listDictionaryByTypeAndValue(String dictType,String dictValue) {
        CommDictionaryCond cond = new CommDictionaryCond();
        cond.setDictType(dictType);
        cond.setDictValue(dictValue);
        List<CommDictionary> commDictionaries = listDictionaryByCond(cond);
        if (CollectionUtils.isNotEmpty(commDictionaries)){
            return commDictionaries.get(0);
        }
        return null;
    }

    public List<CommDictionary> listDicCommodityStatusByCond(CommDictionaryCond cond) {
        if (EmptyUtil.isEmpty(cond)){
            cond = new CommDictionaryCond();
            cond.setDictType(CommDictionaryVO.DICT_TYPE_COMMODITY_STATUS);
            cond.setOrderBy(" DICT_ORDER ASC ");
        }
        return commDictionaryService.listDictionaryByCond(cond);
    }

    public Map<String, String> getCommDictionaryMap(String dictType) {
	    return commDictionaryService.getCommDictionaryMap(dictType);
    }

    public List<CommDictionary> findDicCommodityStatusFromCache() {
        return commDictionaryService.findDicCommodityStatus();
    }

   public String synchronizeTmallShip(Long tid, String companyCode, String deliveryCode) throws ApiException {
     return commTmallService.synchronizeTmallShip(tid, companyCode,deliveryCode );
   }

    public ItemQuantityUpdateResponse synCommodityStocks(String channelCode, Long numIid, String outerId, long quantity) throws Exception {
	    return commTmallService.synCommodityStocks(channelCode, numIid, outerId, quantity);
    }

    public Date getTmallOrderPayTimeByTid(Long tid) {
	    return commTmallService.getTmallOrderPayTimeByTid(tid);
    }

    public List<TmallTbRefundDTO> getTmallRefunds(Date startDate, Date endDate) throws HttpException, IOException {
	    return commTmallService.getTmallRefunds(startDate, endDate);
    }
    
    public NextoneLogisticsWarehouseUpdateResponseDTO tmallAgWarehouseUpdate(Long refundId,String channelCode) throws ApiException{
    	return commTmallService.tmallAgWarehouseUpdate(refundId,channelCode);
    }
  }