/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.util.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.api.DefaultTaobaoClient;
import com.taobao.api.TaobaoRequest;
import com.taobao.api.request.ItemSellerGetRequest;
import com.taobao.api.request.ItemsCustomGetRequest;
import com.taobao.api.request.SkusCustomGetRequest;
import com.taobao.api.request.UmpPromotionGetRequest;
import com.taobao.api.response.ItemSellerGetResponse;
import com.taobao.api.response.ItemsCustomGetResponse;
import com.taobao.api.response.SkusCustomGetResponse;
import com.taobao.api.response.UmpPromotionGetResponse;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.service.CommTmallService;
import com.thebeastshop.pegasus.util.vo.TmallSku;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service(value="commTmallService")
public class CommTmallServiceImpl
implements CommTmallService {
    @Override
    public Long getSkuNumIid(String outerId, String sessionKey) throws Exception {
        DefaultTaobaoClient client = new DefaultTaobaoClient("http://gw.api.taobao.com/router/rest", "23696381", "5a7c8cd50681a4ce10ce927e2448bd23");
        SkusCustomGetRequest req = new SkusCustomGetRequest();
        req.setOuterId(outerId);
        req.setFields("sku_id,properties, num_iid, quantity");
        SkusCustomGetResponse rsp = (SkusCustomGetResponse)client.execute((TaobaoRequest)req, sessionKey);
        JSONObject response = JSONObject.parseObject((String)rsp.getBody()).getJSONObject("skus_custom_get_response");
        if (response.toString().equals("{}")) {
            DefaultTaobaoClient client1 = new DefaultTaobaoClient("http://gw.api.taobao.com/router/rest", "23696381", "5a7c8cd50681a4ce10ce927e2448bd23");
            ItemsCustomGetRequest itemsCustomGetRequest = new ItemsCustomGetRequest();
            itemsCustomGetRequest.setOuterId(outerId);
            itemsCustomGetRequest.setFields("num_iid,num");
            ItemsCustomGetResponse itemsCustomGetResponse = (ItemsCustomGetResponse)client1.execute((TaobaoRequest)itemsCustomGetRequest, sessionKey);
            JSONObject root = JSONObject.parseObject((String)itemsCustomGetResponse.getBody()).getJSONObject("items_custom_get_response");
            if (root.getJSONObject("items") != null) {
                JSONArray array = root.getJSONObject("items").getJSONArray("item");
                JSONObject item = (JSONObject)array.get(0);
                return item.getLong("num_iid");
            }
            return null;
        }
        JSONArray skus = JSON.parseArray((String)response.getJSONObject("skus").getString("sku"));
        Long numIid = null;
        ArrayList<TmallSku> skuList = new ArrayList<TmallSku>();
        if (EmptyUtil.isNotEmpty(skus)) {
            for (Object sku : skus) {
                JSONObject skuJson = (JSONObject)sku;
                int quantity = skuJson.getIntValue("quantity");
                numIid = skuJson.getLong("num_iid");
                JSONObject item = this.isCommonGood(sessionKey, numIid);
                String title = item.getString("title");
                TmallSku tmallSku = new TmallSku();
                tmallSku.setApproveStatus(item.getString("approve_status"));
                tmallSku.setNumIid(numIid);
                tmallSku.setQuantity(quantity);
                tmallSku.setTitle(item.getString("title"));
                skuList.add(tmallSku);
            }
            return this.getSkuNumIid(skuList);
        }
        return null;
    }

    private Long getSkuNumIid(List<TmallSku> skuList) {
        ArrayList<TmallSku> added = new ArrayList<TmallSku>();
        ArrayList<TmallSku> shelves = new ArrayList<TmallSku>();
        if (EmptyUtil.isNotEmpty(skuList)) {
            for (TmallSku tmallSku : skuList) {
                String title = tmallSku.getTitle();
                if (title.indexOf("\u805a") != -1 || title.indexOf("\u8303\u513f\u6d3b\u52a8") != -1 || title.indexOf("\u9884\u552e") != -1 || title.indexOf("\u79ef\u5206\u6362\u8d2d") != -1 || title.indexOf("\u79d2\u6740") != -1) continue;
                if (tmallSku.getApproveStatus().equals("onsale")) {
                    added.add(tmallSku);
                    continue;
                }
                shelves.add(tmallSku);
            }
        }
        if (EmptyUtil.isNotEmpty(added)) {
            return this.getMaxQuantitySku(added).getNumIid();
        }
        if (EmptyUtil.isNotEmpty(shelves)) {
            return this.getMaxQuantitySku(shelves).getNumIid();
        }
        return null;
    }

    private TmallSku getMaxQuantitySku(List<TmallSku> skuList) {
        int quantity = 0;
        TmallSku tmallSku = null;
        for (int i = 0; i < skuList.size(); ++i) {
            TmallSku forTmallSku = skuList.get(i);
            if (forTmallSku.getQuantity() < quantity) continue;
            quantity = forTmallSku.getQuantity();
            tmallSku = forTmallSku;
        }
        return tmallSku;
    }

    private JSONObject isCommonGood(String sessionKey, Long numIid) throws Exception {
        DefaultTaobaoClient client = new DefaultTaobaoClient("http://gw.api.taobao.com/router/rest", "23696381", "5a7c8cd50681a4ce10ce927e2448bd23");
        ItemSellerGetRequest req = new ItemSellerGetRequest();
        req.setFields("num_iid,title,nick,price,approve_status,sku");
        req.setNumIid(numIid);
        ItemSellerGetResponse rsp = (ItemSellerGetResponse)client.execute((TaobaoRequest)req, sessionKey);
        return JSONObject.parseObject((String)rsp.getBody()).getJSONObject("item_seller_get_response").getJSONObject("item");
    }

    @Override
    public int getSkuQuantity(String outerId, String sessionKey, Long numIid) throws Exception {
        DefaultTaobaoClient client = new DefaultTaobaoClient("http://gw.api.taobao.com/router/rest", "23696381", "5a7c8cd50681a4ce10ce927e2448bd23");
        SkusCustomGetRequest req = new SkusCustomGetRequest();
        req.setOuterId(outerId);
        req.setFields("sku_id,properties, num_iid, quantity,outer_id");
        int skuQuantity = 0;
        SkusCustomGetResponse rsp = (SkusCustomGetResponse)client.execute((TaobaoRequest)req, sessionKey);
        JSONObject response = JSONObject.parseObject((String)rsp.getBody()).getJSONObject("skus_custom_get_response");
        if (response.toString().equals("{}")) {
            DefaultTaobaoClient client1 = new DefaultTaobaoClient("http://gw.api.taobao.com/router/rest", "23696381", "5a7c8cd50681a4ce10ce927e2448bd23");
            ItemsCustomGetRequest itemsCustomGetRequest = new ItemsCustomGetRequest();
            itemsCustomGetRequest.setOuterId(outerId);
            itemsCustomGetRequest.setFields("num_iid,num");
            ItemsCustomGetResponse itemsCustomGetResponse = (ItemsCustomGetResponse)client1.execute((TaobaoRequest)itemsCustomGetRequest, sessionKey);
            JSONArray array = JSONObject.parseObject((String)itemsCustomGetResponse.getBody()).getJSONObject("items_custom_get_response").getJSONObject("items").getJSONArray("item");
            JSONObject item = (JSONObject)array.get(0);
            skuQuantity = item.getInteger("num");
        } else {
            JSONArray skus = JSON.parseArray((String)response.getJSONObject("skus").getString("sku"));
            if (EmptyUtil.isNotEmpty(skus)) {
                for (Object sku : skus) {
                    JSONObject skuJson = (JSONObject)sku;
                    if (!outerId.equals(skuJson.get((Object)"outer_id"))) continue;
                    if (skuJson.getLong("num_iid").equals(numIid)) {
                        skuQuantity = skuJson.getIntValue("quantity");
                    }
                    if (numIid == null) {
                        skuQuantity = skuJson.getIntValue("quantity");
                    }
                    if (skuQuantity == 0) continue;
                    break;
                }
            }
        }
        return skuQuantity;
    }

    @Override
    public int getPromotionUmp(String sessionKey, Long numIid) throws Exception {
        DefaultTaobaoClient client = new DefaultTaobaoClient("http://gw.api.taobao.com/router/rest", "23696381", "5a7c8cd50681a4ce10ce927e2448bd23");
        UmpPromotionGetRequest req = new UmpPromotionGetRequest();
        req.setItemId(numIid);
        UmpPromotionGetResponse rsp = (UmpPromotionGetResponse)client.execute((TaobaoRequest)req, sessionKey);
        System.out.println(rsp.getBody());
        JSONObject response = JSONObject.parseObject((String)rsp.getBody()).getJSONObject("ump_promotion_get_response");
        JSONObject promotions = response.getJSONObject("promotions");
        JSONObject promotionInItem = promotions.getJSONObject("promotion_in_item");
        if ("{}".equals(promotionInItem.toString())) {
            return 0;
        }
        JSONArray promotionItems = promotionInItem.getJSONArray("promotion_in_item");
        for (Object promotionItem : promotionItems) {
            JSONObject promotion = (JSONObject)promotionItem;
            if (!"\u805a\u5212\u7b97".equals(promotion.getString("name"))) continue;
            return 1;
        }
        return 0;
    }
}

