/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.util.service.impl;

import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.FileUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.ObjectId;
import com.thebeastshop.pegasus.util.dao.CommFileMapper;
import com.thebeastshop.pegasus.util.exception.UtilException;
import com.thebeastshop.pegasus.util.model.CommFile;
import com.thebeastshop.pegasus.util.service.CommFileService;
import com.thebeastshop.pegasus.util.vo.FileRequestVO;
import com.thebeastshop.pegasus.util.vo.FileResponseVO;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="commFileServiceImpl")
public class CommFileServiceImpl
implements CommFileService,
InitializingBean {
    private final Logger log = LoggerFactory.getLogger(CommFileServiceImpl.class);
    @Autowired
    private CommFileMapper commFileMapper;
    @Value(value="${STORE_BASE_PATH}")
    private String __storePath;
    @Value(value="${STORE_PATH_SEPARATOR}")
    private String __pathSeparator;

    @PostConstruct
    public void init() {
        this.log.info("[Service] CommFileServiceImpl is initialing");
        this.log.info("[Service] CommFileServiceImpl __storePath is " + this.__storePath);
        this.log.info("[Service] CommFileServiceImpl __pathSeparator is " + this.__pathSeparator);
        this.log.info("[Service] CommFileServiceImpl is initilalied");
    }

    @Override
    public String getStorePath() {
        if (EmptyUtil.isEmpty(this.__storePath)) {
            throw new UtilException("UT2000", "__storePath is null");
        }
        return this.__storePath;
    }

    @Override
    public String getPathSeparator() {
        if (EmptyUtil.isEmpty(this.__pathSeparator)) {
            throw new UtilException("UT2000", "__pathSeparator is null");
        }
        return this.__pathSeparator;
    }

    public void afterPropertiesSet() throws Exception {
        this.createFileDir(this.__storePath);
    }

    @Override
    @Transactional
    public FileResponseVO store(FileRequestVO fileRequestVO) {
        if (EmptyUtil.isNotEmpty(fileRequestVO.getInputStream()) && EmptyUtil.isNotEmpty(fileRequestVO.getOriginalFilename()) && EmptyUtil.isNotEmpty(fileRequestVO.getExtName())) {
            Boolean isCreat = false;
            String finalPath = this.getFinalPath(fileRequestVO.getExtName());
            try {
                isCreat = FileUtil.InputStreamTOFile(fileRequestVO.getInputStream(), finalPath);
            }
            catch (IOException e) {
                this.log.error("[Service] CommFileServiceImpl ", (Throwable)e);
                this.deleteFile(finalPath);
            }
            if (isCreat.booleanValue()) {
                this.log.info("[Service] CommFileServiceImpl store File,filePath:" + finalPath);
                try {
                    CommFile record = this.create(fileRequestVO.getOriginalFilename(), finalPath);
                    if (NullUtil.isNotNull(record)) {
                        FileResponseVO fileResponseVO = new FileResponseVO();
                        BeanUtils.copyProperties((Object)record, (Object)fileResponseVO);
                        return fileResponseVO;
                    }
                    this.deleteFile(finalPath);
                }
                catch (Exception e) {
                    this.log.error("[Service] CommFileServiceImpl ", (Throwable)e);
                    this.deleteFile(finalPath);
                }
            }
        }
        return null;
    }

    @Override
    @Transactional
    public FileResponseVO storeAfterDelete(FileRequestVO fileRequestVO, long id) {
        this.deleteFileById(id);
        return this.store(fileRequestVO);
    }

    @Override
    public FileResponseVO storeImage(FileRequestVO fileRequestVO, Integer width, Integer height) {
        if (EmptyUtil.isNotEmpty(fileRequestVO.getInputStream()) && EmptyUtil.isNotEmpty(fileRequestVO.getOriginalFilename()) && EmptyUtil.isNotEmpty(fileRequestVO.getExtName())) {
            Boolean isCreat = false;
            String finalPath = this.getFinalPath(fileRequestVO.getExtName());
            try {
                if (EmptyUtil.isNotEmpty(width) && EmptyUtil.isNotEmpty(height)) {
                    isCreat = FileUtil.InputStreamTOFile(fileRequestVO.getInputStream(), finalPath);
                    if (isCreat.booleanValue()) {
                        FileUtil.resize(width, height, finalPath, true);
                    }
                } else {
                    isCreat = FileUtil.InputStreamTOFile(fileRequestVO.getInputStream(), finalPath);
                }
            }
            catch (IOException e) {
                this.log.error("[Service] CommFileServiceImpl ", (Throwable)e);
                this.deleteFile(finalPath);
            }
            if (isCreat.booleanValue()) {
                this.log.info("[Service] CommFileServiceImpl store File,filePath:" + finalPath);
                try {
                    CommFile record = this.create(fileRequestVO.getOriginalFilename(), finalPath);
                    if (NullUtil.isNotNull(record)) {
                        FileResponseVO fileResponseVO = new FileResponseVO();
                        BeanUtils.copyProperties((Object)record, (Object)fileResponseVO);
                        return fileResponseVO;
                    }
                    this.deleteFile(finalPath);
                }
                catch (Exception e) {
                    this.log.error("[Service] CommFileServiceImpl ", (Throwable)e);
                    this.deleteFile(finalPath);
                }
            }
        }
        return null;
    }

    @Override
    public FileResponseVO getFile(long id, boolean isread) {
        CommFile record;
        if (id > 0L && NullUtil.isNotNull(record = this.commFileMapper.selectByPrimaryKey(id))) {
            FileResponseVO fileResponseVO = new FileResponseVO();
            BeanUtils.copyProperties((Object)record, (Object)fileResponseVO);
            if (isread) {
                try {
                    fileResponseVO.setFileData(FileUtil.getByteFileData(fileResponseVO.getFilePath()));
                }
                catch (IOException e) {
                    this.log.error("", (Throwable)e);
                }
            }
            return fileResponseVO;
        }
        return null;
    }

    @Override
    @Transactional
    public Boolean deleteFileById(long id) {
        if (EmptyUtil.isEmpty(id)) {
            throw new UtilException("UT2002", "file id is null");
        }
        CommFile commFile = this.commFileMapper.selectByPrimaryKey(id);
        if (NullUtil.isNull(commFile)) {
            throw new UtilException("UT2002", "commFile is null");
        }
        if (commFile.getIsDelete().equals(1)) {
            throw new UtilException("UT2002", "commFile update failed");
        }
        if (EmptyUtil.isEmpty(commFile.getFilePath())) {
            throw new UtilException("UT2002", "filePath is null");
        }
        commFile.setIsDelete(1);
        if (this.commFileMapper.updateByPrimaryKey(commFile) == 0) {
            throw new UtilException("UT2002", "commFile update failed");
        }
        this.deleteFile(commFile.getFilePath());
        return true;
    }

    @Override
    public Boolean modifyFileName(long id, String fileName) {
        if (EmptyUtil.isEmpty(id)) {
            throw new UtilException("UT2002", "file id is null");
        }
        CommFile commFile = this.commFileMapper.selectByPrimaryKey(id);
        if (NullUtil.isNull(commFile)) {
            throw new UtilException("UT2002", "commFile is null");
        }
        if (EmptyUtil.isEmpty(commFile.getFilePath())) {
            throw new UtilException("UT2002", "filePath is null");
        }
        if (!commFile.getFileName().equals(fileName)) {
            commFile.setFileName(fileName);
            if (this.commFileMapper.updateByPrimaryKey(commFile) == 0) {
                throw new UtilException("UT2002", "commFile update failed");
            }
        }
        return true;
    }

    private synchronized String getFinalPath(String extName) {
        String fileDir = this.__storePath + this.__pathSeparator + DateUtil.format(new Date(), "YYYYMMDD");
        this.createFileDir(fileDir);
        return fileDir + this.__pathSeparator + ObjectId.get() + "." + extName;
    }

    private void deleteFile(String filePath) {
        File file = new File(filePath);
        if (file.exists() && file.canRead()) {
            file.delete();
            this.log.info("[Service] CommFileServiceImpl filePath[" + filePath + "] is exists and deleted");
        } else {
            this.log.info("[Service] CommFileServiceImpl filePath[" + filePath + "] is not exists and not deleted");
        }
    }

    @Transactional
    private CommFile create(String originalFilename, String finalPath) {
        CommFile record = new CommFile();
        record.setCreateTime(new Date());
        record.setFileName(originalFilename);
        record.setFilePath(finalPath);
        record.setIsDelete(0);
        this.commFileMapper.insertSelective(record);
        return record;
    }

    private void createFileDir(String dir) {
        String filePath = dir;
        File fileDir = new File(filePath);
        if (!fileDir.exists() && !fileDir.isDirectory()) {
            fileDir.mkdir();
            this.log.info("[Service] CommFileServiceImpl mkdir " + dir);
        }
    }
}

