/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.util.service.impl;

import com.thebeastshop.pegasus.util.cond.CommDictionaryCond;
import com.thebeastshop.pegasus.util.dao.CommCurrencyMapper;
import com.thebeastshop.pegasus.util.dao.CommDictionaryMapper;
import com.thebeastshop.pegasus.util.dao.CommTaxRateMapper;
import com.thebeastshop.pegasus.util.model.CommCurrency;
import com.thebeastshop.pegasus.util.model.CommCurrencyExample;
import com.thebeastshop.pegasus.util.model.CommDictionary;
import com.thebeastshop.pegasus.util.model.CommTaxRate;
import com.thebeastshop.pegasus.util.model.CommTaxRateExample;
import com.thebeastshop.pegasus.util.service.CommDictionaryService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="commDictionaryService")
public class CommDictionaryServiceImpl
implements CommDictionaryService {
    private final Logger log = LoggerFactory.getLogger(CommDictionaryServiceImpl.class);
    private List<CommCurrency> __cachedCurrencyList;
    private List<CommTaxRate> __cachedTaxRateList;
    @Autowired
    private CommCurrencyMapper commCurrencyMapper;
    @Autowired
    private CommTaxRateMapper commTaxRateMapper;
    @Autowired
    private CommDictionaryMapper commDictionaryMapper;

    @PostConstruct
    public void init() {
        this.refreshCurrency();
        this.refreshTaxRate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshCurrency() {
        CommDictionaryServiceImpl commDictionaryServiceImpl = this;
        synchronized (commDictionaryServiceImpl) {
            this.log.info("CommDictionaryService.refreshCurrency start");
            CommCurrencyExample commCurrencyExample = new CommCurrencyExample();
            commCurrencyExample.setOrderByClause("id");
            this.__cachedCurrencyList = this.commCurrencyMapper.selectByExample(commCurrencyExample);
            this.log.info("CommDictionaryService.refreshCurrency finish");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshTaxRate() {
        CommDictionaryServiceImpl commDictionaryServiceImpl = this;
        synchronized (commDictionaryServiceImpl) {
            this.log.info("CommDictionaryService.refreshTaxRate start");
            CommTaxRateExample commTaxRateExample = new CommTaxRateExample();
            commTaxRateExample.setOrderByClause("id");
            this.__cachedTaxRateList = this.commTaxRateMapper.selectByExample(commTaxRateExample);
            this.log.info("CommDictionaryService.refreshTaxRate finish");
        }
    }

    @Override
    public List<CommCurrency> findAllCurrency() {
        ArrayList<CommCurrency> result = new ArrayList<CommCurrency>();
        try {
            for (CommCurrency commCurrency : this.__cachedCurrencyList) {
                CommCurrency _currency = new CommCurrency();
                PropertyUtils.copyProperties((Object)_currency, (Object)commCurrency);
                result.add(_currency);
            }
        }
        catch (Exception e) {
            this.log.warn("", (Throwable)e);
        }
        return result;
    }

    @Override
    public List<CommTaxRate> findAllTaxRate() {
        ArrayList<CommTaxRate> result = new ArrayList<CommTaxRate>();
        try {
            for (CommTaxRate commTaxRate : this.__cachedTaxRateList) {
                if (commTaxRate.getRateType() != 0) continue;
                CommTaxRate _taxRate = new CommTaxRate();
                PropertyUtils.copyProperties((Object)_taxRate, (Object)commTaxRate);
                result.add(_taxRate);
            }
        }
        catch (Exception e) {
            this.log.warn("", (Throwable)e);
        }
        return result;
    }

    @Override
    public List<CommTaxRate> findTaxRateByType(Integer type) {
        ArrayList<CommTaxRate> result = new ArrayList<CommTaxRate>();
        try {
            for (CommTaxRate commTaxRate : this.__cachedTaxRateList) {
                if (commTaxRate.getRateType() != type) continue;
                CommTaxRate _taxRate = new CommTaxRate();
                PropertyUtils.copyProperties((Object)_taxRate, (Object)commTaxRate);
                result.add(_taxRate);
            }
        }
        catch (Exception e) {
            this.log.warn("", (Throwable)e);
        }
        return result;
    }

    @Override
    public List<CommDictionary> findDictionaryByType(String dictType) {
        return this.commDictionaryMapper.findDictionaryByType(dictType);
    }

    @Override
    public List<CommDictionary> findDictionaryByCond(CommDictionaryCond cond) {
        return this.commDictionaryMapper.findDictionaryByCond(cond);
    }
}

