/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.util.service.impl;

import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.dao.CommCityMapper;
import com.thebeastshop.pegasus.util.dao.CommCountryMapper;
import com.thebeastshop.pegasus.util.dao.CommDistrictMapper;
import com.thebeastshop.pegasus.util.dao.CommProvinceMapper;
import com.thebeastshop.pegasus.util.model.CommCity;
import com.thebeastshop.pegasus.util.model.CommCityExample;
import com.thebeastshop.pegasus.util.model.CommCountry;
import com.thebeastshop.pegasus.util.model.CommCountryExample;
import com.thebeastshop.pegasus.util.model.CommDistrict;
import com.thebeastshop.pegasus.util.model.CommDistrictExample;
import com.thebeastshop.pegasus.util.model.CommProvince;
import com.thebeastshop.pegasus.util.model.CommProvinceExample;
import com.thebeastshop.pegasus.util.service.CommAddressService;
import com.thebeastshop.pegasus.util.vo.Region;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="commAddressService")
public class CommAddressServiceImpl
implements CommAddressService {
    private final Logger log = LoggerFactory.getLogger(CommAddressServiceImpl.class);
    private Map<Long, CommCountry> __cachedCountryMap;
    @Autowired
    private CommCountryMapper commCountryMapper;
    @Autowired
    private CommProvinceMapper commProvinceMapper;
    @Autowired
    private CommCityMapper commCityMapper;
    @Autowired
    private CommDistrictMapper commDistrictMapper;

    @PostConstruct
    public void init() {
        this.refreshCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshCache() {
        CommAddressServiceImpl commAddressServiceImpl = this;
        synchronized (commAddressServiceImpl) {
            this.log.info("CommAddressService.refreshCache start");
            CommCountryExample countryExample = new CommCountryExample();
            countryExample.setOrderByClause("id");
            List<CommCountry> allCountryList = this.commCountryMapper.selectByExample(countryExample);
            this.log.debug("allCountryList.size=" + allCountryList.size());
            CommProvinceExample commProvinceExample = new CommProvinceExample();
            commProvinceExample.setOrderByClause("id");
            List<CommProvince> allProvinceList = this.commProvinceMapper.selectByExample(commProvinceExample);
            this.log.debug("allProvinceList.size=" + allProvinceList.size());
            CommCityExample commCityExample = new CommCityExample();
            commCityExample.setOrderByClause("id");
            List<CommCity> allCitylist = this.commCityMapper.selectByExample(commCityExample);
            this.log.debug("allCitylist.size=" + allCitylist.size());
            CommDistrictExample districtExample = new CommDistrictExample();
            districtExample.setOrderByClause("id");
            List<CommDistrict> allDistrictList = this.commDistrictMapper.selectByExample(districtExample);
            this.log.debug("allDistrictList.size=" + allDistrictList.size());
            ConcurrentHashMap<Long, CommCountry> tmp = new ConcurrentHashMap<Long, CommCountry>();
            for (CommCountry commCountry : allCountryList) {
                tmp.put(commCountry.getId(), commCountry);
                ArrayList<CommProvince> provinceList = new ArrayList<CommProvince>();
                commCountry.setProvinceList(provinceList);
                for (CommProvince commProvince : allProvinceList) {
                    if (!commCountry.getId().equals(commProvince.getCountryId())) continue;
                    provinceList.add(commProvince);
                    ArrayList<CommCity> cityList = new ArrayList<CommCity>();
                    commProvince.setCityList(cityList);
                    for (CommCity commCity : allCitylist) {
                        if (!commProvince.getId().equals(commCity.getProvinceId())) continue;
                        cityList.add(commCity);
                        ArrayList<CommDistrict> districtList = new ArrayList<CommDistrict>();
                        commCity.setDistrictList(districtList);
                        for (CommDistrict commDistrict : allDistrictList) {
                            if (!commCity.getId().equals(commDistrict.getCityId())) continue;
                            districtList.add(commDistrict);
                        }
                    }
                }
            }
            this.__cachedCountryMap = tmp;
            this.log.info("CommAddressService.refreshCache finish");
        }
    }

    @Override
    public List<CommCountry> findAllCountry(boolean cascade) {
        ArrayList<CommCountry> result = new ArrayList<CommCountry>();
        try {
            for (CommCountry commCountry : this.__cachedCountryMap.values()) {
                CommCountry _country = new CommCountry();
                PropertyUtils.copyProperties((Object)_country, (Object)commCountry);
                result.add(_country);
                if (cascade) {
                    ArrayList<CommProvince> _provinceList = new ArrayList<CommProvince>();
                    _country.setProvinceList(_provinceList);
                    for (CommProvince commProvince : commCountry.getProvinceList()) {
                        CommProvince _province = new CommProvince();
                        PropertyUtils.copyProperties((Object)_province, (Object)commProvince);
                        _provinceList.add(_province);
                        ArrayList<CommCity> _cityList = new ArrayList<CommCity>();
                        _province.setCityList(_cityList);
                        for (CommCity commCity : commProvince.getCityList()) {
                            CommCity _city = new CommCity();
                            PropertyUtils.copyProperties((Object)_city, (Object)commCity);
                            _cityList.add(_city);
                            ArrayList<CommDistrict> _districtList = new ArrayList<CommDistrict>();
                            _city.setDistrictList(_districtList);
                            for (CommDistrict commDistrict : commCity.getDistrictList()) {
                                CommDistrict _district = new CommDistrict();
                                PropertyUtils.copyProperties((Object)_district, (Object)commDistrict);
                                _districtList.add(_district);
                            }
                        }
                    }
                    continue;
                }
                _country.setProvinceList(new ArrayList<CommProvince>());
            }
        }
        catch (Exception e) {
            this.log.warn("", (Throwable)e);
        }
        return result;
    }

    @Override
    public CommCountry findCountryById(Long id, boolean cascade) {
        try {
            for (CommCountry commCountry : this.__cachedCountryMap.values()) {
                if (!commCountry.getId().equals(id)) continue;
                CommCountry result = new CommCountry();
                PropertyUtils.copyProperties((Object)result, (Object)commCountry);
                ArrayList<CommProvince> _provinceList = new ArrayList<CommProvince>();
                result.setProvinceList(_provinceList);
                if (cascade) {
                    for (CommProvince commProvince : commCountry.getProvinceList()) {
                        CommProvince _province = new CommProvince();
                        PropertyUtils.copyProperties((Object)_province, (Object)commProvince);
                        _provinceList.add(_province);
                        ArrayList<CommCity> _cityList = new ArrayList<CommCity>();
                        _province.setCityList(_cityList);
                        for (CommCity commCity : commProvince.getCityList()) {
                            CommCity _city = new CommCity();
                            PropertyUtils.copyProperties((Object)_city, (Object)commCity);
                            _cityList.add(_city);
                            ArrayList<CommDistrict> _districtList = new ArrayList<CommDistrict>();
                            _city.setDistrictList(_districtList);
                            for (CommDistrict commDistrict : commCity.getDistrictList()) {
                                CommDistrict _district = new CommDistrict();
                                PropertyUtils.copyProperties((Object)_district, (Object)commDistrict);
                                _districtList.add(_district);
                            }
                        }
                    }
                }
                return result;
            }
        }
        catch (Exception e) {
            this.log.warn("", (Throwable)e);
        }
        return null;
    }

    @Override
    public CommCountry findCountryByName(String name) {
        for (CommCountry commCountry : this.__cachedCountryMap.values()) {
            if (!commCountry.getName().equals(name)) continue;
            return commCountry;
        }
        return null;
    }

    @Override
    public List<CommProvince> findProvinceByCountryId(Long countryId, boolean cascade) {
        ArrayList<CommProvince> result = new ArrayList<CommProvince>();
        CommCountry commCountry = this.findCountryById(countryId, true);
        if (commCountry != null) {
            for (CommProvince commProvince : commCountry.getProvinceList()) {
                result.add(commProvince);
                if (cascade) continue;
                commProvince.setCityList(new ArrayList<CommCity>());
            }
        }
        return result;
    }

    @Override
    public CommProvince findProvinceById(Long id, boolean cascade) {
        try {
            for (CommCountry commCountry : this.__cachedCountryMap.values()) {
                for (CommProvince commProvince : commCountry.getProvinceList()) {
                    if (!commProvince.getId().equals(id)) continue;
                    CommProvince result = new CommProvince();
                    PropertyUtils.copyProperties((Object)result, (Object)commProvince);
                    ArrayList<CommCity> _cityList = new ArrayList<CommCity>();
                    result.setCityList(_cityList);
                    if (cascade) {
                        for (CommCity commCity : commProvince.getCityList()) {
                            CommCity _city = new CommCity();
                            PropertyUtils.copyProperties((Object)_city, (Object)commCity);
                            _cityList.add(_city);
                            ArrayList<CommDistrict> _districtList = new ArrayList<CommDistrict>();
                            _city.setDistrictList(_districtList);
                            for (CommDistrict commDistrict : commCity.getDistrictList()) {
                                CommDistrict _district = new CommDistrict();
                                PropertyUtils.copyProperties((Object)_district, (Object)commDistrict);
                                _districtList.add(_district);
                            }
                        }
                    }
                    return result;
                }
            }
        }
        catch (Exception e) {
            this.log.warn("", (Throwable)e);
        }
        return null;
    }

    @Override
    public List<CommProvince> findProvinceByCond(String cond) {
        CommProvinceExample example = new CommProvinceExample();
        example.createCriteria().andFullNameLike("%" + cond + "%");
        return this.commProvinceMapper.selectByExample(example);
    }

    @Override
    public List<CommCity> findCityByProvinceId(Long provinceId, boolean cascade) {
        ArrayList<CommCity> result = new ArrayList<CommCity>();
        CommProvince commProvince = this.findProvinceById(provinceId, true);
        if (commProvince != null) {
            for (CommCity commCity : commProvince.getCityList()) {
                result.add(commCity);
                if (cascade) continue;
                commCity.setDistrictList(new ArrayList<CommDistrict>());
            }
        }
        return result;
    }

    @Override
    public List<CommCity> findCityByProvinceIdList(List<Long> provinceIdList, boolean cascade) {
        ArrayList<CommCity> cityList = new ArrayList<CommCity>();
        for (int i = 0; i < provinceIdList.size(); ++i) {
            Long id = provinceIdList.get(i);
            List<CommCity> list = this.findCityByProvinceId(id, cascade);
            cityList.addAll(list);
        }
        return cityList;
    }

    @Override
    public CommCity findCityById(Long id, boolean cascade) {
        try {
            for (CommCountry commCountry : this.__cachedCountryMap.values()) {
                for (CommProvince commProvince : commCountry.getProvinceList()) {
                    for (CommCity commCity : commProvince.getCityList()) {
                        if (!commCity.getId().equals(id)) continue;
                        CommCity result = new CommCity();
                        PropertyUtils.copyProperties((Object)result, (Object)commCity);
                        ArrayList<CommDistrict> _districtList = new ArrayList<CommDistrict>();
                        result.setDistrictList(_districtList);
                        if (cascade) {
                            for (CommDistrict commDistrict : commCity.getDistrictList()) {
                                CommDistrict _district = new CommDistrict();
                                PropertyUtils.copyProperties((Object)_district, (Object)commDistrict);
                                _districtList.add(_district);
                            }
                        }
                        return result;
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.warn("", (Throwable)e);
        }
        return null;
    }

    @Override
    public List<CommCity> findCityByIds(List<Long> ids, boolean cascade) {
        ArrayList<CommCity> list = new ArrayList<CommCity>();
        if (EmptyUtil.isNotEmpty(ids)) {
            for (Long id : ids) {
                CommCity city = this.findCityById(id, cascade);
                if (!NullUtil.isNotNull(city)) continue;
                list.add(city);
            }
        }
        return list;
    }

    @Override
    public List<CommDistrict> findDistrictByCityId(Long cityId) {
        ArrayList<CommDistrict> result = new ArrayList<CommDistrict>();
        CommCity commCity = this.findCityById(cityId, true);
        if (commCity != null) {
            for (CommDistrict commDistrict : commCity.getDistrictList()) {
                result.add(commDistrict);
            }
        }
        return result;
    }

    @Override
    public CommDistrict findDistrictById(Long id) {
        try {
            for (CommCountry commCountry : this.__cachedCountryMap.values()) {
                for (CommProvince commProvince : commCountry.getProvinceList()) {
                    for (CommCity commCity : commProvince.getCityList()) {
                        for (CommDistrict commDistrict : commCity.getDistrictList()) {
                            if (!commDistrict.getId().equals(id)) continue;
                            CommDistrict result = new CommDistrict();
                            PropertyUtils.copyProperties((Object)result, (Object)commDistrict);
                            return result;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.warn("", (Throwable)e);
        }
        return null;
    }

    @Override
    public List<CommDistrict> findDistrictByIds(List<Long> ids) {
        ArrayList<CommDistrict> list = new ArrayList<CommDistrict>();
        if (EmptyUtil.isNotEmpty(ids)) {
            for (Long id : ids) {
                CommDistrict district = this.findDistrictById(id);
                if (!NullUtil.isNotNull(district)) continue;
                list.add(district);
            }
        }
        return list;
    }

    @Override
    public List<CommCity> findCityByCond(String cond) {
        CommCityExample example = new CommCityExample();
        example.createCriteria().andFullNameLike("%" + cond + "%");
        return this.commCityMapper.selectByExample(example);
    }

    @Override
    public List<CommDistrict> findDistrictByCond(String cond) {
        CommDistrictExample example = new CommDistrictExample();
        example.createCriteria().andFullNameLike("%" + cond + "%");
        return this.commDistrictMapper.selectByExample(example);
    }

    @Override
    public List<CommDistrict> findDistrictByProvinceId(long id) {
        List<CommCity> cityList = this.findCityByProvinceId(id, true);
        LinkedList<CommDistrict> districtList = new LinkedList<CommDistrict>();
        for (CommCity commCity : cityList) {
            if (!CollectionUtils.isNotEmpty(commCity.getDistrictList())) continue;
            districtList.addAll(commCity.getDistrictList());
        }
        if (CollectionUtils.isEmpty(districtList)) {
            return Collections.emptyList();
        }
        return districtList;
    }

    @Override
    public List<Long> findDistrictIdByProvinceId(long id) {
        List<CommDistrict> districtList = this.findDistrictByProvinceId(id);
        ArrayList<Long> idList = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty(districtList)) {
            for (CommDistrict commDistrict : districtList) {
                idList.add(commDistrict.getId());
            }
        }
        if (CollectionUtils.isEmpty(idList)) {
            return Collections.emptyList();
        }
        return idList;
    }

    @Override
    public List<CommCountry> findForeignCountry(String countryName, boolean cascade) {
        return this.commCountryMapper.findForeignCountryByCond(countryName);
    }

    @Override
    public CommDistrict getDistrictIdByRegion(Region region) {
        CommProvince province = this.commProvinceMapper.selectByName(region.getProvince());
        if (EmptyUtil.isEmpty(province)) {
            return null;
        }
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("id", province.getId());
        parameter.put("name", region.getCity());
        CommCity commCity = this.commCityMapper.selectByCityName(parameter);
        if (EmptyUtil.isEmpty(commCity)) {
            return null;
        }
        parameter.put("id", commCity.getId());
        parameter.put("name", region.getDistrict());
        CommDistrict district = this.commDistrictMapper.selectByDistrictName(parameter);
        if (district == null) {
            parameter.put("name", "\u5176\u5b83\u533a");
            district = this.commDistrictMapper.selectByDistrictName(parameter);
            if (district == null) {
                return district;
            }
            district.setMatch(false);
        }
        return district;
    }

    @Override
    public List<CommCity> getShopCity(List list) {
        return this.commCityMapper.getShopCity(list);
    }
}

