/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.util.route;

import com.thebeastshop.pegasus.util.route.DBType;
import com.thebeastshop.pegasus.util.route.DBTypeHolder;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.aop.AfterReturningAdvice;
import org.springframework.aop.MethodBeforeAdvice;

public class ScmDataSourceRouteIntercepter
implements MethodBeforeAdvice,
AfterReturningAdvice {
    private List<String> readMethodPrefix;
    private boolean _is_can_route = false;
    private static final String _PATTERN_APPEND = ".*";

    public void before(Method method, Object[] args, Object target) throws Throwable {
        if (this._is_can_route) {
            String methodName = method.getName();
            for (String patternMethodPath : this.readMethodPrefix) {
                Pattern pattern = Pattern.compile(patternMethodPath);
                Matcher m = pattern.matcher(methodName);
                if (!m.matches()) continue;
                DBTypeHolder.setDBType(DBType.SLAVE);
                return;
            }
        }
    }

    public void setReadMethodPrefix(List<String> methodPrefixes) {
        if (CollectionUtils.isNotEmpty(methodPrefixes)) {
            this.readMethodPrefix = new ArrayList<String>();
            for (String prefix : methodPrefixes) {
                this.readMethodPrefix.add(prefix + _PATTERN_APPEND);
            }
            this._is_can_route = true;
        }
    }

    public void afterReturning(Object returnValue, Method method, Object[] args, Object target) throws Throwable {
        DBTypeHolder.clearDBType();
    }
}

