/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.util.importExcel.write;

import com.thebeastshop.pegasus.util.importExcel.ErrorMessage;
import com.thebeastshop.pegasus.util.importExcel.ExcelColumn;
import com.thebeastshop.pegasus.util.importExcel.ExcelTemplate;
import com.thebeastshop.pegasus.util.importExcel.write.AbstractWriteExcel;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jxl.CellView;
import jxl.JXLException;
import jxl.Workbook;
import jxl.biff.FontRecord;
import jxl.format.CellFormat;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormats;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.JxlWriteException;
import jxl.write.biff.RowsExceededException;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.stereotype.Component;

@Component(value="writeExcel")
@Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
public class GenericWriteExcel
extends AbstractWriteExcel {
    private static final long serialVersionUID = 4632293456287402204L;
    protected List<String> errorMessages = new ArrayList<String>();
    protected Method getErrorMsgMethod;
    protected final SimpleDateFormat isoDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    protected final SimpleDateFormat isoTimeFormat = new SimpleDateFormat("hh:mm:ss.SSSZ");
    protected final SimpleDateFormat isoDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    protected final SimpleDateFormat dateTimeFormatForFileName = new SimpleDateFormat("yyyy-MM-dd-hh-mm-ss");
    protected List<String> headers = new ArrayList<String>();
    protected List<String> cellFormats = new ArrayList<String>();
    protected List<Field> ecFields = new ArrayList<Field>();
    protected File file;
    public static String FILE_PATH = File.separator + "home" + File.separator + "vmuser";
    protected WritableCellFormat boldText;
    protected WritableCellFormat normalText;
    protected Class<?> clazz;

    @Override
    public List<String> getErrors() {
        return this.errorMessages;
    }

    @Override
    public boolean hasError() {
        return this.errorMessages.size() > 0;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public void write(Class<?> clazz, List<?> datas) {
        this.write(clazz, datas, null);
    }

    @Override
    public void write(Class<?> clazz, List<?> datas, String fileName) {
        File path;
        this.clazz = clazz;
        this.errorMessages.clear();
        this.headers.clear();
        this.ecFields.clear();
        if (this.clazz != null) {
            this.initHeadersAndEcFields();
        }
        if (this.hasError()) {
            return;
        }
        if (this.clazz != null) {
            this.initErrorMessageMehtod();
        }
        if (!(path = new File(FILE_PATH + File.separator + "import_invalid_excel" + File.separator)).exists()) {
            path.mkdirs();
        }
        fileName = fileName == null || "".equals(fileName) ? this.dateTimeFormatForFileName.format(new Date()) + ".xls" : fileName + ".xls";
        this.file = new File(path, fileName);
        try {
            WritableWorkbook workbook = Workbook.createWorkbook((File)this.file);
            WritableFont boldFont = new WritableFont(WritableFont.ARIAL, 10, WritableFont.BOLD);
            boldFont.setPointSize(11);
            WritableFont normalFont = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD);
            normalFont.setPointSize(11);
            this.boldText = new WritableCellFormat(boldFont);
            this.normalText = new WritableCellFormat(normalFont);
            WritableSheet s = workbook.createSheet("sheet1", 0);
            this.writeHeader(s);
            this.writeContent(s, datas);
            workbook.write();
            workbook.close();
        }
        catch (IOException e) {
            this.errorMessages.add(e.getMessage());
            e.printStackTrace();
        }
        catch (WriteException e) {
            this.errorMessages.add(e.getMessage());
            e.printStackTrace();
        }
        catch (JXLException e) {
            this.errorMessages.add(e.getMessage());
            e.printStackTrace();
        }
    }

    private void initHeadersAndEcFields() {
        ExcelColumn ec;
        if (this.clazz == null) {
            this.errorMessages.add("clazz\u4e0d\u80fd\u4e3a\u7a7a!");
            return;
        }
        ExcelTemplate et = this.clazz.getAnnotation(ExcelTemplate.class);
        if (et == null) {
            this.errorMessages.add(this.clazz.getName() + "\u4e0d\u662fexcel\u6a21\u677f\u7c7b!");
            return;
        }
        ArrayList<Field> fieldsList = new ArrayList<Field>();
        for (Class<?> temp = this.clazz; temp != null && !temp.equals(Object.class) && temp.getAnnotation(ExcelTemplate.class) != null; temp = temp.getSuperclass()) {
            Field[] fs = temp.getDeclaredFields();
            for (int x = 0; x < fs.length; ++x) {
                ec = fs[x].getAnnotation(ExcelColumn.class);
                if (ec == null) continue;
                fieldsList.add(fs[x]);
            }
        }
        for (int i = 0; i < fieldsList.size(); ++i) {
            Field tfield = (Field)fieldsList.get(i);
            ec = tfield.getAnnotation(ExcelColumn.class);
            if (ec == null) continue;
            String columnName = ec.name().equals("") ? tfield.getName() : ec.name();
            String cellFormat = ec.cellFormat();
            this.ecFields.add(tfield);
            this.headers.add(columnName);
            this.cellFormats.add(cellFormat);
        }
        if (this.headers.size() < 1) {
            this.errorMessages.add("\u6ca1\u6709\u627e\u5230ExcelColumn!\u8bf7\u68c0\u67e5\u6a21\u677f\u7c7b!");
            return;
        }
    }

    private int writeHeader(WritableSheet s) throws RowsExceededException, JXLException {
        int row = 0;
        for (int i = 0; i < this.headers.size(); ++i) {
            Label l = new Label(i, 0, this.headers.get(i), (CellFormat)this.boldText);
            s.addCell((WritableCell)l);
            if (this.cellFormats.get(i) == null || !"TEXT".equals(this.cellFormats.get(i))) continue;
            WritableFont normalFont = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD);
            normalFont.setPointSize(11);
            WritableCellFormat normalText = new WritableCellFormat(NumberFormats.TEXT);
            normalText.setFont((FontRecord)normalFont);
            CellView cv = new CellView();
            cv.setFormat((CellFormat)normalText);
            cv.setSize(5300);
            s.setColumnView(i, cv);
        }
        return row + 1;
    }

    private int writeContent(WritableSheet s, List<?> datas) {
        try {
            for (int i = 0; i < datas.size(); ++i) {
                if (this.ecFields != null && this.ecFields.size() > 0) {
                    for (int j = 0; j < this.ecFields.size(); ++j) {
                        Method method = this.clazz.getMethod(this.generateGetMethod(this.ecFields.get(j).getName()), new Class[0]);
                        Object obj = method.invoke(datas.get(i), new Object[0]);
                        if (obj instanceof java.lang.Number) {
                            java.lang.Number value = null;
                            if (obj != null) {
                                value = (java.lang.Number)obj;
                            }
                            Number n = new Number(j, i + 1, value.doubleValue());
                            s.addCell((WritableCell)n);
                            continue;
                        }
                        Label l = null;
                        if (obj != null && this.ecFields.get(j).getType().getName().equals("java.util.Date")) {
                            DateTimeFormat dtf = this.ecFields.get(j).getAnnotation(DateTimeFormat.class);
                            if (dtf == null || dtf.iso().equals((Object)DateTimeFormat.ISO.NONE)) {
                                l = new Label(j, i + 1, this.isoDateFormat.format((Date)obj), (CellFormat)this.normalText);
                            } else {
                                String df = this.chooseISODateFormat(dtf.iso(), (Date)obj);
                                l = new Label(j, i + 1, df, (CellFormat)this.normalText);
                            }
                        } else {
                            l = new Label(j, i + 1, obj == null ? "" : obj.toString(), (CellFormat)this.normalText);
                        }
                        s.addCell((WritableCell)l);
                    }
                } else {
                    Object[] data = (Object[])datas.get(i);
                    for (int j = 0; j < data.length; ++j) {
                        Label l = null;
                        l = new Label(j, i + 1, data[j] == null ? "" : data[j].toString(), (CellFormat)this.normalText);
                        s.addCell((WritableCell)l);
                    }
                }
                if (this.getErrorMessage(datas.get(i)).length() <= 0) continue;
                Label l = new Label(this.ecFields.size(), i + 1, this.getErrorMessage(datas.get(i)), (CellFormat)this.normalText);
                s.addCell((WritableCell)l);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (JxlWriteException e) {
            e.printStackTrace();
        }
        catch (WriteException e) {
            e.printStackTrace();
        }
        return 0;
    }

    protected String chooseISODateFormat(DateTimeFormat.ISO iso, Date date) {
        if (iso.equals((Object)DateTimeFormat.ISO.DATE)) {
            return this.isoDateFormat.format(date);
        }
        if (iso.equals((Object)DateTimeFormat.ISO.TIME)) {
            return this.isoTimeFormat.format(date);
        }
        if (iso.equals((Object)DateTimeFormat.ISO.DATE_TIME)) {
            return this.isoDateTimeFormat.format(date);
        }
        return "yyyy-MM-dd";
    }

    protected void initErrorMessageMehtod() {
        Field[] fields = this.clazz.getDeclaredFields();
        try {
            for (int i = 0; i < fields.length; ++i) {
                ErrorMessage em = fields[i].getAnnotation(ErrorMessage.class);
                if (em == null) continue;
                this.getErrorMsgMethod = this.clazz.getMethod(this.generateGetMethod(fields[i].getName()), new Class[0]);
                break;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    protected String getErrorMessage(Object obj) {
        if (this.getErrorMsgMethod != null) {
            try {
                Object value = this.getErrorMsgMethod.invoke(obj, new Object[0]);
                return value == null ? "" : value.toString();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    protected String generateGetMethod(String fieldName) {
        if (fieldName == null || fieldName.length() < 1) {
            return "";
        }
        return "get" + fieldName.toUpperCase().charAt(0) + fieldName.substring(1);
    }

    public static void main(String[] args) {
        File path = new File("/import_invalid_excel/admin");
        if (!path.exists()) {
            path.mkdirs();
        }
    }
}

